package com.ejianc.business.zdsmaterial.plan.control.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 物资总控计划汇总
 *
 * @author generator
 *
 */
public class ControlPlanSumVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private String billName; // 单据名称
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 上级组织id
    private String parentOrgCode; // 上级组织编码
    private String parentOrgName; // 上级组织名称
    private Long engineerId; // 主责工程师
    private String engineerName; // 主责工程师名称
    private Long managerId; // 项目总工
    private String managerName; // 项目总工名称
    private String memo; // 备注
    private Integer newMatFlag; // 是否有新增材料编码：0-否，1-是
    private Integer billState; // 单据状态（审批必须字段）
    private Long projectManagerId; // 项目经理主键
    private String projectManagerName; // 项目经理名称
    private String createUserName; // 创建者名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date firstTime; // 初始签订日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date lastTime; // 最新汇总日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeTime; // 变更日期
    private Long changeId; // 变更主键
    private Integer changeStatus; // 变更状态：1-未变更，2-变更中，3-已变更
    private Integer changeVersion; // 变更版本
    private String materialTypeNames; // 材料分类
    private String changeStatusName; // 变更状态名称
    private String billStateName; // 单据状态名称
    private Long createUserId;// 制单人Id
    private Long exeOrgId; // 执行总部id
    private String exeOrgCode; // 执行总部编码
    private String exeOrgName; // 执行总部名称

    private List<ControlPlanSumDetailVO> detailList = new ArrayList<>(); // 物资总控计划汇总明细

    private List<ControlPlanVO> billList = new ArrayList<>(); // 编制情况子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getBillName() {
        return billName;
    }

    public void setBillName(String billName) {
        this.billName = billName;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEngineerId() {
        return engineerId;
    }

    @ReferDeserialTransfer
    public void setEngineerId(Long engineerId) {
        this.engineerId = engineerId;
    }

    public String getEngineerName() {
        return engineerName;
    }

    public void setEngineerName(String engineerName) {
        this.engineerName = engineerName;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getManagerId() {
        return managerId;
    }

    @ReferDeserialTransfer
    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }

    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getNewMatFlag() {
        return newMatFlag;
    }

    public void setNewMatFlag(Integer newMatFlag) {
        this.newMatFlag = newMatFlag;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectManagerId() {
        return projectManagerId;
    }

    public void setProjectManagerId(Long projectManagerId) {
        this.projectManagerId = projectManagerId;
    }
    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Date getFirstTime() {
        return firstTime;
    }

    public void setFirstTime(Date firstTime) {
        this.firstTime = firstTime;
    }
    public Date getLastTime() {
        return lastTime;
    }

    public void setLastTime(Date lastTime) {
        this.lastTime = lastTime;
    }
    public Date getChangeTime() {
        return changeTime;
    }

    public void setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public String getMaterialTypeNames() {
        return materialTypeNames;
    }

    public void setMaterialTypeNames(String materialTypeNames) {
        this.materialTypeNames = materialTypeNames;
    }

    public String getChangeStatusName() {
        return changeStatusName;
    }

    public void setChangeStatusName(String changeStatusName) {
        this.changeStatusName = changeStatusName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public Long getExeOrgId() {
        return exeOrgId;
    }

    public void setExeOrgId(Long exeOrgId) {
        this.exeOrgId = exeOrgId;
    }

    public String getExeOrgCode() {
        return exeOrgCode;
    }

    public void setExeOrgCode(String exeOrgCode) {
        this.exeOrgCode = exeOrgCode;
    }

    public String getExeOrgName() {
        return exeOrgName;
    }

    public void setExeOrgName(String exeOrgName) {
        this.exeOrgName = exeOrgName;
    }

    public List<ControlPlanSumDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ControlPlanSumDetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<ControlPlanVO> getBillList() {
        return billList;
    }

    public void setBillList(List<ControlPlanVO> billList) {
        this.billList = billList;
    }
}
