package com.ejianc.business.zdsmaterial.pick.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.pick.hystrix.ZdsPicketHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author yqls
 * @version 1.0
 * @description: 分包领料设置api
 * @date 2024/01/13
 */
@FeignClient(name = "ejc-zdsmaterial-web", url = "${common.env.feign-client-url}", path = "ejc-zdsmaterial-web", fallback = ZdsPicketHystrix.class)
public interface IZdsPicksetApi {

    /**
     * 根据项目+合同，查询分包领料设置范围，过滤末级分类
     * @Author yqls
     * @param projectId
     * @param contractId
     * @return
     */
    @GetMapping(value = "/api/pickset/filterMaterialTypeIds")
    CommonResponse<List<Long>> filterMaterialTypeIds(@RequestParam("projectId") Long projectId, @RequestParam("contractId") Long contractId);

    /**
     * 根据项目+仓库+领料人，扫码领料出库
     * @Author yqls
     * @param projectId
     * @param storeId
     * @param employeeId
     * @return
     */
    @GetMapping(value = "/api/pickset/scanOutStore")
    CommonResponse<JSONObject> scanOutStore(@RequestParam("projectId") Long projectId, @RequestParam("storeId") Long storeId,
        @RequestParam("employeeId") Long employeeId);
}
