package com.ejianc.business.zdsmaterial.plan.conjecture.vo;

import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertySubItemVO;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 物料识别历史匹配记录实体
 * 
 * @author generator
 * 
 */
public class MaterialConjectureVO extends BaseVO {

    private static final long serialVersionUID = -7179329874395743038L;

    private String importSeq; //导入序号
    private String identificationId; // 物料识别唯一标识
    private Date identificationDate; // 物料识别时间
    private String sourceCategoryCode; //导入物料分类编码
    private String sourceMaterialName; // 输入物料名称
    private String sourceMaterialSpec; // 输入项目特征
    private String sourceUnitName; //输入单位
    private BigDecimal sourceNum; //输入量
    private Long conjectureCategoryId; // 预测物料分类Id
    private String conjectureCategoryName; // 预测物料分类名称
    private Long conjectureMaterialId; // 预测物料Id
    private String conjectureMaterialName; // 预测物料名称
    private String conjectureMaterialSpec; // 预测物料属性
    private String conjectureMaterialSpecs; // 预测物料属性集合
    private String conjectureUnitName; // 预测物料单位
    private Integer adjustFlag; // 是否调整（0：否， 1：是）
    private Long actualCategoryId; // 最终物料分类Id
    private String actualCategoryName; // 最终物料分类名称
    private Long actualMaterialId; // 最终物料Id
    private String actualMaterialName; // 最终物料名称
    private String actualMaterialSpec; // 最终物料属性
    private String actualMaterialSpecs; // 最终物料属性集合
    private Long actualUnitId; // 最终单位Id
    private String actualUnitName; // 最终单位名称
    private BigDecimal actualNum; //最终量
    private Long billId; // 单据ID
    private String billCode; // 单据编码
    private String billType; // 单据类型
    List<MaterialCategoryPropertySubItemVO> specList = new ArrayList<>();
    private String ignoreFlag; // 是否忽略：0-否，1-是
    private String delFlag; // 是否作废：0-否，1-是
    private String loadState; // 加载状态：0-未加载，1-已加载，2-忽略不加载

    private String errorMsg; //错误描述
    private String mateType; // 匹配类型：4-待识别，0-不匹配，1-部分匹配，2-完全匹配，3-识别失败
    private String conjectureMateType; // 初始识别后匹配类型：4-待识别，0-不匹配，1-部分匹配，2-完全匹配，3-识别失败
    private String actualMaterialCode; //物料编码

    private BigDecimal similarCoefficient; //相似系数

    private String mode; //识别渠道：YQL-益企联AI识别,CJYT-长江云通

    private Long materialPackId; // 切包情况-材料包id，二级物料类别
    private String materialPackCode; // 切包情况-材料包编码
    private String materialPackName; // 切包情况-材料包名称
    private String itemCode; // 清单编码
    private String itemName; // 清单名称
    private String budgetType; // 1:切包请单内2：切包清单外
    private Long budgetDetailId; // 清单子表ID

    private BigDecimal sourceBasePrice;
    private BigDecimal actualBasePrice;
    private BigDecimal sourceBaseTwoPrice;
    private BigDecimal actualBaseTwoPrice;

    private BigDecimal sourceBaseOriginPrice;
    private BigDecimal actualBaseOriginPrice;

    private String brandName;//品牌名称
    private Long brandId; //品牌Id

    private Long supplierId; //供应商id
    private String supplierName; //物资供应商名称
    private String supplierCode; //物资供应商编码

    private String area; //区域
    private String areaName;//区域名称

    private String extParam1; //其他1
    private String extParam2; //其他2


    private Long actualSecCategoryId; // 最终物料二级分类Id
    private String actualSecCategoryName; // 最终物料二级分类名称
    private String actualSecCategoryCode; // 最终物料二级分类编码

    private String contractCode;
    private String contractName;
    private String projectName;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;
    private BigDecimal purchaseNum;//采购数量

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public BigDecimal getPurchaseNum() {
        return purchaseNum;
    }

    public void setPurchaseNum(BigDecimal purchaseNum) {
        this.purchaseNum = purchaseNum;
    }

    public Long getActualSecCategoryId() {
        return actualSecCategoryId;
    }

    public void setActualSecCategoryId(Long actualSecCategoryId) {
        this.actualSecCategoryId = actualSecCategoryId;
    }

    public String getActualSecCategoryName() {
        return actualSecCategoryName;
    }

    public void setActualSecCategoryName(String actualSecCategoryName) {
        this.actualSecCategoryName = actualSecCategoryName;
    }

    public String getActualSecCategoryCode() {
        return actualSecCategoryCode;
    }

    public void setActualSecCategoryCode(String actualSecCategoryCode) {
        this.actualSecCategoryCode = actualSecCategoryCode;
    }

    public String getExtParam1() {
        return extParam1;
    }

    public void setExtParam1(String extParam1) {
        this.extParam1 = extParam1;
    }

    public String getExtParam2() {
        return extParam2;
    }

    public void setExtParam2(String extParam2) {
        this.extParam2 = extParam2;
    }

    public BigDecimal getSourceBaseTwoPrice() {
        return sourceBaseTwoPrice;
    }

    public void setSourceBaseTwoPrice(BigDecimal sourceBaseTwoPrice) {
        this.sourceBaseTwoPrice = sourceBaseTwoPrice;
    }

    public BigDecimal getActualBaseTwoPrice() {
        return actualBaseTwoPrice;
    }

    public void setActualBaseTwoPrice(BigDecimal actualBaseTwoPrice) {
        this.actualBaseTwoPrice = actualBaseTwoPrice;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public BigDecimal getSourceBasePrice() {
        return sourceBasePrice;
    }

    public void setSourceBasePrice(BigDecimal sourceBasePrice) {
        this.sourceBasePrice = sourceBasePrice;
    }

    public BigDecimal getActualBasePrice() {
        return actualBasePrice;
    }

    public void setActualBasePrice(BigDecimal actualBasePrice) {
        this.actualBasePrice = actualBasePrice;
    }

    public BigDecimal getSourceBaseOriginPrice() {
        return sourceBaseOriginPrice;
    }

    public void setSourceBaseOriginPrice(BigDecimal sourceBaseOriginPrice) {
        this.sourceBaseOriginPrice = sourceBaseOriginPrice;
    }

    public BigDecimal getActualBaseOriginPrice() {
        return actualBaseOriginPrice;
    }

    public void setActualBaseOriginPrice(BigDecimal actualBaseOriginPrice) {
        this.actualBaseOriginPrice = actualBaseOriginPrice;
    }

    public Long getBudgetDetailId() {
        return budgetDetailId;
    }

    public void setBudgetDetailId(Long budgetDetailId) {
        this.budgetDetailId = budgetDetailId;
    }

    public String getBudgetType() {
        return budgetType;
    }

    public void setBudgetType(String budgetType) {
        this.budgetType = budgetType;
    }

    public Long getMaterialPackId() {
        return materialPackId;
    }

    public void setMaterialPackId(Long materialPackId) {
        this.materialPackId = materialPackId;
    }

    public String getMaterialPackCode() {
        return materialPackCode;
    }

    public void setMaterialPackCode(String materialPackCode) {
        this.materialPackCode = materialPackCode;
    }

    public String getMaterialPackName() {
        return materialPackName;
    }

    public void setMaterialPackName(String materialPackName) {
        this.materialPackName = materialPackName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getConjectureMateType() {
        return conjectureMateType;
    }

    public void setConjectureMateType(String conjectureMateType) {
        this.conjectureMateType = conjectureMateType;
    }

    public String getImportSeq() {
        return importSeq;
    }

    public void setImportSeq(String importSeq) {
        this.importSeq = importSeq;
    }

    public BigDecimal getSimilarCoefficient() {
        return similarCoefficient;
    }

    public void setSimilarCoefficient(BigDecimal similarCoefficient) {
        this.similarCoefficient = similarCoefficient;
    }

    public String getActualMaterialCode() {
        return actualMaterialCode;
    }

    public void setActualMaterialCode(String actualMaterialCode) {
        this.actualMaterialCode = actualMaterialCode;
    }

    public List<MaterialCategoryPropertySubItemVO> getSpecList() {
        return specList;
    }

    public void setSpecList(List<MaterialCategoryPropertySubItemVO> specList) {
        this.specList = specList;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getConjectureMaterialSpec() {
        return conjectureMaterialSpec;
    }

    public void setConjectureMaterialSpec(String conjectureMaterialSpec) {
        this.conjectureMaterialSpec = conjectureMaterialSpec;
    }

    public String getActualMaterialSpec() {
        return actualMaterialSpec;
    }

    public void setActualMaterialSpec(String actualMaterialSpec) {
        this.actualMaterialSpec = actualMaterialSpec;
    }

    public String getSourceCategoryCode() {
        return sourceCategoryCode;
    }

    public void setSourceCategoryCode(String sourceCategoryCode) {
        this.sourceCategoryCode = sourceCategoryCode;
    }

    public BigDecimal getSourceNum() {
        return sourceNum;
    }

    public void setSourceNum(BigDecimal sourceNum) {
        this.sourceNum = sourceNum;
    }

    public BigDecimal getActualNum() {
        return actualNum;
    }

    public void setActualNum(BigDecimal actualNum) {
        this.actualNum = actualNum;
    }

    public String getSourceUnitName() {
        return sourceUnitName;
    }

    public void setSourceUnitName(String sourceUnitName) {
        this.sourceUnitName = sourceUnitName;
    }

    public String getIdentificationId() {
        return identificationId;
    }

    public void setIdentificationId(String identificationId) {
        this.identificationId = identificationId;
    }
    public Date getIdentificationDate() {
        return identificationDate;
    }

    public void setIdentificationDate(Date identificationDate) {
        this.identificationDate = identificationDate;
    }
    public String getSourceMaterialName() {
        return sourceMaterialName;
    }

    public void setSourceMaterialName(String sourceMaterialName) {
        this.sourceMaterialName = sourceMaterialName;
    }
    public String getSourceMaterialSpec() {
        return sourceMaterialSpec;
    }

    public void setSourceMaterialSpec(String sourceMaterialSpec) {
        this.sourceMaterialSpec = sourceMaterialSpec;
    }
    public Long getConjectureCategoryId() {
        return conjectureCategoryId;
    }

    public void setConjectureCategoryId(Long conjectureCategoryId) {
        this.conjectureCategoryId = conjectureCategoryId;
    }
    public String getConjectureCategoryName() {
        return conjectureCategoryName;
    }

    public void setConjectureCategoryName(String conjectureCategoryName) {
        this.conjectureCategoryName = conjectureCategoryName;
    }
    public Long getConjectureMaterialId() {
        return conjectureMaterialId;
    }

    public void setConjectureMaterialId(Long conjectureMaterialId) {
        this.conjectureMaterialId = conjectureMaterialId;
    }
    public String getConjectureMaterialName() {
        return conjectureMaterialName;
    }

    public void setConjectureMaterialName(String conjectureMaterialName) {
        this.conjectureMaterialName = conjectureMaterialName;
    }
    public String getConjectureMaterialSpecs() {
        return conjectureMaterialSpecs;
    }

    public void setConjectureMaterialSpecs(String conjectureMaterialSpecs) {
        this.conjectureMaterialSpecs = conjectureMaterialSpecs;
    }
    public String getConjectureUnitName() {
        return conjectureUnitName;
    }

    public void setConjectureUnitName(String conjectureUnitName) {
        this.conjectureUnitName = conjectureUnitName;
    }
    public Integer getAdjustFlag() {
        return adjustFlag;
    }

    public void setAdjustFlag(Integer adjustFlag) {
        this.adjustFlag = adjustFlag;
    }
    public Long getActualCategoryId() {
        return actualCategoryId;
    }

    public void setActualCategoryId(Long actualCategoryId) {
        this.actualCategoryId = actualCategoryId;
    }
    public String getActualCategoryName() {
        return actualCategoryName;
    }

    public void setActualCategoryName(String actualCategoryName) {
        this.actualCategoryName = actualCategoryName;
    }
    public Long getActualMaterialId() {
        return actualMaterialId;
    }

    public void setActualMaterialId(Long actualMaterialId) {
        this.actualMaterialId = actualMaterialId;
    }
    public String getActualMaterialName() {
        return actualMaterialName;
    }

    public void setActualMaterialName(String actualMaterialName) {
        this.actualMaterialName = actualMaterialName;
    }
    public String getActualMaterialSpecs() {
        return actualMaterialSpecs;
    }

    public void setActualMaterialSpecs(String actualMaterialSpecs) {
        this.actualMaterialSpecs = actualMaterialSpecs;
    }
    public Long getActualUnitId() {
        return actualUnitId;
    }

    public void setActualUnitId(Long actualUnitId) {
        this.actualUnitId = actualUnitId;
    }
    public String getActualUnitName() {
        return actualUnitName;
    }

    public void setActualUnitName(String actualUnitName) {
        this.actualUnitName = actualUnitName;
    }
    public Long getBillId() {
        return billId;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }
    public String getMateType() {
        return mateType;
    }

    public void setMateType(String mateType) {
        this.mateType = mateType;
    }
    public String getIgnoreFlag() {
        return ignoreFlag;
    }

    public void setIgnoreFlag(String ignoreFlag) {
        this.ignoreFlag = ignoreFlag;
    }
    public String getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(String delFlag) {
        this.delFlag = delFlag;
    }
    public String getLoadState() {
        return loadState;
    }

    public void setLoadState(String loadState) {
        this.loadState = loadState;
    }
}
