package com.ejianc.business.zdsmaterial.erp.api;

import com.ejianc.business.zdsmaterial.erp.hystrix.ZDSSubTypeHystrix;
import com.ejianc.business.zdsmaterial.material.vo.SubTypeVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2024/1/26 13:45
 */
@FeignClient(name = "ejc-zdsmaterial-web", url = "${common.env.feign-client-url}", path = "ejc-zdsmaterial-web", fallback = ZDSSubTypeHystrix.class)
public interface IZDSSubTypeApi {

    @PostMapping(value = "/api/zdsSubType/getAllBySourceIds")
    CommonResponse<List<SubTypeVO>> getAllBySourceIds(@RequestBody List<String> sourceIds);

    @GetMapping(value = "/api/zdsSubType/getOneById")
    CommonResponse<SubTypeVO> getOneById(@RequestParam Long id);

    @PostMapping(value = "/api/zdsSubType/getAllByIds")
    CommonResponse<List<SubTypeVO>> getAllByIds(@RequestParam List<Long> ids);

    @PostMapping(value = "/api/zdsSubType/getSubTypeList")
    CommonResponse<List<SubTypeVO>> getSubTypeList();

}
