package com.ejianc.business.zdsmaterial.erp.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2023/12/5 18:03
 */
public enum OrderDeliveryStatusEnums {

    待发货("待发货", 0),
    部分发货("部分发货", 1),
    全部发货("全部发货", 2);

    private String name;
    private Integer code;

    private static Map<Integer,String> codeNameMap = new HashMap<>();

    OrderDeliveryStatusEnums(String name, Integer code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    static {
        Arrays.stream(values()).forEach(v -> {
            codeNameMap.put(v.getCode(), v.getName());
        });
    }

    public String getNameByCode(Integer code) {
        return codeNameMap.get(code);
    }
}
