package com.ejianc.business.zdsmaterial.cloudstore.constants;

import java.util.HashMap;
import java.util.Map;

/**
 * 订单业务状态
 *
 * @author CJ
 * @Description:
 * @date 2023/12/27 10:53
 */
public enum AllotOrderBusinessStatusEnums {

    调出方待确认("调出方待确认", 1),
    调入方洽商待确认("调入方洽商待确认", 2),
    调入方洽商已确认("调入方洽商已确认", 3),
    调出方审批中("调出方审批中", 4),
    调入方待收货("调入方待收货", 5),
    交易完成("交易完成", 6),
    调出方取消("调出方取消", 7),
    调入方取消("调入方取消", 8);

    private String name;
    private Integer code;

    private static Map<Integer, AllotOrderBusinessStatusEnums> enumsMap = new HashMap<>();

    AllotOrderBusinessStatusEnums(String name, Integer code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    static {
        for(AllotOrderBusinessStatusEnums e : values()) {
            enumsMap.put(e.getCode(), e);
        }
    }

    public static String getNameByCode(Integer code) {
        return enumsMap.get(code).getName();
    }

    public static AllotOrderBusinessStatusEnums getByCode(Integer code) {
        return enumsMap.get(code);
    }
}
