package com.ejianc.business.zdsmaterial.erp.vo;

import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 订单明细
 * 
 * @author generator
 * 
 */
public class OrderDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long orderId; // 订单Id
    private String sourceOrderId; // ERP订单Id
    private String sourceOrderDetailId; // ERP订单子表Id
    private Long contractDetailId; // 对应合同子表主键，只有总价合同有值
    private Long materialId; // 物资id
    private String materialName; // 物资名称
    private String materialCode; // 物资编码
    private String materialTypeName; // 物资分类名称
    private Long materialTypeId; // 物资分类id
    private String materialSerialNo; // 物资流水号
    private String sourceContractId; // ERP合同id
    private String sourceContractDetailId; // ERP合同明细id, 仅合同为总价合同是有值
    private BigDecimal contractNum; // 合同量，注：总价合同量等于该值，单价合同时为空
    private BigDecimal detailNum; // 采购量
    private BigDecimal detailTaxPrice; // 采购单价(含税)
    private BigDecimal detailPrice; // 采购单价
    private BigDecimal detailTaxRate; // 税率
    private BigDecimal detailTaxMny; // 采购金额(含税)
    private BigDecimal detailMny; // 采购金额
    private BigDecimal detailTax; // 税额
    private String detailUnitName; // 计量单位
    private Long detailUnitId; // 计量单位id
    private BigDecimal deliveredNum; // 已发货量
    private BigDecimal acceptedNum; //已验收量
    private BigDecimal handAcceptNum; // 自制验收量
    private String propertyValue; // 属性
    private String memo; // 备注
    private String productCode; //产品代码

    private Long brandId; //品牌主键
    private String brandName; // 品牌名称
    private String materialTypeCode; // 物资分类编码
    private String brandSid; //品牌ERP主键
    private String sourceId; //来源业务Id

    public String getBrandSid() {
        return brandSid;
    }

    public void setBrandSid(String brandSid) {
        this.brandSid = brandSid;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }
    private BigDecimal detailTotalAccepedNum; //累计验收量 = 自制+发货单验收

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
    @ReferSerialTransfer(referCode="ref-zdsBrand")
    public Long getBrandId() {
        return brandId;
    }
    @ReferDeserialTransfer
    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public BigDecimal getAcceptedNum() {
        return acceptedNum;
    }

    public void setAcceptedNum(BigDecimal acceptedNum) {
        this.acceptedNum = acceptedNum;
    }

    public BigDecimal getDetailTotalAccepedNum() {
        return ComputeUtil.safeAdd(this.handAcceptNum, this.acceptedNum);
    }

    public void setDetailTotalAccepedNum(BigDecimal detailTotalAccepedNum) {
        this.detailTotalAccepedNum = detailTotalAccepedNum;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    public String getSourceOrderId() {
        return sourceOrderId;
    }

    public void setSourceOrderId(String sourceOrderId) {
        this.sourceOrderId = sourceOrderId;
    }
    public String getSourceOrderDetailId() {
        return sourceOrderDetailId;
    }

    public void setSourceOrderDetailId(String sourceOrderDetailId) {
        this.sourceOrderDetailId = sourceOrderDetailId;
    }
    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialSerialNo() {
        return materialSerialNo;
    }

    public void setMaterialSerialNo(String materialSerialNo) {
        this.materialSerialNo = materialSerialNo;
    }
    public String getSourceContractId() {
        return sourceContractId;
    }

    public void setSourceContractId(String sourceContractId) {
        this.sourceContractId = sourceContractId;
    }
    public String getSourceContractDetailId() {
        return sourceContractDetailId;
    }

    public void setSourceContractDetailId(String sourceContractDetailId) {
        this.sourceContractDetailId = sourceContractDetailId;
    }
    public BigDecimal getContractNum() {
        return contractNum;
    }

    public void setContractNum(BigDecimal contractNum) {
        this.contractNum = contractNum;
    }
    public BigDecimal getDetailNum() {
        return detailNum;
    }

    public void setDetailNum(BigDecimal detailNum) {
        this.detailNum = detailNum;
    }
    public BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    public void setDetailTaxPrice(BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }
    public BigDecimal getDetailPrice() {
        return detailPrice;
    }

    public void setDetailPrice(BigDecimal detailPrice) {
        this.detailPrice = detailPrice;
    }
    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }
    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }
    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }
    public String getDetailUnitName() {
        return detailUnitName;
    }

    public void setDetailUnitName(String detailUnitName) {
        this.detailUnitName = detailUnitName;
    }
    public Long getDetailUnitId() {
        return detailUnitId;
    }

    public void setDetailUnitId(Long detailUnitId) {
        this.detailUnitId = detailUnitId;
    }
    public BigDecimal getDeliveredNum() {
        return deliveredNum;
    }

    public void setDeliveredNum(BigDecimal deliveredNum) {
        this.deliveredNum = deliveredNum;
    }
    public BigDecimal getHandAcceptNum() {
        return handAcceptNum;
    }

    public void setHandAcceptNum(BigDecimal handAcceptNum) {
        this.handAcceptNum = handAcceptNum;
    }
    public String getPropertyValue() {
        return propertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
