package com.ejianc.business.zdsmaterial.cloudstore.shelf.api;

import com.ejianc.business.zdsmaterial.cloudstore.shelf.hystrix.ZdsGoodsHystrix;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.vo.GoodsVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author yqls
 * @version 1.0
 * @description: 闲置物资上架api
 * @date 2024/01/04
 */
@FeignClient(name = "ejc-zdsmaterial-web", url = "${common.env.feign-client-url}", path = "ejc-zdsmaterial-web", fallback = ZdsGoodsHystrix.class)
public interface IZdsGoodsApi {

    /**
     * 根据组织主键，查询本下云仓，汇总剩余上架金额
     * @Author yqls
     * @param storeIds
     * @return
     */
    @PostMapping(value = "/api/goods/querySurplusShelfMny")
    CommonResponse<List<GoodsVO>> querySurplusShelfMny(@RequestBody List<Long> storeIds);

}
