package com.ejianc.business.zdsmaterial.cloudstore.shelf.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 物资集市
 * 
 * @author generator
 * 
 */
public class GoodsVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long sourceId; // 来源主键
    private Integer billState; // 单据状态（审批必须字段）
    private Long projectId; // 项目主键
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 组织主键
    private String orgCode; // 所属单位编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 上级组织id
    private String parentOrgCode; // 上级组织编码
    private String parentOrgName; // 上级组织name
    private String address; // 地址
    private Long sellUserId; // 联系人
    private String sellerUserCode; // 联系人编码
    private String sellUserName; // 联系人名称
    private String sellUserPhone; // 联系人电话
    private Integer status; // 资产状态0-待上架，1-已上架，2-已下架
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date shelfTime; // 上架时间
    private Long lowerId; // 下架人主键
    private String lowerCode; // 下架人编码
    private String lowerName; // 下架人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date lowerTime; // 下架时间
    private Integer lowerType; // 下架类型0-手动下架，1-售罄下架，2-到期下架
    private Long materialTypeId; // 物料分类id
    private String materialTypeCode; // 物资分类编码
    private String materialTypeName; // 物料分类名称
    private Long materialId; // 物料主键
    private String materialCode; // 物料编码
    private String materialName; // 物料名称
    private String propertyValue; // 属性值
    private Long unitId; // 单位id
    private String unitName; // 单位名称
    private String productCode; // 产品代码
    private Long brandId; // 品牌主键
    private String brandName; // 品牌名称
    private BigDecimal num; // 上架数量
    private BigDecimal taxRate; // 税率
    private BigDecimal mny; // 上架金额
    private BigDecimal taxMny; // 上架含税
    private BigDecimal price; // 上架单价
    private BigDecimal taxPrice; // 上架单价(含税)
    private String memo; // 备注
    private BigDecimal originalPrice; // 原值单价
    private BigDecimal originalTaxPrice; // 原值单价(含税)
    private BigDecimal originalMny; // 原值金额
    private BigDecimal originalTaxMny; // 原值金额含税
    private Long storeId; // 出库仓库id
    private String storeName; // 出库仓库名称
    private Integer attrFlag; // 仓库属性 1-主材；3-甲供材；2-临建；4-大区
    private BigDecimal allotedNum; // 已调拨数量
    private BigDecimal allotNum; // 调拨中数量
    private BigDecimal surplusNum; // 剩余可调拨数量
    private Long corpId; // 分子公司
    private String corpCode; // 分子公司编码
    private String corpName; // 分子公司名称
    private Integer storeType; // 仓库类型 1-项目；2-大区
    private BigDecimal allotPrice; // 调拨单价
    private BigDecimal allotTaxPrice; // 调拨单价(含税)
    private BigDecimal allotMny; // 调拨金额
    private BigDecimal allotTaxMny; // 调拨金额含税
    private Long cloudStoreId; // 云仓id
    private String cloudStoreName; // 云仓名称
    private BigDecimal lowerNum; // 下架数量

    private String attrFlagName; // 仓库属性名称
    

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getSellUserId() {
        return sellUserId;
    }

    @ReferDeserialTransfer
    public void setSellUserId(Long sellUserId) {
        this.sellUserId = sellUserId;
    }

    public String getSellerUserCode() {
        return sellerUserCode;
    }

    public void setSellerUserCode(String sellerUserCode) {
        this.sellerUserCode = sellerUserCode;
    }
    public String getSellUserName() {
        return sellUserName;
    }

    public void setSellUserName(String sellUserName) {
        this.sellUserName = sellUserName;
    }
    public String getSellUserPhone() {
        return sellUserPhone;
    }

    public void setSellUserPhone(String sellUserPhone) {
        this.sellUserPhone = sellUserPhone;
    }
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
    public Date getShelfTime() {
        return shelfTime;
    }

    public void setShelfTime(Date shelfTime) {
        this.shelfTime = shelfTime;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getLowerId() {
        return lowerId;
    }

    @ReferDeserialTransfer
    public void setLowerId(Long lowerId) {
        this.lowerId = lowerId;
    }

    public String getLowerCode() {
        return lowerCode;
    }

    public void setLowerCode(String lowerCode) {
        this.lowerCode = lowerCode;
    }
    public String getLowerName() {
        return lowerName;
    }

    public void setLowerName(String lowerName) {
        this.lowerName = lowerName;
    }
    public Date getLowerTime() {
        return lowerTime;
    }

    public void setLowerTime(Date lowerTime) {
        this.lowerTime = lowerTime;
    }
    public Integer getLowerType() {
        return lowerType;
    }

    public void setLowerType(Integer lowerType) {
        this.lowerType = lowerType;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getPropertyValue() {
        return propertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }
    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }
    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getOriginalPrice() {
        return originalPrice;
    }

    public void setOriginalPrice(BigDecimal originalPrice) {
        this.originalPrice = originalPrice;
    }
    public BigDecimal getOriginalTaxPrice() {
        return originalTaxPrice;
    }

    public void setOriginalTaxPrice(BigDecimal originalTaxPrice) {
        this.originalTaxPrice = originalTaxPrice;
    }
    public BigDecimal getOriginalMny() {
        return originalMny;
    }

    public void setOriginalMny(BigDecimal originalMny) {
        this.originalMny = originalMny;
    }
    public BigDecimal getOriginalTaxMny() {
        return originalTaxMny;
    }

    public void setOriginalTaxMny(BigDecimal originalTaxMny) {
        this.originalTaxMny = originalTaxMny;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Integer getAttrFlag() {
        return attrFlag;
    }

    public void setAttrFlag(Integer attrFlag) {
        this.attrFlag = attrFlag;
    }
    public BigDecimal getAllotedNum() {
        return allotedNum;
    }

    public void setAllotedNum(BigDecimal allotedNum) {
        this.allotedNum = allotedNum;
    }
    public BigDecimal getAllotNum() {
        return allotNum;
    }

    public void setAllotNum(BigDecimal allotNum) {
        this.allotNum = allotNum;
    }
    public BigDecimal getSurplusNum() {
        return surplusNum;
    }

    public void setSurplusNum(BigDecimal surplusNum) {
        this.surplusNum = surplusNum;
    }
    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }
    public String getCorpCode() {
        return corpCode;
    }

    public void setCorpCode(String corpCode) {
        this.corpCode = corpCode;
    }
    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }
    public Integer getStoreType() {
        return storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }
    public BigDecimal getAllotPrice() {
        return allotPrice;
    }

    public void setAllotPrice(BigDecimal allotPrice) {
        this.allotPrice = allotPrice;
    }
    public BigDecimal getAllotTaxPrice() {
        return allotTaxPrice;
    }

    public void setAllotTaxPrice(BigDecimal allotTaxPrice) {
        this.allotTaxPrice = allotTaxPrice;
    }
    public BigDecimal getAllotMny() {
        return allotMny;
    }

    public void setAllotMny(BigDecimal allotMny) {
        this.allotMny = allotMny;
    }
    public BigDecimal getAllotTaxMny() {
        return allotTaxMny;
    }

    public void setAllotTaxMny(BigDecimal allotTaxMny) {
        this.allotTaxMny = allotTaxMny;
    }
    public Long getCloudStoreId() {
        return cloudStoreId;
    }

    public void setCloudStoreId(Long cloudStoreId) {
        this.cloudStoreId = cloudStoreId;
    }
    public String getCloudStoreName() {
        return cloudStoreName;
    }

    public void setCloudStoreName(String cloudStoreName) {
        this.cloudStoreName = cloudStoreName;
    }
    public BigDecimal getLowerNum() {
        return lowerNum;
    }

    public void setLowerNum(BigDecimal lowerNum) {
        this.lowerNum = lowerNum;
    }
    public String getAttrFlagName() {
        return attrFlagName;
    }

    public void setAttrFlagName(String attrFlagName) {
        this.attrFlagName = attrFlagName;
    }
}
