package com.ejianc.business.zdsmaterial.plan.conjecture.api;

import com.ejianc.business.zdsmaterial.plan.conjecture.hystrix.ZDSMaterialConjectureHystrix;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureApiVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @description: IZDSMaterialConjectureApi
 * @author songlx
 * @date 2025/7/8
 * @version 1.0
 */
@FeignClient(name = "ejc-zdsmaterial-web", url = "${common.env.feign-client-url}", path = "ejc-zdsmaterial-web", fallback = ZDSMaterialConjectureHystrix.class)
public interface IZDSMaterialConjectureApi {

    @PostMapping(value = "/api/materialConjectureApi/materialConjecture")
    CommonResponse<List<MaterialConjectureVO>> materialConjecture(@RequestBody List<MaterialConjectureVO> list);

    @GetMapping(value = "/api/materialConjectureApi/getConjectureProgress")
    CommonResponse<MaterialConjectureApiVO> getConjectureProgress(@RequestParam String identificationId);

}
