/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class CommonUtils {
    public static final String defaultErrMsg = "\u63a8\u9001\u6570\u636e\u5931\u8d25\uff01";
    private static final String noPower = "\u65e0\u6743\u9650\u8bbf\u95ee\u8be5\u670d\u52a1\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\uff01";

    private CommonUtils() {
    }

    public static <T> boolean checkCommonResponse(CommonResponse<T> commonResponse) {
        return CommonUtils.checkCommonResponse(commonResponse, true, null, null);
    }

    public static <T> boolean checkCommonResponse(CommonResponse<T> commonResponse, Logger logger) {
        return CommonUtils.checkCommonResponse(commonResponse, true, null, logger);
    }

    public static <T> boolean checkCommonResponse(CommonResponse<T> commonResponse, boolean isThrow, String errMsg, Logger logger) {
        if (!commonResponse.isSuccess()) {
            if (logger != null) {
                logger.info("\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff0c\u8c03\u7528\u7ed3\u679c\uff1a{}\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.isSuccess(), (Object)commonResponse.getMsg());
            }
            if (isThrow) {
                throw new BusinessException(StringUtils.isNotEmpty((CharSequence)errMsg) ? errMsg : commonResponse.getMsg());
            }
            return false;
        }
        try {
            String dataString;
            Object data = commonResponse.getData();
            if (data instanceof String) {
                dataString = String.valueOf(data);
                if (noPower.equals(dataString)) {
                    throw new BusinessException(dataString);
                }
            } else {
                dataString = JSONObject.toJSONString((Object)data);
            }
            JSONObject jsonObject = JSONObject.parseObject((String)dataString);
            if (StringUtils.isNotEmpty((CharSequence)dataString) && jsonObject.containsKey((Object)"code")) {
                CommonResponse check = (CommonResponse)JSONObject.toJavaObject((JSON)jsonObject, CommonResponse.class);
                if (isThrow && !check.isSuccess()) {
                    if (logger != null) {
                        logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)check.getMsg());
                    }
                    throw new BusinessException(StringUtils.isNotEmpty((CharSequence)errMsg) ? errMsg : check.getMsg());
                }
                return check.isSuccess();
            }
            throw new BusinessException(defaultErrMsg);
        }
        catch (BusinessException be) {
            if (logger != null) {
                logger.error(be.getErrorMsg());
            }
            throw be;
        }
        catch (Exception e) {
            if (logger != null) {
                logger.error("\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\uff01\u8fd4\u56de\u7ed3\u679c\u4e0d\u662fjson\u6216CommonResponse");
            }
            if (isThrow) {
                throw new BusinessException(defaultErrMsg);
            }
            return true;
        }
    }

    public static BigDecimal setBigDecimalDefaultValue(BigDecimal v) {
        if (v == null) {
            return BigDecimal.ZERO;
        }
        return v;
    }
}

