/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.zdsstore.bean.PickReturnDetailEntity;
import com.ejianc.business.zdsstore.bean.PickReturnEntity;
import com.ejianc.business.zdsstore.consts.StoreAttrEnum;
import com.ejianc.business.zdsstore.mapper.PickReturnMapper;
import com.ejianc.business.zdsstore.service.IPickReturnService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.utils.CommonUtils;
import com.ejianc.business.zdsstore.vo.PickReturnDetailVO;
import com.ejianc.business.zdsstore.vo.PickReturnVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pickReturnService")
public class PickReturnServiceImpl
extends BaseServiceImpl<PickReturnMapper, PickReturnEntity>
implements IPickReturnService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PickReturnMapper pickReturnMapper;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "STORE_PICK_RETURN_CODE";
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPickReturnService service;

    @Override
    public PickReturnVO queryByContractId(Long contractId) {
        PickReturnVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractId);
        query.eq((Object)"bill_state", (Object)BillStateEnum.UNCOMMITED_STATE);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        PickReturnEntity entity = (PickReturnEntity)((Object)this.pickReturnMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (PickReturnVO)BeanMapper.map((Object)((Object)entity), PickReturnVO.class);
        }
        return resp;
    }

    @Override
    public void removeByPickReturnIds(List<Long> ids) {
        this.removeByIds(ids, true);
    }

    @Override
    public CommonResponse<PickReturnVO> pushCost(PickReturnVO pickReturnVO) {
        PickReturnEntity pickReturnEntity = (PickReturnEntity)((Object)((PickReturnMapper)this.baseMapper).selectById(pickReturnVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)pickReturnVO.getPickReturnDetailList())) {
            List pickReturnDetailEntities = BeanMapper.mapList((Iterable)pickReturnVO.getPickReturnDetailList(), PickReturnDetailEntity.class);
            pickReturnEntity.setPickReturnDetailList(pickReturnDetailEntities);
        }
        super.saveOrUpdate((Object)pickReturnEntity, false);
        this.costPush(pickReturnEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)pickReturnEntity), PickReturnVO.class));
    }

    @Override
    public void costPush(PickReturnEntity pickReturnEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<PickReturnDetailEntity> pickReturnDetailList = pickReturnEntity.getPickReturnDetailList();
        String newRelationFlag = "1";
        if (CollectionUtils.isNotEmpty(pickReturnDetailList)) {
            for (PickReturnDetailEntity entity : pickReturnDetailList) {
                if (null != entity.getSubjectId() && null != entity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(pickReturnDetailList)) {
            newRelationFlag = "0";
        }
        this.saveCost(pickReturnEntity, 1);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{pickReturnEntity.getId()});
        updateWrapper.set(PickReturnEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public PickReturnVO saveOrUpdate(PickReturnVO saveOrUpdateVO) {
        PickReturnVO voByContract;
        PickReturnEntity entity = (PickReturnEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PickReturnEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.setProportionFlag("0");
                entity.setRelationFlag("0");
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (!(null == (voByContract = this.service.queryByContractId(saveOrUpdateVO.getContractId())) || null != saveOrUpdateVO.getId() && voByContract.getId().equals(saveOrUpdateVO.getId()))) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u5408\u540c\u4e0b\u5b58\u5728\u672a\u751f\u6548\u5355\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        PickReturnVO vo = (PickReturnVO)BeanMapper.map((Object)((Object)entity), PickReturnVO.class);
        this.saveCost(entity, 0);
        return vo;
    }

    @Override
    public ParamsCheckVO checkParams(PickReturnVO pickReturnVO) {
        CommonResponse costResponse;
        ParamsCheckVO costRes;
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        CostCtrlVO costCtrlVO = this.sjCost(pickReturnVO);
        if (null != costCtrlVO && null != (costRes = (ParamsCheckVO)(costResponse = this.executionApi.ctrlCost(costCtrlVO)).getData())) {
            paramsCheckVOS.add(costRes);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    public CostCtrlVO sjCost(PickReturnVO vo) {
        List pickReturnDetailList = vo.getPickReturnDetailList();
        if (CollectionUtils.isNotEmpty((Collection)pickReturnDetailList)) {
            HashMap<Long, CostCtrlDetailVO> map = new HashMap<Long, CostCtrlDetailVO>();
            for (PickReturnDetailVO pickReturnDetailVO : pickReturnDetailList) {
                CostCtrlDetailVO costCtrlDetailVO;
                if (null == pickReturnDetailVO.getSubjectId() || "del".equals(pickReturnDetailVO.getRowState())) continue;
                BigDecimal detailMny = CommonUtils.setBigDecimalDefaultValue(pickReturnDetailVO.getMny());
                BigDecimal detailTaxMny = CommonUtils.setBigDecimalDefaultValue(pickReturnDetailVO.getTaxMny());
                if (map.containsKey(pickReturnDetailVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(pickReturnDetailVO.getSubjectId());
                    BigDecimal mny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getMny());
                    BigDecimal taxMny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getTaxMny());
                    costCtrlDetailVO.setMny(mny.add(detailMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(detailTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(pickReturnDetailVO.getSubjectId());
                costCtrlDetailVO.setMny(detailMny);
                costCtrlDetailVO.setTaxMny(detailTaxMny);
                map.put(pickReturnDetailVO.getSubjectId(), costCtrlDetailVO);
            }
            if (null != map && !map.isEmpty()) {
                CostCtrlVO ctrlVO = new CostCtrlVO();
                if (null != vo.getId()) {
                    ctrlVO.setSourceId(vo.getId());
                }
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList(map.values()));
                return ctrlVO;
            }
            return null;
        }
        return null;
    }

    private void saveCost(PickReturnEntity pickReturnEntity, Integer effectiveStatus) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<PickReturnDetailEntity> pickReturnDetailList = pickReturnEntity.getPickReturnDetailList();
        if (CollectionUtils.isNotEmpty(pickReturnDetailList)) {
            List materialIds = pickReturnDetailList.stream().map(PickReturnDetailEntity::getMaterialId).collect(Collectors.toList());
            CommonResponse listCommonResponse = this.shareMaterialApi.queryMaterialByIds(materialIds);
            List voList = new ArrayList();
            if (listCommonResponse.isSuccess()) {
                voList = (List)listCommonResponse.getData();
            }
            HashMap materialMap = new HashMap();
            voList.forEach(item -> materialMap.put(item.getId(), item.getCode()));
            for (PickReturnDetailEntity entity : pickReturnDetailList) {
                if (!StoreAttrEnum.SELFPURCHASE.getCode().equals(String.valueOf(entity.getAttrFlag()))) continue;
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(entity.getSubjectId());
                costDetailVO.setSubjectCode(entity.getSubjectCode());
                costDetailVO.setSubjectName(entity.getSubjectName());
                costDetailVO.setWbsId(entity.getWbsId());
                costDetailVO.setWbsCode(entity.getWbsCode());
                costDetailVO.setWbsName(entity.getWbsName());
                costDetailVO.setSourceId(entity.getInstoreId());
                costDetailVO.setSourceDetailId(entity.getId());
                costDetailVO.setHappenTaxMny(ComputeUtil.convertToMinusNumber((BigDecimal)entity.getTaxMny()));
                costDetailVO.setHappenMny(ComputeUtil.convertToMinusNumber((BigDecimal)entity.getMny()));
                costDetailVO.setNum(ComputeUtil.convertToMinusNumber((BigDecimal)entity.getReturnNum()));
                costDetailVO.setHappenDate(pickReturnEntity.getInstoreDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("STORE_PICKRETURN");
                costDetailVO.setSourceTabType("STORE_PICKRETURN_SUB");
                costDetailVO.setProjectId(pickReturnEntity.getProjectId());
                costDetailVO.setSourceBillCode(pickReturnEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u6750\u6599\u9000\u5e93.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-zdsstore-frontend/#/pickReturn/card?id=" + pickReturnEntity.getId());
                costDetailVO.setMaterialId(entity.getMaterialId());
                costDetailVO.setMaterialName(entity.getMaterialName());
                costDetailVO.setMaterialTypeId(entity.getMaterialCategoryId());
                costDetailVO.setMaterialTypeName(entity.getMaterialCategoryName());
                costDetailVO.setMaterialCode((String)materialMap.get(entity.getMaterialId()));
                costDetailVO.setUnitId(entity.getMaterialUnitId());
                costDetailVO.setUnit(entity.getMaterialUnitName());
                costDetailVO.setSpec(entity.getMaterialSpec());
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
}

