/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.handler;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsstore.bean.FlowEntity;
import com.ejianc.business.zdsstore.bean.InOutEntity;
import com.ejianc.business.zdsstore.bean.SurplusEntity;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.service.IFlowService;
import com.ejianc.business.zdsstore.service.IInOutService;
import com.ejianc.business.zdsstore.service.IStoreService;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.service.handler.IStoreManageHandler;
import com.ejianc.business.zdsstore.util.StoreLockUtil;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdsstore.vo.SurplusUpdateVO;
import com.ejianc.business.zdsstore.vo.UseCalculateVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TurnOutStoreHandler
implements IStoreManageHandler {
    @Autowired
    IFlowService flowService;
    @Autowired
    IInOutService inOutService;
    @Autowired
    ISurplusService surplusService;
    @Autowired
    IStoreService storeService;

    @Override
    public CommonResponse<StoreManageVO> handle(StoreManageVO storeManageVO) {
        CommonResponse<SurplusUpdateVO> res;
        Long sourceId = storeManageVO.getSourceId();
        Long storeId = storeManageVO.getStoreId();
        Boolean lock = StoreLockUtil.getLock((Long)storeId);
        Boolean outEffectiveON = storeManageVO.getOutEffectiveON();
        ArrayList inFlowEntityList = new ArrayList();
        if (outEffectiveON.booleanValue()) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"out_bill_id", (Object)sourceId);
            queryWrapper.eq((Object)"effective_state", (Object)StoreCommonConsts.NO);
            List inOutEntityList = this.inOutService.list((Wrapper)queryWrapper);
            List inFlowList = inOutEntityList.stream().map(InOutEntity::getInFlowId).collect(Collectors.toList());
            List materialIds = inOutEntityList.stream().map(InOutEntity::getMaterialId).collect(Collectors.toList());
            List flowEntities = (List)this.flowService.listByIds(inFlowList);
            Map<Long, List<FlowEntity>> inFlowMap = flowEntities.stream().collect(Collectors.groupingBy(BaseEntity::getId));
            HashMap surplusUpdateMap = new HashMap();
            QueryWrapper surplusEntityQueryWrapper = new QueryWrapper();
            surplusEntityQueryWrapper.eq((Object)"store_id", (Object)storeId);
            surplusEntityQueryWrapper.in((Object)"material_id", materialIds);
            List surplusEntities = this.surplusService.list((Wrapper)surplusEntityQueryWrapper);
            surplusEntities.forEach(t -> surplusUpdateMap.put(t.getMaterialId(), t));
            ArrayList updateSurplusList = new ArrayList();
            inOutEntityList.forEach(t -> {
                BigDecimal effectOutNum = t.getOutLockNum();
                BigDecimal outNetMny = t.getOutNetMny();
                BigDecimal outNetTaxMny = t.getOutNetTaxMny();
                t.setEffectiveDate(new Date());
                t.setEffectiveState(StoreCommonConsts.YES);
                t.setOutNum(effectOutNum);
                t.setOutLockNum(BigDecimal.ZERO);
                t.setOutUseFlag(StoreCommonConsts.UseOutFlag.USE_FINISH);
                SurplusEntity surplusVO = (SurplusEntity)((Object)((Object)surplusUpdateMap.get(t.getMaterialId())));
                BigDecimal outLockNum = ComputeUtil.safeSub((BigDecimal)surplusVO.getOutLockNum(), (BigDecimal)effectOutNum);
                surplusVO.setOutLockNum(outLockNum);
                BigDecimal outLockMny = ComputeUtil.safeSub((BigDecimal)surplusVO.getOutLockMny(), (BigDecimal)outNetMny);
                surplusVO.setOutLockMny(outLockMny);
                BigDecimal outLockTaxMny = ComputeUtil.safeSub((BigDecimal)surplusVO.getOutLockTaxMny(), (BigDecimal)outNetTaxMny);
                surplusVO.setOutLockMny(outLockTaxMny);
                updateSurplusList.add(surplusVO);
                List flowVOS = (List)inFlowMap.get(t.getInFlowId());
                FlowEntity flowEntity = (FlowEntity)((Object)((Object)flowVOS.get(0)));
                BigDecimal _outLockNum = ComputeUtil.safeSub((BigDecimal)flowEntity.getOutLockNum(), (BigDecimal)effectOutNum);
                flowEntity.setOutLockNum(_outLockNum);
                BigDecimal _outNum = ComputeUtil.safeAdd((BigDecimal)flowEntity.getOutNum(), (BigDecimal)effectOutNum);
                flowEntity.setOutNum(_outNum);
                BigDecimal sumOutNetMny = ComputeUtil.safeAdd((BigDecimal)flowEntity.getOutNetMny(), (BigDecimal)outNetMny);
                flowEntity.setOutNetMny(sumOutNetMny);
                BigDecimal sumOutNetTaxMny = ComputeUtil.safeAdd((BigDecimal)flowEntity.getOutNetTaxMny(), (BigDecimal)outNetTaxMny);
                flowEntity.setOutNetTaxMny(sumOutNetTaxMny);
                inFlowEntityList.add(flowEntity);
            });
            QueryWrapper outFlowQueryWrapper = new QueryWrapper();
            outFlowQueryWrapper.eq((Object)"source_id", (Object)sourceId);
            List outFlowList = this.flowService.list((Wrapper)outFlowQueryWrapper);
            outFlowList.forEach(t -> {
                t.setEffectiveDate(new Date());
                t.setEffectiveState(StoreCommonConsts.YES);
                inFlowEntityList.add(t);
            });
            this.flowService.saveOrUpdateBatch(inFlowEntityList);
            this.inOutService.saveOrUpdateBatch(inOutEntityList);
            this.surplusService.saveOrUpdateBatch(updateSurplusList);
            return CommonResponse.success((Object)storeManageVO);
        }
        List flowVOList = storeManageVO.getFlowVOList();
        try {
            res = this.surplusService.validateStoreSurplusByOutLock(storeManageVO);
            if (res.isSuccess()) {
                List updateSurplusVOList;
                List updateInOutVOList;
                UseCalculateVO useCalculateVO = this.surplusService.useTurnCalculate(storeManageVO);
                if (useCalculateVO == null) {
                    CommonResponse materialIds = CommonResponse.success((String)"\u6750\u6599\u51fa\u5e93\u660e\u7ec6\u6570\u91cf\u6ca1\u6709\u53d8\u5316,\u4ed3\u5e93\u65e0\u9700\u5904\u7406!");
                    return materialIds;
                }
                List updateFlowVOList = useCalculateVO.getUpdateFlowVOList();
                QueryWrapper outFlowWrapper = new QueryWrapper();
                outFlowWrapper.eq((Object)"source_id", (Object)sourceId);
                List outstoreList = this.flowService.list((Wrapper)outFlowWrapper);
                if (CollectionUtils.isNotEmpty((Collection)outstoreList)) {
                    Map<Long, List<FlowEntity>> outstoreMap = outstoreList.stream().collect(Collectors.groupingBy(FlowEntity::getSourceDetailId));
                    flowVOList.forEach(t -> {
                        Long sourceDetailId = t.getSourceDetailId();
                        List flowEntityList = (List)outstoreMap.get(sourceDetailId);
                        if (CollectionUtils.isNotEmpty((Collection)flowEntityList)) {
                            FlowEntity flowEntity = (FlowEntity)((Object)((Object)flowEntityList.get(0)));
                            t.setId(flowEntity.getId());
                            t.setVersion(flowEntity.getVersion());
                        }
                    });
                }
                updateFlowVOList.addAll(flowVOList);
                if (CollectionUtils.isNotEmpty((Collection)updateFlowVOList)) {
                    List flowEntities = BeanMapper.mapList((Iterable)updateFlowVOList, FlowEntity.class);
                    ArrayList updateFlowList = new ArrayList();
                    ArrayList delFlowList = new ArrayList();
                    flowEntities.forEach(n -> {
                        if ("del".equals(n.getRowState())) {
                            delFlowList.add(n);
                        } else {
                            updateFlowList.add(n);
                        }
                    });
                    if (CollectionUtils.isNotEmpty(delFlowList)) {
                        this.flowService.removeByIds(delFlowList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
                    }
                    if (CollectionUtils.isNotEmpty(updateFlowList)) {
                        this.flowService.saveOrUpdateBatch(updateFlowList);
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)(updateInOutVOList = useCalculateVO.getUpdateInOutVOList()))) {
                    List inOutEntities = BeanMapper.mapList((Iterable)updateInOutVOList, InOutEntity.class);
                    Map<Integer, List<InOutEntity>> list = inOutEntities.stream().collect(Collectors.groupingBy(BaseEntity::getDr));
                    List<InOutEntity> delList = list.get(1);
                    List<InOutEntity> saveOrUpdList = list.get(0);
                    if (CollectionUtils.isNotEmpty(delList)) {
                        this.inOutService.removeByIds(delList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
                    }
                    if (CollectionUtils.isNotEmpty(saveOrUpdList)) {
                        this.inOutService.saveOrUpdateBatch(saveOrUpdList);
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)(updateSurplusVOList = useCalculateVO.getUpdateSurplusVOList()))) {
                    List surplusEntities = BeanMapper.mapList((Iterable)updateSurplusVOList, SurplusEntity.class);
                    this.surplusService.saveOrUpdateBatch(surplusEntities);
                }
                CommonResponse commonResponse = CommonResponse.success((Object)storeManageVO);
                return commonResponse;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        finally {
            if (lock.booleanValue()) {
                StoreLockUtil.releaseLock((Long)storeId);
            }
        }
        return CommonResponse.error((String)res.getMsg());
    }

    @Override
    public CommonResponse<StoreManageVO> handleRollback(StoreManageVO storeManageVO) {
        Long storeId = storeManageVO.getStoreId();
        Boolean lock = StoreLockUtil.getLock((Long)storeId);
        try {
            List updateSurplusVOList;
            List updateInOutVOList;
            UseCalculateVO useCalculateVO = this.surplusService.turnOutRollBackByInOut(storeManageVO, storeManageVO.getOutEffectiveON());
            List updateFlowVOList = useCalculateVO.getUpdateFlowVOList();
            if (CollectionUtils.isNotEmpty((Collection)updateFlowVOList)) {
                List flowEntities = BeanMapper.mapList((Iterable)updateFlowVOList, FlowEntity.class);
                this.flowService.saveOrUpdateBatch(flowEntities);
                List sourceIdsForRollBack = storeManageVO.getSourceIdsForRollBack();
                QueryWrapper outFlowQueryWrapper = new QueryWrapper();
                outFlowQueryWrapper.in((Object)"source_id", (Collection)sourceIdsForRollBack);
                List outFlowList = this.flowService.list((Wrapper)outFlowQueryWrapper);
                if (storeManageVO.getOutEffectiveON().booleanValue()) {
                    outFlowList.forEach(t -> {
                        t.setEffectiveDate(new Date());
                        t.setEffectiveState(StoreCommonConsts.NO);
                    });
                    this.flowService.saveOrUpdateBatch(outFlowList);
                } else {
                    List delListIds = outFlowList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                    this.flowService.removeByIds(delListIds);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(updateInOutVOList = useCalculateVO.getUpdateInOutVOList()))) {
                List inOutEntities = BeanMapper.mapList((Iterable)updateInOutVOList, InOutEntity.class);
                if (storeManageVO.getOutEffectiveON().booleanValue()) {
                    inOutEntities.forEach(t -> {
                        t.setEffectiveDate(new Date());
                        t.setEffectiveState(StoreCommonConsts.NO);
                    });
                    this.inOutService.saveOrUpdateBatch(inOutEntities);
                } else {
                    List delListIds = inOutEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
                    this.inOutService.removeByIds(delListIds);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(updateSurplusVOList = useCalculateVO.getUpdateSurplusVOList()))) {
                List surplusEntities = BeanMapper.mapList((Iterable)updateSurplusVOList, SurplusEntity.class);
                this.surplusService.saveOrUpdateBatch(surplusEntities);
            }
            CommonResponse commonResponse = CommonResponse.success((Object)storeManageVO);
            return commonResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        finally {
            if (lock.booleanValue()) {
                StoreLockUtil.releaseLock((Long)storeId);
            }
        }
    }
}

