package com.ejianc.business.zdsstore.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsstore.bean.SurplusEntity;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 仓库库存表
 *
 * @author generator
 */
@Controller
@RequestMapping("surplus")
@Api(value = "仓库库存表", tags = {"仓库库存表"})
public class SurplusController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ISurplusService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IShareMaterialApi shareMaterialApi;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SurplusVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody SurplusVO saveOrUpdateVO) {
        SurplusEntity entity = BeanMapper.map(saveOrUpdateVO, SurplusEntity.class);
        service.saveOrUpdate(entity, false);
        SurplusVO vo = BeanMapper.map(entity, SurplusVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SurplusVO> queryDetail(@RequestParam Long id) {
        SurplusEntity entity = service.selectById(id);
        SurplusVO vo = BeanMapper.map(entity, SurplusVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SurplusVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SurplusVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SurplusVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SurplusVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnitName");
        Map<String, Parameter> params = param.getParams();
        /** 租户隔离 */
        params.put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            params.put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            params.put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        Parameter materialCategoryIdPara = params.get("materialCategoryId");
        if (null != materialCategoryIdPara && materialCategoryIdPara.getValue() != null) {
            Object value = materialCategoryIdPara.getValue();
            Long cateParId = Long.valueOf(value.toString());
            CommonResponse<List<MaterialCategoryVO>> listCommonResponse = shareMaterialApi.queryCategoryListByPid(cateParId);
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty(listCommonResponse.getData())) {
                List<Long> categoryIds = listCommonResponse.getData().stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());
                params.put("materialCategoryId", new Parameter(QueryParam.IN, categoryIds));
            }

        }

        IPage<SurplusEntity> page = service.queryPage(param, false);
        IPage<SurplusVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SurplusVO> surplusVOS = BeanMapper.mapList(page.getRecords(), SurplusVO.class);
        surplusVOS.forEach(t -> {
            t.setSurplusNum(ComputeUtil.safeAdd(t.getSurplusNum(),t.getOutLockNum()));
            t.setSurplusTaxPrice(ComputeUtil.safeDiv(t.getSurplusTaxMny(), t.getSurplusNum()));
            t.setSurplusPrice(ComputeUtil.safeDiv(t.getSurplusMny(), t.getSurplusNum()));
        });
        pageData.setRecords(surplusVOS);

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SurplusEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Surplus-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refSurplusData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SurplusVO>> refSurplusData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                           String condition,
                                                           String searchObject,
                                                           String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnitName");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("storeId")) {
                param.getParams().put("storeId", new Parameter(QueryParam.EQ, _con.get("storeId")));
            }
            if (_con.containsKey("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
        }
        //库存可用数量大于0
        param.getParams().put("surplusNum", new Parameter(QueryParam.GT, BigDecimal.ZERO));
        IPage<SurplusEntity> page = service.queryPage(param, false);
        IPage<SurplusVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SurplusVO> surplusVOS = BeanMapper.mapList(page.getRecords(), SurplusVO.class);
        surplusVOS.forEach(
                t -> {
                    t.setSurplusHasOutLockNum(ComputeUtil.safeAdd(t.getSurplusNum(), t.getOutLockNum()));
                    t.setSurplusMny(ComputeUtil.safeAdd(t.getSurplusMny(), t.getOutLockMny()));
                    t.setSurplusTaxMny(ComputeUtil.safeAdd(t.getSurplusTaxMny(), t.getOutLockTaxMny()));
                }
        );
        pageData.setRecords(surplusVOS);

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
