/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.zdsstore.bean.HandleEntity;
import com.ejianc.business.zdsstore.service.IHandleService;
import com.ejianc.business.zdsstore.vo.HandleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"handle"})
public class HandleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "STORE_HANDLE_CODE";
    @Autowired
    private IHandleService service;
    @Autowired
    private ICostDetailApi costDetailApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<HandleVO> saveOrUpdate(@RequestBody HandleVO saveOrUpdateVO) {
        CommonResponse commonResponse;
        HandleEntity entity = (HandleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, HandleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.setProportionFlag("0");
                entity.setRelationFlag("0");
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (!(commonResponse = this.service.saveCheckHandle(entity)).isSuccess()) {
            return commonResponse;
        }
        this.service.saveCost(entity, 0);
        HandleVO vo = (HandleVO)BeanMapper.map((Object)commonResponse.getData(), HandleVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<HandleVO> pushCost(@RequestBody HandleVO handleVO) {
        return this.service.pushCost(handleVO);
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody HandleVO vo) {
        ParamsCheckVO paramsCheckVO = this.service.checkParams(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<HandleVO> queryDetail(Long id) {
        HandleEntity entity = (HandleEntity)((Object)this.service.selectById(id));
        HandleVO vo = (HandleVO)BeanMapper.map((Object)((Object)entity), HandleVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<HandleVO> vos) {
        Collection list = this.service.listByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        list.forEach(e -> {
            CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(e.getId());
            this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        });
        this.service.myRemoveByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<HandleVO>> queryList(@RequestBody QueryParam param) {
        param.setFuzzyFields(Arrays.asList("billCode", "storeName", "projectName", "materialTypes"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgResp.isSuccess()) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgIdList = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIdList));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List handleVOS = BeanMapper.mapList((Iterable)page.getRecords(), HandleVO.class);
        handleVOS.forEach(item -> item.setHandleTypeName(item.getHandleType() == 1 ? "\u6d88\u8017\u6750" : "\u5468\u8f6c\u6750"));
        pageData.setRecords(handleVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setFuzzyFields(Arrays.asList("billCode", "storeName", "projectName", "materialTypes"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgResp.isSuccess()) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
        }
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List handleVOS = BeanMapper.mapList((Iterable)list, HandleVO.class);
        handleVOS.forEach(item -> {
            item.setHandleTypeName(item.getHandleType() == 1 ? "\u6d88\u8017\u6750" : "\u5468\u8f6c\u6750");
            item.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)item.getBillState()).getDescription());
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", handleVOS);
        ExcelExport.getInstance().export("handleExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/refHandleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<HandleVO>> refHandleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), HandleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

