/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.handler;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsstore.bean.FlowEntity;
import com.ejianc.business.zdsstore.service.IFlowService;
import com.ejianc.business.zdsstore.service.IInOutService;
import com.ejianc.business.zdsstore.service.IStoreService;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.service.handler.IStoreManageHandler;
import com.ejianc.business.zdsstore.util.StoreLockUtil;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdsstore.vo.SurplusUpdateVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BackGoodsHandler
implements IStoreManageHandler {
    @Autowired
    IFlowService flowService;
    @Autowired
    ISurplusService surplusService;
    @Autowired
    IInOutService inOutService;
    @Autowired
    IStoreService storeService;

    @Override
    public CommonResponse<StoreManageVO> handle(StoreManageVO storeManageVO) {
        CommonResponse<SurplusUpdateVO> res;
        storeManageVO = this.storeService.setStoreAttr(storeManageVO);
        Long storeId = storeManageVO.getStoreId();
        List flowVOList = storeManageVO.getFlowVOList();
        flowVOList.forEach(t -> {
            BigDecimal num = ComputeUtil.convertToMinusNumber((BigDecimal)t.getNum());
            t.setNum(num);
            t.setSurplusNum(num);
            BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)t.getNum(), (BigDecimal)t.getPrice());
            t.setMny(mny);
            t.setSurplusMny(mny);
            BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)t.getNum(), (BigDecimal)t.getTaxPrice());
            t.setTaxMny(taxMny);
            t.setSurplusTaxMny(taxMny);
        });
        SurplusUpdateVO surplusUpdateVO = StoreManageUtil.getSurplusUpdateVO((Long)storeId, (List)flowVOList, (boolean)false);
        Boolean lock = StoreLockUtil.getLock((Long)storeId);
        try {
            res = this.surplusService.validateSurplus(surplusUpdateVO);
            if (res.isSuccess()) {
                this.surplusService.updateStoreSurplus(surplusUpdateVO, false, true, true);
                this.flowService.saveOrUpdateBatch(BeanMapper.mapList((Iterable)flowVOList, FlowEntity.class));
                CommonResponse commonResponse = CommonResponse.success((Object)storeManageVO);
                return commonResponse;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        finally {
            if (lock.booleanValue()) {
                StoreLockUtil.releaseLock((Long)storeId);
            }
        }
        return CommonResponse.error((String)res.getMsg());
    }

    @Override
    public CommonResponse<StoreManageVO> handleRollback(StoreManageVO storeManageVO) {
        Long storeId = storeManageVO.getStoreId();
        Long sourceId = storeManageVO.getSourceId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"store_id", (Object)storeId);
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        List instoreList = this.flowService.list((Wrapper)queryWrapper);
        List flowVOList = BeanMapper.mapList((Iterable)instoreList, FlowVO.class);
        flowVOList.forEach(t -> {
            BigDecimal num = ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)t.getNum());
            t.setNum(num);
            t.setSurplusNum(num);
            BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)t.getNum(), (BigDecimal)t.getPrice());
            t.setMny(mny);
            t.setSurplusMny(mny);
            BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)t.getNum(), (BigDecimal)t.getTaxPrice());
            t.setTaxMny(taxMny);
            t.setSurplusTaxMny(taxMny);
        });
        SurplusUpdateVO surplusUpdateVO = StoreManageUtil.getSurplusUpdateVO((Long)storeId, (List)flowVOList, (boolean)false);
        Boolean lock = StoreLockUtil.getLock((Long)storeId);
        try {
            this.surplusService.updateStoreSurplus(surplusUpdateVO, false, true, true);
            List delListIds = flowVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
            this.flowService.removeByIds(delListIds);
            CommonResponse commonResponse = CommonResponse.success((Object)storeManageVO);
            return commonResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        finally {
            if (lock.booleanValue()) {
                StoreLockUtil.releaseLock((Long)storeId);
            }
        }
    }
}

