package com.ejianc.business.zdsstore.controller.api;

import com.ejianc.business.zdsstore.service.IIdleFlowService;
import com.ejianc.business.zdsstore.vo.IdleFlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/idleManage/")
public class IdleManageApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IIdleFlowService idleFlowService;

    @ApiOperation("出入库正向操作")
    @RequestMapping(value = "/inOutStore", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<String> inOutStore(@RequestBody List<IdleFlowVO> flowVOS) {
        return idleFlowService.inOutStore(flowVOS);
    }


    @ApiOperation("出入库逆向操作")
    @RequestMapping(value = "/inOutStoreRollback", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<String> inOutStoreRollback(@RequestParam Long storeId, @RequestParam Long sourceId) {
        return idleFlowService.inOutStoreRollback(storeId, sourceId);
    }

}
