package com.ejianc.business.zdsstore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.zdsstore.bean.*;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.consts.ZDSStoreBillBypeEnums;
import com.ejianc.business.zdsstore.mapper.CheckDetailMapper;
import com.ejianc.business.zdsstore.service.ICheckService;
import com.ejianc.business.zdsstore.service.IFlowService;
import com.ejianc.business.zdsstore.service.IInOutService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("check")
public class CheckBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICheckService checkService;

    @Autowired
    private IFlowService flowService;

    @Autowired
    private IInOutService iInOutService;

    @Autowired
    private StoreManageService storeManageService;

    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private CheckDetailMapper checkDetailMapper;
    @Autowired
    private IBillTypeApi billTypeApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        logger.info("提交完回调");
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        logger.info("终审审核前回调");
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("终审审核完回调");
        //TODO
        CheckEntity entity = checkService.selectById(billId);
        List<CheckDetailEntity> checkSubList = entity.getCheckSubList();
        List<CheckDetailEntity> subList = new ArrayList<>();
        List<CheckDetailEntity> outList = new ArrayList<>();
        checkSubList.forEach(item -> {
            if (item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) > 0) {
                subList.add(item);
            }
            if (item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) < 0) {
                outList.add(item);
            }
        });
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> longs = new ArrayList<>();
        longs.add(entity.getId());

        if (subList.size() > 0) {
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.盘盈入库);
            ArrayList<FlowVO> flowVOS = new ArrayList<>();
            // 准备回写最新价格
            Map<Long,FlowEntity> newPriceMap = new HashMap<>();
            subList.forEach(item -> {
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.盘盈入库, 0);
                flowVO.setSourceBillTypeName("盘点入库");
                flowVO.setSourceBillTypeCode(ZDSStoreBillBypeEnums.仓库盘点.getCode());
                flowVO.setSourceType(StoreCommonConsts.ZERO);// 0-自制,1-订单
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                //flowVO.setSupplierId(null); 盘点盈入库没有供货商
                //flowVO.setSupplierName(null);
                flowVO.setMaterialCategoryId(item.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(item.getMaterialCategoryName());
                flowVO.setMaterialId(item.getMaterialId());
                flowVO.setMaterialName(item.getMaterialName());
                flowVO.setMaterialSpec(item.getSpec());
                flowVO.setBrandId(item.getBrandId());
                flowVO.setBrandName(item.getBrandName());
                flowVO.setMaterialUnitId(item.getUnit());
                flowVO.setMaterialUnitName(item.getUnitName());
                flowVO.setNum(item.getInventory());
                flowVO.setProductCode(item.getProductCode());

                // 获取最新单价
                QueryWrapper<FlowEntity> wrapper = new QueryWrapper();
                wrapper.eq("store_id", entity.getStoreId());
                wrapper.eq("material_id", item.getMaterialId());
                wrapper.eq("in_out_flag", StoreCommonConsts.IN_OUT_TYPE_IN);
                wrapper.orderByDesc("source_bill_date");
                wrapper.last("limit 0,1");
                FlowEntity flowEntity = flowService.list(wrapper).get(0);

                flowVO.setTaxPrice(flowEntity.getTaxPrice());
                flowVO.setPrice(flowEntity.getPrice());
                flowVO.setTaxRate(flowEntity.getTaxRate());

                //准备最新的价格回写到盘点主子表
                newPriceMap.put(item.getMaterialId(),flowEntity);

                flowVO.setTaxMny(ComputeUtil.safeMultiply(flowVO.getTaxPrice(), item.getInventory()));
                flowVO.setMny(ComputeUtil.safeMultiply(flowVO.getPrice(), item.getInventory()));
                flowVO.setTax(ComputeUtil.safeSub(flowVO.getTaxMny(), flowVO.getMny()));
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(item.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getCheckDate());
                flowVOS.add(flowVO);
            });
            subList.forEach(item->{
                FlowEntity flowEntity = newPriceMap.get(item.getMaterialId());
                if(newPriceMap.get(item.getMaterialId()) != null){
                    item.setPrice(ComputeUtil.scaleTwo(flowEntity.getPrice()));
                    item.setTaxPrice(ComputeUtil.scaleTwo(flowEntity.getTaxPrice()));
                    item.setCostTaxMny(BigDecimal.ZERO.subtract(ComputeUtil.scaleTwo(flowEntity.getTaxMny())));
                    item.setCostMny(BigDecimal.ZERO.subtract(ComputeUtil.scaleTwo(flowEntity.getMny())));
                }
            });
            // 重新计算总额
            BigDecimal costTaxMny = (entity.getCostTaxMny() == null ? BigDecimal.ZERO : entity.getCostTaxMny());
            BigDecimal costMny = (entity.getCostMny() == null ? BigDecimal.ZERO : entity.getCostMny());

            for (CheckDetailEntity item:subList
                 ) {
                FlowEntity flowEntity = newPriceMap.get(item.getMaterialId());
                if(newPriceMap.get(item.getMaterialId()) != null){
                    costTaxMny = costTaxMny.add(item.getCostTaxMny());
                    costMny = costMny.add(item.getCostMny());
                }
            }
            costTaxMny = ComputeUtil.scaleTwo(costTaxMny);
            costMny = ComputeUtil.scaleTwo(costMny);

            entity.setCostTaxMny(costTaxMny);
            entity.setCostMny(costMny);
            subList.addAll(outList);
            entity.setCheckSubList(subList);
            checkDetailMapper.delByCheckId(entity.getId());
            checkService.saveOrUpdate(entity,false);
            storeManageVO.setFlowVOList(flowVOS);
            storeManageVO.setSourceId(billId);
            storeManageVO.setSourceIdsForRollBack(longs);
            storeManageService.inOutStore(storeManageVO);
        }
//        logger.info("推送成本---");
//        checkService.costPush(entity);
        if (outList.size() > 0) {
            checkService.checkOut(longs);
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO 弃审 校验是否被成本归集引用 引用则不能
        QueryWrapper<FlowEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("source_id", billId);
        wrapper.eq("in_out_flag", StoreCommonConsts.IN_OUT_TYPE_IN);
        List<FlowEntity> list = flowService.list(wrapper);
        List<Long> inIds = list.stream().map(FlowEntity::getId).collect(Collectors.toList());
        // 本次盘点有入库单 则进行校验
        if (inIds.size() > 0) {
            QueryWrapper<InOutEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("in_bill_id", billId);
            queryWrapper.in("in_flow_id", inIds);
            List<InOutEntity> entities = iInOutService.list(queryWrapper);
            for (InOutEntity entity : entities
            ) {
                if (entity.getOutNum().compareTo(BigDecimal.ZERO) > 0 || entity.getOutLockNum().compareTo(BigDecimal.ZERO) > 0) {
                    return CommonResponse.error("该盘点单的入库物资已被占用，无法弃审！");
                }
            }
        }
        CheckEntity checkEntity = checkService.selectById(billId);
        String checkDate = DateFormatUtil.formatDate("yyyy-MM-dd", checkEntity.getCheckDate());
        String createTime = DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", checkEntity.getCreateTime());
        QueryWrapper<CheckEntity> checkWrapper = new QueryWrapper<>();
        checkWrapper.eq("store_id", checkEntity.getStoreId());
        List<Integer> billstates = new ArrayList<>();
        billstates.add(StoreCommonConsts.ZERO);
        billstates.add(StoreCommonConsts.ONE);
        billstates.add(StoreCommonConsts.THREE);
        checkWrapper.in("bill_state", billstates);
        checkWrapper.apply(" (check_date > '" + checkDate + "' or (check_date = '" + checkDate + "' and create_time > '" + createTime + "'))");
        List<CheckEntity> checkList = checkService.list(checkWrapper);
        if (checkList.size() > 0) {
            return CommonResponse.error("该盘点单后已存在盘点单，无法弃审！");
        }

        CommonResponse<String> commonResponse = billTypeApi.checkQuote(billTypeCode, checkEntity.getId());
        boolean success = commonResponse.isSuccess();
        if (!success){
            return CommonResponse.error("已经被归集单使用,不能弃审和撤回");
        }

        StoreManageVO storeManageVO = new StoreManageVO();
        List<Long> SourceIds = new ArrayList<>();
        CheckEntity entity = checkService.selectById(billId);
        List<CheckDetailEntity> checkSubList = entity.getCheckSubList();
        Boolean checkInFlag = false;
        Boolean checkOutFlag = false;
        for (CheckDetailEntity item : checkSubList
        ) {
            if (item.getInventory().compareTo(BigDecimal.ZERO) > 0) {
                checkInFlag = true;
                if (checkOutFlag) break;
            }
            if (item.getInventory().compareTo(BigDecimal.ZERO) < 0) {
                checkOutFlag = true;
                if (checkInFlag) break;
            }
        }
        SourceIds.add(billId);
        storeManageVO.setSourceId(billId);
        storeManageVO.setStoreId(entity.getStoreId());
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.盘亏出库);
        storeManageVO.setSourceIdsForRollBack(SourceIds);
        storeManageVO.setOutEffectiveON(true);
        if (checkOutFlag) {
            CommonResponse<StoreManageVO> storeManageVOCommonResponse = storeManageService.inOutStoreRollback(storeManageVO);
            if (!storeManageVOCommonResponse.isSuccess())
                return CommonResponse.error(storeManageVOCommonResponse.getMsg());
        }
        if (checkInFlag) {
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.盘盈入库);
            CommonResponse<StoreManageVO> storeManageVOCommonResponse = storeManageService.inOutStoreRollback(storeManageVO);
            if (!storeManageVOCommonResponse.isSuccess())
                return CommonResponse.error(storeManageVOCommonResponse.getMsg());
        }
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO 弃审后删除成本池
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
         if(!resp.isSuccess()){
         return CommonResponse.error("无法撤回！"+resp.getMsg());
         }*/

        CheckEntity checkEntity = checkService.selectById(billId);
        //更新是实际成本生效状态
        CommonResponse<String> costResponse = costDetailApi.updateCostDetail(checkEntity.getId(),0);
        logger.info("结果"+ JSONObject.toJSONString(costResponse));
        if(!costResponse.isSuccess()){
            throw new BusinessException(costResponse.getMsg());
        }
        //更新是否关联
        LambdaUpdateWrapper<CheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(CheckEntity::getId, checkEntity.getId());
        updateWrapper.set(CheckEntity::getRelationFlag, 0);//(1:是，0：否)
        checkService.update(updateWrapper);
        return CommonResponse.success();
    }
}
