package com.ejianc.business.zdsstore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.zdsstore.bean.HandleDetailEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.mapper.HandleDetailMapper;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.business.zdsstore.vo.*;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zdsstore.mapper.HandleMapper;
import com.ejianc.business.zdsstore.bean.HandleEntity;
import com.ejianc.business.zdsstore.service.IHandleService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 仓库材料处置表
 *
 * @author generator
 *
 */
@Service("handleService")
public class HandleServiceImpl extends BaseServiceImpl<HandleMapper, HandleEntity> implements IHandleService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private HandleDetailMapper handleDetailMapper;

    @Autowired
    private StoreManageService storeManageService;

    // 推送成本需要调用的接口 start
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExecutionApi executionApi;

    @Override
    public CommonResponse saveCheckHandle(HandleEntity entity) {
        //更新子表信息
        if(null != entity.getId()) {
            handleDetailMapper.delByHandleId(entity.getId());
        }

        List<HandleDetailEntity> subList = new ArrayList<>();
        List<HandleDetailEntity> handleSubList = entity.getHandleSubList();
        // 设置主表分类名称
        String names = "";
        for (HandleDetailEntity detailEntity:handleSubList
        ) {
            if(detailEntity.getHandleNum() != null && detailEntity.getHandleNum().compareTo(BigDecimal.ZERO) > 0){
                subList.add(detailEntity);
            }
            names = names+detailEntity.getMaterialCategoryName()+",";
        }
        if(handleSubList.size() > 0){
            names = names.substring(0,names.length()-1);
        }
        entity.setMaterialTypes(names);
        super.saveOrUpdate(entity, false);

        if(subList.size() > 0){
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.材料处置);
            ArrayList<FlowVO> flowVOS = new ArrayList<>();
            subList.forEach(item->{
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.材料处置,0);
                flowVO.setSourceBillTypeName("处置出库");
                flowVO.setSourceBillTypeCode("BT220125000000010");
                flowVO.setSourceType(StoreCommonConsts.ZERO);// 0-自制,1-订单
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(item.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(item.getMaterialCategoryName());
                flowVO.setMaterialId(item.getMaterialId());
                flowVO.setMaterialName(item.getMaterialName());
                flowVO.setMaterialSpec(item.getSpec());
                flowVO.setNum(item.getHandleNum());
                flowVO.setTaxPrice(item.getHandlePrice());
                flowVO.setTaxMny(item.getHandleMny());
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(item.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getHandleDate());
                flowVOS.add(flowVO);
            });
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> commonResponse = storeManageService.inOutStore(storeManageVO);
            if(!commonResponse.isSuccess()){
                return commonResponse;
            }
        }
        return CommonResponse.success(entity);
    }

    @Override
    public CommonResponse myRemoveByIds(List<Long> ids) {
        CommonResponse commonResponse = handleInOut(ids,false);
        if(!commonResponse.isSuccess()){
            return commonResponse;
        }
        super.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public CommonResponse handleInOut(List<Long> ids,Boolean outEffectiveON){
        StoreManageVO storeManageVO = new StoreManageVO();
        List<Long> SourceIds = new ArrayList<>();
        for (Long item:ids
        ) {
            HandleEntity entity = super.selectById(item);
            List<HandleDetailEntity> handleSubList = entity.getHandleSubList();
            Boolean checkFlag = false;
            for (HandleDetailEntity t:handleSubList
            ) {
                if(t.getHandleNum().compareTo(BigDecimal.ZERO) > 0){
                    checkFlag = true;
                    break;
                }
            }
            if(checkFlag){
                SourceIds.clear();
                SourceIds.add(item);
                storeManageVO.setSourceId(item);
                storeManageVO.setStoreId(entity.getStoreId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.材料处置);
                storeManageVO.setSourceIdsForRollBack(SourceIds);
                storeManageVO.setOutEffectiveON(outEffectiveON);
                CommonResponse<StoreManageVO> commonResponse;
                if(outEffectiveON){
                    commonResponse = storeManageService.inOutStore(storeManageVO);
                }else{
                    commonResponse = storeManageService.inOutStoreRollback(storeManageVO);
                }
                if(!commonResponse.isSuccess()){
                    return commonResponse;
                }
            }
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<HandleVO> pushCost(HandleVO handleVO) {
        HandleEntity handleEntity = baseMapper.selectById(handleVO.getId());
        if (CollectionUtils.isNotEmpty(handleVO.getHandleSubList())) {
            List<HandleDetailEntity> handleDetailEntities = BeanMapper.mapList(handleVO.getHandleSubList(), HandleDetailEntity.class);
            handleEntity.setHandleSubList(handleDetailEntities);
        }
        super.saveOrUpdate(handleEntity, false);
        //推送数据
        this.costPush(handleEntity);
        return CommonResponse.success(BeanMapper.map(handleEntity, HandleVO.class));
    }

    @Override
    public void costPush(HandleEntity handleEntity) {
        logger.info("开始costPush");
        List<HandleDetailEntity> handleSubList = handleEntity.getHandleSubList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(handleSubList)) {
            for (HandleDetailEntity entity : handleSubList) {
                if (null == entity.getSubjectId() || null == entity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(handleSubList)) {
            newRelationFlag = "0";
        }
        //先删后增
        saveCost(handleEntity,1);//生效状态 0-未生效，1-生效
        //更新是否关联
        LambdaUpdateWrapper<HandleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(HandleEntity::getId, handleEntity.getId());
        updateWrapper.set(HandleEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);


    }
    @Override
    public void saveCost(HandleEntity handleEntity,Integer effectiveStatus) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<HandleDetailEntity> handleSubList = handleEntity.getHandleSubList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(handleSubList)) {
            //根据物资id查询物资编码
            List<Long> materialIds = handleSubList.stream().map(HandleDetailEntity::getMaterialId).collect(Collectors.toList());
            CommonResponse<List<MaterialVO>> listCommonResponse = shareMaterialApi.queryMaterialByIds(materialIds);
            List<MaterialVO> voList = new ArrayList<>();
            if(listCommonResponse.isSuccess()){
                voList = listCommonResponse.getData();
            }
            Map<Long, String> materialMap = new HashMap<>();
            voList.forEach(item -> materialMap.put(item.getId(),item.getCode()));
            for (HandleDetailEntity entity : handleSubList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(entity.getSubjectId());
                costDetailVO.setSubjectCode(entity.getSubjectCode());
                costDetailVO.setSubjectName(entity.getSubjectName());
                costDetailVO.setWbsId(entity.getWbsId());
                costDetailVO.setWbsCode(entity.getWbsCode());
                costDetailVO.setWbsName(entity.getWbsName());
                costDetailVO.setSourceId(entity.getHandleId());
                costDetailVO.setSourceDetailId(entity.getId());
                costDetailVO.setHappenTaxMny(entity.getHandleSubTaxMny());
                costDetailVO.setHappenMny(entity.getHandleSubMny());
                costDetailVO.setHappenDate(handleEntity.getHandleDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("STORE_HANDLE");
                costDetailVO.setSourceTabType("STORE_HANDLE_SUB");
                //新加的
                costDetailVO.setSourceBillCode(handleEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.材料处置单.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-zdsstore-frontend/#/storeHandle/card?id="+handleEntity.getId());
                costDetailVO.setProjectId(handleEntity.getProjectId());
                //2022-8-16新增传输字段
                costDetailVO.setMaterialId(entity.getMaterialId());
                costDetailVO.setMaterialName(entity.getMaterialName());
                costDetailVO.setMaterialTypeId(entity.getMaterialCategoryId());
                costDetailVO.setMaterialTypeName(entity.getMaterialCategoryName());
                costDetailVO.setMaterialCode(materialMap.get(entity.getMaterialId()));
                costDetailVO.setUnitId(entity.getUnit());
                costDetailVO.setUnit(entity.getUnitName());
                costDetailVO.setSpec(entity.getSpec());
                costDetailVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
                costDetailVOList.add(costDetailVO);
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }


    @Override
    public ParamsCheckVO checkParams(HandleVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        //--成本科目控制
        CostCtrlVO costCtrlVO = this.sjCost(vo);
        if(null!=costCtrlVO){
            CommonResponse<ParamsCheckVO> costResponse = executionApi.ctrlCost(costCtrlVO);
            if (!costResponse.isSuccess()) {
                throw new BusinessException("成本科目控制失败," + costResponse.getMsg());
            }
            ParamsCheckVO costRes = costResponse.getData();
            if(null!=costRes){
                paramsCheckVOS.add(costRes);
            }
        }
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                }
                else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    public CostCtrlVO sjCost(HandleVO vo){
        List<HandleDetailVO> feeList = vo.getHandleSubList();
        if(CollectionUtils.isNotEmpty(feeList)){
            Map<Long, CostCtrlDetailVO> map = new HashMap<>();
            for(HandleDetailVO handleDetailVO:feeList){
                if(null!=handleDetailVO.getSubjectId() &&!"del".equals(handleDetailVO.getRowState())){
                    BigDecimal feeMny = handleDetailVO.getHandleSubMny()==null?BigDecimal.ZERO:handleDetailVO.getHandleSubMny();
                    BigDecimal feeTaxMny = handleDetailVO.getHandleSubTaxMny()==null?BigDecimal.ZERO:handleDetailVO.getHandleSubTaxMny();
                    if(map.containsKey(handleDetailVO.getSubjectId())){
                        CostCtrlDetailVO costCtrlDetailVO = map.get(handleDetailVO.getSubjectId());
                        BigDecimal mny = costCtrlDetailVO.getMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getMny();
                        BigDecimal taxMny = costCtrlDetailVO.getTaxMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getTaxMny();
                        costCtrlDetailVO.setMny(mny.add(feeMny));
                        costCtrlDetailVO.setTaxMny(taxMny.add(feeTaxMny));
                    }else{
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(handleDetailVO.getSubjectId());
                        costCtrlDetailVO.setMny(feeMny);
                        costCtrlDetailVO.setTaxMny(feeTaxMny);
                        map.put(costCtrlDetailVO.getSubjectId(),costCtrlDetailVO);
                    }
                }
            }
            if(null != map && map.size() > 0){
                CostCtrlVO ctrlVO = new CostCtrlVO();
                if(null!=vo.getId()){
                    ctrlVO.setSourceId(vo.getId());
                }
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList<>(map.values()));
                return ctrlVO;
            }else{
                return null;
            }
        }
        return null;
    }

}
