/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.zdsstore.bean.CheckDetailEntity;
import com.ejianc.business.zdsstore.bean.CheckEntity;
import com.ejianc.business.zdsstore.bean.FlowEntity;
import com.ejianc.business.zdsstore.bean.InOutEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.consts.ZDSStoreBillBypeEnums;
import com.ejianc.business.zdsstore.mapper.CheckDetailMapper;
import com.ejianc.business.zdsstore.service.ICheckService;
import com.ejianc.business.zdsstore.service.IFlowService;
import com.ejianc.business.zdsstore.service.IInOutService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="check")
public class CheckBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IFlowService flowService;
    @Autowired
    private IInOutService iInOutService;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private CheckDetailMapper checkDetailMapper;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u63d0\u4ea4\u5b8c\u56de\u8c03");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u524d\u56de\u8c03");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03");
        CheckEntity entity = (CheckEntity)((Object)this.checkService.selectById(billId));
        List<CheckDetailEntity> checkSubList = entity.getCheckSubList();
        ArrayList<CheckDetailEntity> subList = new ArrayList<CheckDetailEntity>();
        ArrayList outList = new ArrayList();
        checkSubList.forEach(item -> {
            if (item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) > 0) {
                subList.add((CheckDetailEntity)((Object)item));
            }
            if (item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) < 0) {
                outList.add(item);
            }
        });
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> longs = new ArrayList<Long>();
        longs.add(entity.getId());
        if (subList.size() > 0) {
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76d8\u76c8\u5165\u5e93);
            ArrayList flowVOS = new ArrayList();
            HashMap newPriceMap = new HashMap();
            subList.forEach(item -> {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u76d8\u76c8\u5165\u5e93, (Integer)0);
                flowVO.setSourceBillTypeName("\u76d8\u70b9\u5165\u5e93");
                flowVO.setSourceBillTypeCode(ZDSStoreBillBypeEnums.\u4ed3\u5e93\u76d8\u70b9.getCode());
                flowVO.setSourceType(StoreCommonConsts.ZERO);
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(item.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(item.getMaterialCategoryName());
                flowVO.setMaterialId(item.getMaterialId());
                flowVO.setMaterialName(item.getMaterialName());
                flowVO.setMaterialSpec(item.getSpec());
                flowVO.setBrandId(item.getBrandId());
                flowVO.setBrandName(item.getBrandName());
                flowVO.setMaterialUnitId(item.getUnit());
                flowVO.setMaterialUnitName(item.getUnitName());
                flowVO.setNum(item.getInventory());
                flowVO.setProductCode(item.getProductCode());
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"store_id", (Object)entity.getStoreId());
                wrapper.eq((Object)"material_id", (Object)item.getMaterialId());
                wrapper.eq((Object)"in_out_flag", (Object)StoreCommonConsts.IN_OUT_TYPE_IN);
                wrapper.orderByDesc((Object)"source_bill_date");
                wrapper.last("limit 0,1");
                FlowEntity flowEntity = (FlowEntity)((Object)((Object)this.flowService.list((Wrapper)wrapper).get(0)));
                flowVO.setTaxPrice(flowEntity.getTaxPrice());
                flowVO.setPrice(flowEntity.getPrice());
                flowVO.setTaxRate(flowEntity.getTaxRate());
                newPriceMap.put(item.getMaterialId(), flowEntity);
                flowVO.setTaxMny(ComputeUtil.safeMultiply((BigDecimal)flowVO.getTaxPrice(), (BigDecimal)item.getInventory()));
                flowVO.setMny(ComputeUtil.safeMultiply((BigDecimal)flowVO.getPrice(), (BigDecimal)item.getInventory()));
                flowVO.setTax(ComputeUtil.safeSub((BigDecimal)flowVO.getTaxMny(), (BigDecimal)flowVO.getMny()));
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(item.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getCheckDate());
                flowVOS.add(flowVO);
            });
            subList.forEach(item -> {
                FlowEntity flowEntity = (FlowEntity)((Object)((Object)newPriceMap.get(item.getMaterialId())));
                if (newPriceMap.get(item.getMaterialId()) != null) {
                    item.setPrice(ComputeUtil.scaleTwo((BigDecimal)flowEntity.getPrice()));
                    item.setTaxPrice(ComputeUtil.scaleTwo((BigDecimal)flowEntity.getTaxPrice()));
                    item.setCostTaxMny(BigDecimal.ZERO.subtract(ComputeUtil.scaleTwo((BigDecimal)flowEntity.getTaxMny())));
                    item.setCostMny(BigDecimal.ZERO.subtract(ComputeUtil.scaleTwo((BigDecimal)flowEntity.getMny())));
                }
            });
            BigDecimal costTaxMny = entity.getCostTaxMny() == null ? BigDecimal.ZERO : entity.getCostTaxMny();
            BigDecimal costMny = entity.getCostMny() == null ? BigDecimal.ZERO : entity.getCostMny();
            for (CheckDetailEntity item2 : subList) {
                FlowEntity flowEntity = (FlowEntity)((Object)newPriceMap.get(item2.getMaterialId()));
                if (newPriceMap.get(item2.getMaterialId()) == null) continue;
                costTaxMny = costTaxMny.add(item2.getCostTaxMny());
                costMny = costMny.add(item2.getCostMny());
            }
            costTaxMny = ComputeUtil.scaleTwo((BigDecimal)costTaxMny);
            costMny = ComputeUtil.scaleTwo((BigDecimal)costMny);
            entity.setCostTaxMny(costTaxMny);
            entity.setCostMny(costMny);
            subList.addAll(outList);
            entity.setCheckSubList(subList);
            this.checkDetailMapper.delByCheckId(entity.getId());
            this.checkService.saveOrUpdate((Object)entity, false);
            storeManageVO.setFlowVOList(flowVOS);
            storeManageVO.setSourceId(billId);
            storeManageVO.setSourceIdsForRollBack(longs);
            this.storeManageService.inOutStore(storeManageVO);
        }
        if (outList.size() > 0) {
            this.checkService.checkOut(longs);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse<StoreManageVO> storeManageVOCommonResponse;
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"source_id", (Object)billId);
        wrapper.eq((Object)"in_out_flag", (Object)StoreCommonConsts.IN_OUT_TYPE_IN);
        List list = this.flowService.list((Wrapper)wrapper);
        List inIds = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (inIds.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"in_bill_id", (Object)billId);
            queryWrapper.in((Object)"in_flow_id", inIds);
            List entities = this.iInOutService.list((Wrapper)queryWrapper);
            for (InOutEntity entity : entities) {
                if (entity.getOutNum().compareTo(BigDecimal.ZERO) <= 0 && entity.getOutLockNum().compareTo(BigDecimal.ZERO) <= 0) continue;
                return CommonResponse.error((String)"\u8be5\u76d8\u70b9\u5355\u7684\u5165\u5e93\u7269\u8d44\u5df2\u88ab\u5360\u7528\uff0c\u65e0\u6cd5\u5f03\u5ba1\uff01");
            }
        }
        CheckEntity checkEntity = (CheckEntity)((Object)this.checkService.selectById(billId));
        String checkDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)checkEntity.getCheckDate());
        String createTime = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)checkEntity.getCreateTime());
        QueryWrapper checkWrapper = new QueryWrapper();
        checkWrapper.eq((Object)"store_id", (Object)checkEntity.getStoreId());
        ArrayList<Integer> billstates = new ArrayList<Integer>();
        billstates.add(StoreCommonConsts.ZERO);
        billstates.add(StoreCommonConsts.ONE);
        billstates.add(StoreCommonConsts.THREE);
        checkWrapper.in((Object)"bill_state", billstates);
        checkWrapper.apply(" (check_date > '" + checkDate + "' or (check_date = '" + checkDate + "' and create_time > '" + createTime + "'))", new Object[0]);
        List checkList = this.checkService.list((Wrapper)checkWrapper);
        if (checkList.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u76d8\u70b9\u5355\u540e\u5df2\u5b58\u5728\u76d8\u70b9\u5355\uff0c\u65e0\u6cd5\u5f03\u5ba1\uff01");
        }
        CommonResponse commonResponse = this.billTypeApi.checkQuote(billTypeCode, checkEntity.getId());
        boolean success = commonResponse.isSuccess();
        if (!success) {
            return CommonResponse.error((String)"\u5df2\u7ecf\u88ab\u5f52\u96c6\u5355\u4f7f\u7528,\u4e0d\u80fd\u5f03\u5ba1\u548c\u64a4\u56de");
        }
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        CheckEntity entity = (CheckEntity)((Object)this.checkService.selectById(billId));
        List<CheckDetailEntity> checkSubList = entity.getCheckSubList();
        Boolean checkInFlag = false;
        Boolean checkOutFlag = false;
        for (CheckDetailEntity item : checkSubList) {
            if (item.getInventory().compareTo(BigDecimal.ZERO) > 0) {
                checkInFlag = true;
                if (checkOutFlag.booleanValue()) break;
            }
            if (item.getInventory().compareTo(BigDecimal.ZERO) >= 0) continue;
            checkOutFlag = true;
            if (!checkInFlag.booleanValue()) continue;
            break;
        }
        SourceIds.add(billId);
        storeManageVO.setSourceId(billId);
        storeManageVO.setStoreId(entity.getStoreId());
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76d8\u4e8f\u51fa\u5e93);
        storeManageVO.setSourceIdsForRollBack(SourceIds);
        storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
        if (checkOutFlag.booleanValue() && !(storeManageVOCommonResponse = this.storeManageService.inOutStoreRollback(storeManageVO)).isSuccess()) {
            return CommonResponse.error((String)storeManageVOCommonResponse.getMsg());
        }
        if (checkInFlag.booleanValue()) {
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76d8\u76c8\u5165\u5e93);
            storeManageVOCommonResponse = this.storeManageService.inOutStoreRollback(storeManageVO);
            if (!storeManageVOCommonResponse.isSuccess()) {
                return CommonResponse.error((String)storeManageVOCommonResponse.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CheckEntity checkEntity = (CheckEntity)((Object)this.checkService.selectById(billId));
        CommonResponse costResponse = this.costDetailApi.updateCostDetail(checkEntity.getId(), Integer.valueOf(0));
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)costResponse));
        if (!costResponse.isSuccess()) {
            throw new BusinessException(costResponse.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{checkEntity.getId()});
        updateWrapper.set(CheckEntity::getRelationFlag, (Object)0);
        this.checkService.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }
}

