/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.zdsstore.bean.AllotOutDetailEntity;
import com.ejianc.business.zdsstore.bean.AllotOutEntity;
import com.ejianc.business.zdsstore.consts.AllocatEnum;
import com.ejianc.business.zdsstore.consts.AllocationState;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.mapper.AllotOutMapper;
import com.ejianc.business.zdsstore.service.IAllotOutService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.AllotOutDetailVO;
import com.ejianc.business.zdsstore.vo.AllotOutExportVO;
import com.ejianc.business.zdsstore.vo.AllotOutVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdsstore.vo.UseMaterialPriceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="allotOutService")
public class AllotOutServiceImpl
extends BaseServiceImpl<AllotOutMapper, AllotOutEntity>
implements IAllotOutService {
    @Autowired
    StoreManageService storeManageService;
    @Autowired
    private IAllotOutService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "ALLOT_OUT";
    @Autowired
    private IOrgApi iOrgApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExecutionApi executionApi;

    @Override
    public CommonResponse<StoreManageVO> surplusMaterialPrice(AllotOutVO saveOrUpdateVO) {
        StoreManageVO storeManageVO = saveOrUpdateVO.getStoreManageVO(saveOrUpdateVO);
        CommonResponse<StoreManageVO> commonResponse = this.storeManageService.surplusMaterialPrice(storeManageVO);
        return commonResponse;
    }

    @Override
    public CommonResponse<List<StoreManageVO>> surplusListMaterialPrice(AllotOutVO saveOrUpdateVO) {
        ArrayList<Object> manageVOS = new ArrayList<Object>();
        List storeManageVO = saveOrUpdateVO.getStoreManageVOList(saveOrUpdateVO);
        for (StoreManageVO storeManageVO1 : storeManageVO) {
            CommonResponse<StoreManageVO> commonResponse = this.storeManageService.surplusMaterialPrice(storeManageVO1);
            manageVOS.add(commonResponse.getData());
        }
        return CommonResponse.success(manageVOS);
    }

    @Override
    public CommonResponse<AllotOutVO> allotOutSaveOrUpdate(AllotOutVO saveOrUpdateVO) {
        boolean b;
        AllotOutEntity entity;
        CommonResponse<List<StoreManageVO>> listCommonResponse;
        List data1;
        if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getAllotOutDetailList()) && (data1 = (List)(listCommonResponse = this.service.surplusListMaterialPrice(saveOrUpdateVO)).getData()) != null) {
            for (StoreManageVO data : data1) {
                List useMaterialPriceVOList;
                if (data == null || !CollectionUtils.isNotEmpty((Collection)(useMaterialPriceVOList = data.getUseMaterialPriceVOList()))) continue;
                HashMap collect = new HashMap();
                for (UseMaterialPriceVO vo : useMaterialPriceVOList) {
                    if (collect.containsKey(vo.getMaterialId() + "@" + vo.getBrandId())) {
                        ((List)collect.get(vo.getMaterialId() + "@" + vo.getBrandId())).add(vo);
                        continue;
                    }
                    ArrayList<UseMaterialPriceVO> useMaterialPriceVOS = new ArrayList<UseMaterialPriceVO>();
                    useMaterialPriceVOS.add(vo);
                    collect.put(vo.getMaterialId() + "@" + vo.getBrandId(), useMaterialPriceVOS);
                }
                List allotOutDetailList = saveOrUpdateVO.getAllotOutDetailList();
                if (CollectionUtils.isNotEmpty((Collection)allotOutDetailList)) {
                    for (AllotOutDetailVO allotOutDetailEntity : allotOutDetailList) {
                        if (!collect.containsKey(allotOutDetailEntity.getMaterialId() + "@" + allotOutDetailEntity.getBrandId())) continue;
                        List useMaterialPriceVos = (List)collect.get(allotOutDetailEntity.getMaterialId() + "@" + allotOutDetailEntity.getBrandId());
                        UseMaterialPriceVO useMaterialPriceVO = (UseMaterialPriceVO)useMaterialPriceVos.get(0);
                        allotOutDetailEntity.setInStoreMny(ComputeUtil.scaleTwo((BigDecimal)useMaterialPriceVO.getMny()));
                        allotOutDetailEntity.setInStoreTaxMny(ComputeUtil.scaleTwo((BigDecimal)useMaterialPriceVO.getTaxMny()));
                        allotOutDetailEntity.setInStoreTax(useMaterialPriceVO.getTax());
                        if (useMaterialPriceVO.getTaxMny() != null && allotOutDetailEntity.getAllocatNum() != null) {
                            BigDecimal inStoreAveragePrice = ComputeUtil.safeDiv((BigDecimal)useMaterialPriceVO.getTaxMny(), (BigDecimal)allotOutDetailEntity.getAllocatNum());
                            allotOutDetailEntity.setInStoreAveragePrice(inStoreAveragePrice);
                        }
                        BigDecimal mny = ComputeUtil.scaleTwo((BigDecimal)useMaterialPriceVO.getMny());
                        BigDecimal taxMny = ComputeUtil.scaleTwo((BigDecimal)useMaterialPriceVO.getTaxMny());
                        if (!ComputeUtil.isNotEmpty((BigDecimal)taxMny).booleanValue() || !ComputeUtil.isNotEmpty((BigDecimal)mny).booleanValue()) continue;
                        BigDecimal bigDecimal = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)mny);
                        BigDecimal inStoreRate = ComputeUtil.safeSub((BigDecimal)bigDecimal, (BigDecimal)BigDecimal.ONE);
                        allotOutDetailEntity.setInStoreTaxRate(ComputeUtil.safeMultiply((BigDecimal)inStoreRate, (BigDecimal)new BigDecimal(100)));
                    }
                }
                saveOrUpdateVO.setAllotOutDetailList(allotOutDetailList);
            }
        }
        if ((entity = (AllotOutEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AllotOutEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.setProportionFlag("0");
                entity.setRelationFlag("0");
                entity.setReceiveState(Integer.parseInt(AllocationState.TO_RECEIVING.getCode()));
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if ((b = this.service.saveOrUpdate((Object)entity, false)) && CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getAllotOutDetailList())) {
            saveOrUpdateVO = (AllotOutVO)BeanMapper.map((Object)((Object)entity), AllotOutVO.class);
            saveOrUpdateVO.setId(entity.getId());
            saveOrUpdateVO.setBillCode(entity.getBillCode());
            List storeManageVOList = saveOrUpdateVO.getStoreManageVOList(saveOrUpdateVO);
            for (StoreManageVO manageVO : storeManageVOList) {
                this.storeManageService.inOutStore(manageVO);
            }
        }
        AllotOutVO vo = (AllotOutVO)BeanMapper.map((Object)((Object)entity), AllotOutVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u4fee\u6539\u6210\u529f", (Object)vo);
    }

    @Override
    public CommonResponse<String> allotOutDelete(List<AllotOutVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AllotOutVO vo : vos) {
                AllotOutEntity allotOutEntity = (AllotOutEntity)((Object)this.service.selectById(vo.getId()));
                if (!CollectionUtils.isNotEmpty(allotOutEntity.getAllotOutDetailList())) continue;
                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setStoreId(allotOutEntity.getStoreId());
                storeManageVO.setSourceId(allotOutEntity.getId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u8c03\u62e8\u51fa\u5e93);
                ArrayList<Long> longs = new ArrayList<Long>();
                longs.add(allotOutEntity.getId());
                storeManageVO.setSourceIdsForRollBack(longs);
                this.storeManageService.inOutStoreRollback(storeManageVO);
            }
            Collection list = this.service.listByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
            list.forEach(e -> {
                CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(e.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
                if (!stringCommonResponse.isSuccess()) {
                    throw new BusinessException(stringCommonResponse.getMsg());
                }
            });
        }
        boolean b = this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialNames");
        fuzzyFields.add("inProjectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("receiverPerson");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List allotOutVos = BeanMapper.mapList((Iterable)list, AllotOutExportVO.class);
        allotOutVos.forEach(vo -> {
            if (vo.getOutDate() != null) {
                vo.setAllocatDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getOutDate()));
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            if (vo.getReceiveState() != null) {
                if (Integer.valueOf(AllocationState.TO_RECEIVING.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.TO_RECEIVING.getDescription());
                } else if (Integer.valueOf(AllocationState.RECEIVED.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.RECEIVED.getDescription());
                } else if (Integer.valueOf(AllocationState.REJECT.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.REJECT.getDescription());
                }
            }
            if (vo.getAllocatType() != null) {
                if (Integer.valueOf(AllocatEnum.ASSETS.getCode()).equals(vo.getAllocatType())) {
                    vo.setAllocatTypeName(AllocatEnum.ASSETS.getDescription());
                } else {
                    vo.setAllocatTypeName(AllocatEnum.HOMEMADE.getDescription());
                }
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", allotOutVos);
        ExcelExport.getInstance().export("allocationOutExport.xlsx", beans, response);
    }

    @Override
    public CommonResponse<AllotOutVO> pushCost(AllotOutVO allotOutVO) {
        AllotOutEntity allotOutEntity = (AllotOutEntity)((Object)((AllotOutMapper)this.baseMapper).selectById(allotOutVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)allotOutVO.getAllotOutDetailList())) {
            List allotOutDetailEntitys = BeanMapper.mapList((Iterable)allotOutVO.getAllotOutDetailList(), AllotOutDetailEntity.class);
            allotOutEntity.setAllotOutDetailList(allotOutDetailEntitys);
        }
        super.saveOrUpdate((Object)allotOutEntity, false);
        this.costPush(allotOutEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)allotOutEntity), AllotOutVO.class));
    }

    @Override
    public void costPush(AllotOutEntity allotOutEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<AllotOutDetailEntity> allotOutDetailEntities = allotOutEntity.getAllotOutDetailList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(allotOutDetailEntities)) {
            for (AllotOutDetailEntity entity : allotOutDetailEntities) {
                if (null != entity.getSubjectId() && null != entity.getWbsId()) continue;
                newRelationFlag = "0";
                this.logger.info("getSubjectId" + entity.getSubjectId());
                this.logger.info("getWbsId" + entity.getWbsId());
                break;
            }
        }
        if (ListUtil.isEmpty(allotOutDetailEntities)) {
            newRelationFlag = "0";
        }
        this.logger.info("newRelationFlag" + newRelationFlag);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{allotOutEntity.getId()});
        updateWrapper.set(AllotOutEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
    }

    private void saveCost(AllotOutEntity allotOutEntity, Integer effectiveStatus) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<AllotOutDetailEntity> allotOutDetailList = allotOutEntity.getAllotOutDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(allotOutDetailList)) {
            List materialIds = allotOutDetailList.stream().map(AllotOutDetailEntity::getMaterialId).collect(Collectors.toList());
            CommonResponse listCommonResponse = this.shareMaterialApi.queryMaterialByIds(materialIds);
            List voList = new ArrayList();
            if (listCommonResponse.isSuccess()) {
                voList = (List)listCommonResponse.getData();
            }
            HashMap materialMap = new HashMap();
            voList.forEach(item -> materialMap.put(item.getId(), item.getCode()));
            for (AllotOutDetailEntity entity : allotOutDetailList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(entity.getSubjectId());
                costDetailVO.setSubjectCode(entity.getSubjectCode());
                costDetailVO.setSubjectName(entity.getSubjectName());
                costDetailVO.setWbsId(entity.getWbsId());
                costDetailVO.setWbsCode(entity.getWbsCode());
                costDetailVO.setWbsName(entity.getWbsName());
                costDetailVO.setSourceId(entity.getAllocatId());
                costDetailVO.setSourceDetailId(entity.getId());
                costDetailVO.setHappenTaxMny(entity.getAllotDiffTaxMny());
                costDetailVO.setHappenMny(entity.getAllotDiffMny());
                costDetailVO.setHappenDate(allotOutEntity.getOutDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(BILL_CODE);
                costDetailVO.setSourceTabType("ALLOT_OUT_SUB");
                costDetailVO.setProjectId(allotOutEntity.getProjectId());
                costDetailVO.setSourceBillCode(allotOutEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u8c03\u62e8\u51fa\u5e93\u5355.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-zdsstore-frontend/#/allotOut/card?id=" + allotOutEntity.getId());
                costDetailVO.setMaterialId(entity.getMaterialId());
                costDetailVO.setMaterialName(entity.getMaterialName());
                costDetailVO.setMaterialTypeId(entity.getMaterialCategoryId());
                costDetailVO.setMaterialTypeName(entity.getMaterialCategoryName());
                costDetailVO.setMaterialCode((String)materialMap.get(entity.getMaterialId()));
                costDetailVO.setUnitId(entity.getMaterialUnitId());
                costDetailVO.setUnit(entity.getMaterialUnit());
                costDetailVO.setSpec(entity.getMaterialSpec());
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public ParamsCheckVO checkParams(AllotOutVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        CostCtrlVO costCtrlVO = this.sjCost(vo);
        if (null != costCtrlVO) {
            CommonResponse costResponse = this.executionApi.ctrlCost(costCtrlVO);
            if (!costResponse.isSuccess()) {
                throw new BusinessException("\u6210\u672c\u79d1\u76ee\u63a7\u5236\u5931\u8d25," + costResponse.getMsg());
            }
            ParamsCheckVO costRes = (ParamsCheckVO)costResponse.getData();
            if (null != costRes) {
                paramsCheckVOS.add(costRes);
            }
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    public CostCtrlVO sjCost(AllotOutVO vo) {
        List feeList = vo.getAllotOutDetailList();
        if (CollectionUtils.isNotEmpty((Collection)feeList)) {
            HashMap<Long, CostCtrlDetailVO> map = new HashMap<Long, CostCtrlDetailVO>();
            for (AllotOutDetailVO allotOutDetailVO : feeList) {
                CostCtrlDetailVO costCtrlDetailVO;
                BigDecimal feeTaxMny;
                if (null == allotOutDetailVO.getSubjectId() || "del".equals(allotOutDetailVO.getRowState())) continue;
                BigDecimal feeMny = allotOutDetailVO.getAllotDiffMny() == null ? BigDecimal.ZERO : allotOutDetailVO.getAllotDiffMny();
                BigDecimal bigDecimal = feeTaxMny = allotOutDetailVO.getAllotDiffTaxMny() == null ? BigDecimal.ZERO : allotOutDetailVO.getAllotDiffTaxMny();
                if (map.containsKey(allotOutDetailVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(allotOutDetailVO.getSubjectId());
                    BigDecimal mny = costCtrlDetailVO.getMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getMny();
                    BigDecimal taxMny = costCtrlDetailVO.getTaxMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getTaxMny();
                    costCtrlDetailVO.setMny(mny.add(feeMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(feeTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(allotOutDetailVO.getSubjectId());
                costCtrlDetailVO.setMny(feeMny);
                costCtrlDetailVO.setTaxMny(feeTaxMny);
                map.put(costCtrlDetailVO.getSubjectId(), costCtrlDetailVO);
            }
            if (null != map && map.size() > 0) {
                CostCtrlVO ctrlVO = new CostCtrlVO();
                if (null != vo.getId()) {
                    ctrlVO.setSourceId(vo.getId());
                }
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList(map.values()));
                return ctrlVO;
            }
            return null;
        }
        return null;
    }
}

