/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.zdsstore.bean.CheckDetailEntity;
import com.ejianc.business.zdsstore.bean.CheckEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.consts.ZDSStoreBillBypeEnums;
import com.ejianc.business.zdsstore.controller.FlowController;
import com.ejianc.business.zdsstore.mapper.CheckDetailMapper;
import com.ejianc.business.zdsstore.mapper.CheckMapper;
import com.ejianc.business.zdsstore.service.ICheckService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.business.zdsstore.utils.CommonUtils;
import com.ejianc.business.zdsstore.vo.CheckDetailVO;
import com.ejianc.business.zdsstore.vo.CheckVO;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdsstore.vo.UseMaterialPriceVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private CheckDetailMapper checkDetailMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private CheckMapper checkMapper;
    private static final String BILL_CODE = "STORE_CHECK_CODE";
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private FlowController flowHandle;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICheckService service;

    @Override
    public CommonResponse saveCheckStore(CheckEntity entity) {
        Long projectId = entity.getProjectId();
        Long storeId = entity.getStoreId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.eq((Object)"store_id", (Object)storeId);
        wrapper.eq((Object)"bill_state", (Object)StoreCommonConsts.ZERO);
        List list = super.list((Wrapper)wrapper);
        Integer checkCount = list.size();
        if (null == entity.getId() ? checkCount > 0 : checkCount > 1) {
            return CommonResponse.error((String)"\u8be5\u4ed3\u5e93\u5df2\u4e0b\u5b58\u5728\u81ea\u7531\u6001\u76d8\u70b9\u5355\uff01");
        }
        if (null != entity.getId()) {
            Map<String, CheckDetailEntity> currentDetailMap = entity.getCheckSubList().stream().filter(item -> !"del".equals(item.getRowState()) && item.getInventory().compareTo(BigDecimal.ZERO) < 0).collect(Collectors.toMap(item -> item.getMaterialId() + "-" + item.getBrandId(), item -> item));
            CheckEntity dbEntity = (CheckEntity)((Object)super.selectById((Serializable)entity.getId()));
            HashSet updateStoreList = new HashSet();
            dbEntity.getCheckSubList().stream().filter(item -> item.getInventory().compareTo(BigDecimal.ZERO) < 0).forEach(dbDetail -> {
                if (!currentDetailMap.containsKey(dbDetail.getMaterialId() + "-" + dbDetail.getBrandId())) {
                    updateStoreList.add(dbDetail);
                }
            });
            if (updateStoreList.size() > 0) {
                this.checkRollback(Arrays.asList(entity.getId()));
            }
            this.checkDetailMapper.delByCheckId(entity.getId());
        }
        super.saveOrUpdate((Object)entity, false);
        List<CheckDetailEntity> checkSubList = entity.getCheckSubList();
        ArrayList subList = new ArrayList();
        checkSubList.forEach(item -> {
            if (item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) < 0 && item.getStoreMaterialFlag() == 1) {
                subList.add(item);
            }
        });
        HashMap checkMap = new HashMap();
        String materialIds = "[";
        for (CheckDetailEntity item2 : subList) {
            materialIds = materialIds + item2.getMaterialId() + ",";
        }
        materialIds = materialIds.substring(0, materialIds.length() - 1) + "]";
        String condition = "{projectId:" + entity.getProjectId() + ",storeId:" + entity.getStoreId() + ",materialIds:" + materialIds + "}";
        if (subList.size() > 0) {
            CommonResponse<IPage<FlowVO>> iPageCommonResponse = this.flowHandle.refInstoreFlowData(1, 1000, condition, "", "");
            if (!iPageCommonResponse.isSuccess() || null == iPageCommonResponse.getData()) {
                return CommonResponse.error((String)"\u83b7\u53d6\u6700\u65b0\u6570\u91cf\u5931\u8d25\uff01");
            }
            List records = ((IPage)iPageCommonResponse.getData()).getRecords();
            records.forEach(item -> checkMap.put(item.getMaterialId(), item));
            for (CheckDetailEntity item3 : subList) {
                FlowVO flowVO = (FlowVO)checkMap.get(item3.getMaterialId());
                if (null == flowVO) {
                    return CommonResponse.error((String)("\u3010" + item3.getMaterialName() + "_" + item3.getSpec() + "\u3011\u5e93\u5b58\u53ef\u7528\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u5f62\u6210\u76d8\u4e8f\u51fa\u5e93\u5355\uff1b  \u4e0d\u53ef\u4fdd\u5b58"));
                }
                if (item3.getInventory().add(flowVO.getSurplusNum()).compareTo(BigDecimal.ZERO) >= 0) continue;
                return CommonResponse.error((String)("\u3010" + item3.getMaterialName() + "_" + item3.getSpec() + "\u3011\u5e93\u5b58\u53ef\u7528\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u5f62\u6210\u76d8\u4e8f\u51fa\u5e93\u5355\uff1b  \u4e0d\u53ef\u4fdd\u5b58"));
            }
        }
        if (subList.size() > 0) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76d8\u4e8f\u51fa\u5e93);
            ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
            subList.forEach(item -> {
                if (item.getInventory() == null) {
                    item.setInventory(BigDecimal.ZERO);
                }
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u76d8\u4e8f\u51fa\u5e93, (Integer)0);
                flowVO.setSourceBillTypeName("\u76d8\u70b9\u51fa\u5e93");
                flowVO.setSourceBillTypeCode(ZDSStoreBillBypeEnums.\u4ed3\u5e93\u76d8\u70b9.getCode());
                flowVO.setSourceType(StoreCommonConsts.ZERO);
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(item.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(item.getMaterialCategoryName());
                flowVO.setMaterialId(item.getMaterialId());
                flowVO.setMaterialName(item.getMaterialName());
                flowVO.setMaterialSpec(item.getSpec());
                flowVO.setNum(BigDecimal.ZERO.subtract(item.getInventory()));
                if (null != item.getPrice()) {
                    flowVO.setTaxPrice(item.getPrice());
                    flowVO.setTaxMny(item.getPrice().multiply(flowVO.getNum()));
                }
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(item.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getCheckDate());
                flowVO.setBrandId(item.getBrandId());
                flowVO.setBrandName(item.getBrandName());
                flowVO.setProductCode(item.getProductCode());
                flowVOS.add(flowVO);
            });
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> commonResponse = this.storeManageService.surplusMaterialPrice(storeManageVO);
            if (!commonResponse.isSuccess()) {
                return commonResponse;
            }
            List useMaterialPriceVOList = new ArrayList();
            if (null != commonResponse.getData()) {
                useMaterialPriceVOList = ((StoreManageVO)commonResponse.getData()).getUseMaterialPriceVOList();
            }
            Map<Long, UseMaterialPriceVO> priceMap = useMaterialPriceVOList.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k));
            if (null != entity.getId()) {
                this.checkDetailMapper.delByCheckId(entity.getId());
            }
            BigDecimal costMny = BigDecimal.ZERO;
            BigDecimal costTaxMny = BigDecimal.ZERO;
            entity.getCheckSubList().forEach(item -> {
                if (null != priceMap.get(item.getMaterialId())) {
                    item.setPrice(ComputeUtil.scaleTwo((BigDecimal)((UseMaterialPriceVO)priceMap.get(item.getMaterialId())).getPrice()));
                    item.setTaxPrice(ComputeUtil.scaleTwo((BigDecimal)((UseMaterialPriceVO)priceMap.get(item.getMaterialId())).getTaxPrice()));
                    BigDecimal taxMny = ComputeUtil.scaleTwo((BigDecimal)BigDecimal.ZERO.subtract(((UseMaterialPriceVO)priceMap.get(item.getMaterialId())).getTaxMny()));
                    BigDecimal mny = ComputeUtil.scaleTwo((BigDecimal)BigDecimal.ZERO.subtract(((UseMaterialPriceVO)priceMap.get(item.getMaterialId())).getMny()));
                    item.setCostTaxMny(BigDecimal.ZERO.subtract(taxMny));
                    item.setCostMny(BigDecimal.ZERO.subtract(mny));
                }
            });
            for (CheckDetailEntity item4 : entity.getCheckSubList()) {
                if (item4.getCostMny() != null) {
                    costMny = costMny.add(item4.getCostMny());
                }
                if (item4.getCostTaxMny() == null) continue;
                costTaxMny = costTaxMny.add(item4.getCostTaxMny());
            }
            entity.setCostMny(costMny);
            entity.setCostTaxMny(costTaxMny);
            super.saveOrUpdate((Object)entity, false);
            checkSubList = entity.getCheckSubList();
            subList.clear();
            checkSubList.forEach(item -> {
                if (item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) < 0) {
                    subList.add(item);
                }
            });
            flowVOS.forEach(item -> {
                item.setTaxPrice(((UseMaterialPriceVO)priceMap.get(item.getMaterialId())).getTaxPrice());
                item.setTaxMny(((UseMaterialPriceVO)priceMap.get(item.getMaterialId())).getTaxMny());
            });
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> storeManageVOCommonResponse = this.storeManageService.inOutStore(storeManageVO);
            if (!storeManageVOCommonResponse.isSuccess()) {
                return storeManageVOCommonResponse;
            }
        }
        return CommonResponse.success((Object)((Object)entity));
    }

    @Override
    public CommonResponse myRemoveByIds(List<Long> ids) {
        CommonResponse commonResponse = this.checkRollback(ids);
        if (!commonResponse.isSuccess()) {
            return commonResponse;
        }
        super.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse checkRollback(List<Long> ids) {
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        for (Long item : ids) {
            CheckEntity entity = (CheckEntity)((Object)super.selectById((Serializable)item));
            List<CheckDetailEntity> checkSubList = entity.getCheckSubList();
            Boolean checkFalg = false;
            for (CheckDetailEntity t : checkSubList) {
                if (t.getInventory().compareTo(BigDecimal.ZERO) >= 0) continue;
                checkFalg = true;
                break;
            }
            if (!checkFalg.booleanValue()) continue;
            SourceIds.clear();
            SourceIds.add(item);
            storeManageVO.setSourceId(item);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76d8\u4e8f\u51fa\u5e93);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            CommonResponse<StoreManageVO> rollbackCommonResponse = this.storeManageService.inOutStoreRollback(storeManageVO);
            if (rollbackCommonResponse.isSuccess()) continue;
            return rollbackCommonResponse;
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse checkOut(List<Long> ids) {
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        for (Long item : ids) {
            CheckEntity entity = (CheckEntity)((Object)super.selectById((Serializable)item));
            SourceIds.clear();
            SourceIds.add(item);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76d8\u4e8f\u51fa\u5e93);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setSourceId(item);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            CommonResponse<StoreManageVO> rollbackCommonResponse = this.storeManageService.inOutStore(storeManageVO);
            if (rollbackCommonResponse.isSuccess()) continue;
            return rollbackCommonResponse;
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse checkByDate(Long storeId, String checkDate) {
        List<CheckEntity> checkEntities = this.checkMapper.queryByDate(storeId, checkDate);
        if (checkEntities.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u65f6\u95f4\u70b9\u540e\u5df2\u53d1\u751f\u4ed3\u5e93\u76d8\u70b9\u5355");
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<CheckVO> pushCost(CheckVO checkVO) {
        CheckEntity checkEntity = (CheckEntity)((Object)((CheckMapper)this.baseMapper).selectById(checkVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)checkVO.getCheckSubList())) {
            List checkDetailEntities = BeanMapper.mapList((Iterable)checkVO.getCheckSubList(), CheckDetailEntity.class);
            checkEntity.setCheckSubList(checkDetailEntities);
        }
        super.saveOrUpdate((Object)checkEntity, false);
        this.costPush(checkEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)checkEntity), CheckVO.class));
    }

    @Override
    public void costPush(CheckEntity checkEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<CheckDetailEntity> checkDetailEntities = checkEntity.getCheckSubList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(checkDetailEntities)) {
            for (CheckDetailEntity entity : checkDetailEntities) {
                if (null != entity.getSubjectId() && null != entity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(checkDetailEntities)) {
            newRelationFlag = "0";
        }
        this.saveCost(checkEntity, 1);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{checkEntity.getId()});
        updateWrapper.set(CheckEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public CheckVO saveOrUpdate(CheckVO saveOrUpdateVO) {
        CommonResponse commonResponse;
        CheckEntity entity = (CheckEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CheckEntity.class));
        if (!ListUtil.isEmpty((List)saveOrUpdateVO.getCheckSubList())) {
            entity.setCheckSubList(BeanMapper.mapList((Iterable)saveOrUpdateVO.getCheckSubList(), CheckDetailEntity.class));
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.setProportionFlag("0");
                entity.setRelationFlag("0");
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (!(commonResponse = this.service.saveCheckStore(entity)).isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
        CheckVO vo = (CheckVO)BeanMapper.map((Object)commonResponse.getData(), CheckVO.class);
        return vo;
    }

    private void saveCost(CheckEntity checkEntity, Integer effectiveStatus) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<CheckDetailEntity> checkSubList = checkEntity.getCheckSubList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(checkSubList)) {
            List materialIds = checkSubList.stream().map(CheckDetailEntity::getMaterialId).collect(Collectors.toList());
            CommonResponse listCommonResponse = this.shareMaterialApi.queryMaterialByIds(materialIds);
            List voList = new ArrayList();
            if (listCommonResponse.isSuccess()) {
                voList = (List)listCommonResponse.getData();
            }
            HashMap materialMap = new HashMap();
            voList.forEach(item -> materialMap.put(item.getId(), item.getCode()));
            for (CheckDetailEntity entity : checkSubList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(entity.getSubjectId());
                costDetailVO.setSubjectCode(entity.getSubjectCode());
                costDetailVO.setSubjectName(entity.getSubjectName());
                costDetailVO.setWbsId(entity.getWbsId());
                costDetailVO.setWbsCode(entity.getWbsCode());
                costDetailVO.setWbsName(entity.getWbsName());
                costDetailVO.setSourceId(entity.getCheckId());
                costDetailVO.setSourceDetailId(entity.getId());
                costDetailVO.setHappenTaxMny(entity.getCostTaxMny());
                costDetailVO.setHappenMny(entity.getCostMny());
                costDetailVO.setHappenDate(checkEntity.getCheckDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("STORE_CHECK");
                costDetailVO.setSourceTabType("STORE_CHECK_SUB");
                costDetailVO.setSourceBillCode(checkEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u4ed3\u5e93\u76d8\u70b9.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-zdsstore-frontend/#/storeCheck/card?id=" + checkEntity.getId());
                costDetailVO.setProjectId(checkEntity.getProjectId());
                costDetailVO.setMaterialId(entity.getMaterialId());
                costDetailVO.setMaterialName(entity.getMaterialName());
                costDetailVO.setMaterialTypeId(entity.getMaterialCategoryId());
                costDetailVO.setMaterialTypeName(entity.getMaterialCategoryName());
                costDetailVO.setMaterialCode((String)materialMap.get(entity.getMaterialId()));
                costDetailVO.setUnitId(entity.getUnit());
                costDetailVO.setUnit(entity.getUnitName());
                costDetailVO.setSpec(entity.getSpec());
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public ParamsCheckVO checkParams(CheckVO checkVO) {
        CommonResponse costResponse;
        ParamsCheckVO costRes;
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        CostCtrlVO costCtrlVO = this.sjCost(checkVO);
        if (null != costCtrlVO && null != (costRes = (ParamsCheckVO)(costResponse = this.executionApi.ctrlCost(costCtrlVO)).getData())) {
            paramsCheckVOS.add(costRes);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO paramsCheckVO1 : paramsCheckVOS) {
                String warnType = paramsCheckVO1.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(paramsCheckVO1.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, paramsCheckVO1.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    public CostCtrlVO sjCost(CheckVO vo) {
        List checkSubList = vo.getCheckSubList();
        if (CollectionUtils.isNotEmpty((Collection)checkSubList)) {
            HashMap<Long, CostCtrlDetailVO> map = new HashMap<Long, CostCtrlDetailVO>();
            for (CheckDetailVO pickReturnDetailVO : checkSubList) {
                CostCtrlDetailVO costCtrlDetailVO;
                if (null == pickReturnDetailVO.getSubjectId() || "del".equals(pickReturnDetailVO.getRowState())) continue;
                BigDecimal detailMny = CommonUtils.setBigDecimalDefaultValue(pickReturnDetailVO.getCostMny());
                BigDecimal detailTaxMny = CommonUtils.setBigDecimalDefaultValue(pickReturnDetailVO.getCostTaxMny());
                if (map.containsKey(pickReturnDetailVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(pickReturnDetailVO.getSubjectId());
                    BigDecimal mny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getMny());
                    BigDecimal taxMny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getTaxMny());
                    costCtrlDetailVO.setMny(mny.add(detailMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(detailTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(pickReturnDetailVO.getSubjectId());
                costCtrlDetailVO.setMny(detailMny);
                costCtrlDetailVO.setTaxMny(detailTaxMny);
                map.put(pickReturnDetailVO.getSubjectId(), costCtrlDetailVO);
            }
            if (null != map && !map.isEmpty()) {
                CostCtrlVO ctrlVO = new CostCtrlVO();
                if (null != vo.getId()) {
                    ctrlVO.setSourceId(vo.getId());
                }
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList(map.values()));
                return ctrlVO;
            }
            return null;
        }
        return null;
    }
}

