/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsstore.bean.FlowEntity;
import com.ejianc.business.zdsstore.consts.StoreAttrEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.service.IFlowService;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.StoreApiVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"flow"})
@Api(value="\u4ed3\u5e93\u6d41\u6c34\u8868", tags={"\u4ed3\u5e93\u6d41\u6c34\u8868"})
public class FlowController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "STORE_FLOW_CODE";
    @Autowired
    private IFlowService service;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FlowVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody FlowVO saveOrUpdateVO) {
        FlowEntity entity = (FlowEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, FlowEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)entity), FlowVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FlowVO> queryDetail(@RequestParam Long id) {
        FlowEntity entity = (FlowEntity)((Object)this.service.selectById(id));
        FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)entity), FlowVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FlowVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FlowVO flowVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FlowVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FlowVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Flow-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167\u5165\u5e93(\u6750\u6599\u5408\u5e76)")
    @RequestMapping(value={"/refInstoreFlowData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FlowVO>> refInstoreFlowData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"projectId")) {
                param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
            }
            if (_con.containsKey((Object)"contractId")) {
                param.getParams().put("purchaseContractId", new Parameter("eq", _con.get((Object)"contractId")));
            }
            if (_con.containsKey((Object)"storeId")) {
                param.getParams().put("storeId", new Parameter("eq", _con.get((Object)"storeId")));
            }
            if (_con.containsKey((Object)"sourceBillDate")) {
                param.getParams().put("sourceBillDate", new Parameter("le", _con.get((Object)"sourceBillDate")));
            }
            if (_con.containsKey((Object)"materialIds")) {
                param.getParams().put("materialId", new Parameter("in", _con.get((Object)"materialIds")));
            }
            if (_con.containsKey((Object)"brandIds")) {
                param.getParams().put("brandId", new Parameter("in", _con.get((Object)"brandIds")));
            }
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<FlowVO> list = this.service.queryInstoreFlowData((IPage<FlowVO>)page, wrapper);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        list.forEach(item -> {
            item.getSurplusNum().setScale(4, 0);
            item.getNum().setScale(4, 0);
        });
        pageData.setRecords(BeanMapper.mapList(list, FlowVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u83b7\u53d6\u5728\u5e93\u7269\u8d44(\u6750\u6599\u5408\u5e76)")
    @GetMapping(value={"/getInStoreFlowData"})
    @ResponseBody
    public CommonResponse<IPage<FlowVO>> getInStoreFlowData(String condition) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList materialVos = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"projectId")) {
                param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
            }
            if (_con.containsKey((Object)"orgId")) {
                param.getParams().put("orgId", new Parameter("eq", _con.get((Object)"orgId")));
            }
            if (_con.containsKey((Object)"contractId")) {
                param.getParams().put("purchaseContractId", new Parameter("eq", _con.get((Object)"contractId")));
            }
            if (_con.containsKey((Object)"storeId")) {
                param.getParams().put("storeId", new Parameter("eq", _con.get((Object)"storeId")));
            }
            if (_con.containsKey((Object)"sourceBillDate")) {
                param.getParams().put("sourceBillDate", new Parameter("le", _con.get((Object)"sourceBillDate")));
            }
            if (null != _con && _con.containsKey((Object)"materials")) {
                materialVos.addAll(JSONObject.parseArray((String)_con.getString("materials"), FlowVO.class));
            }
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.and(q -> {
            for (FlowVO f : materialVos) {
                q.or(iq -> (QueryWrapper)((QueryWrapper)iq.eq((Object)"material_id", (Object)f.getMaterialId())).eq((Object)"brand_id", (Object)f.getBrandId()));
            }
            return q;
        });
        List<FlowVO> list = this.service.queryInstoreFlowData((IPage<FlowVO>)page, wrapper);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        list.forEach(item -> {
            item.getSurplusNum().setScale(4, 0);
            item.getNum().setScale(4, 0);
        });
        pageData.setRecords(BeanMapper.mapList(list, FlowVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refFlowData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FlowVO>> refFlowData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FlowVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bf9\u8d26/\u7ed3\u7b97\u5165\u5e93\u6750\u6599\u53c2\u7167")
    @RequestMapping(value={"/refAccountSettleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<StoreApiVO>> refAccountSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"projectId")) {
                wrapper.eq((Object)"project_id", _con.get((Object)"projectId"));
            }
            if (_con.containsKey((Object)"contractId")) {
                wrapper.and(changeWrapper -> (QueryWrapper)((QueryWrapper)((QueryWrapper)changeWrapper.eq((Object)"purchase_contract_id", _con.get((Object)"contractId"))).or()).isNull((Object)"purchase_contract_id"));
            } else {
                wrapper.isNull((Object)"purchase_contract_id");
            }
            if (_con.containsKey((Object)"supplierId")) {
                wrapper.eq((Object)"supplier_id", _con.get((Object)"supplierId"));
            }
            if (_con.containsKey((Object)"accountFlag")) {
                wrapper.eq((Object)"account_flag", _con.get((Object)"accountFlag"));
                queryWrapper.eq((Object)"account_flag", _con.get((Object)"accountFlag"));
            }
            if (_con.containsKey((Object)"settleFlag")) {
                wrapper.eq((Object)"settle_flag", _con.get((Object)"settleFlag"));
                queryWrapper.eq((Object)"settle_flag", _con.get((Object)"settleFlag"));
            }
            if (_con.containsKey((Object)"turnFlag")) {
                wrapper.eq((Object)"turn_flag", _con.get((Object)"turnFlag"));
            } else {
                wrapper.ne((Object)"store_type", (Object)StoreAttrEnum.\u7532\u4f9b\u6750.getCode());
            }
            if (_con.containsKey((Object)"effectiveDate")) {
                wrapper.le((Object)"DATE_FORMAT(source_bill_date,\"%Y-%m-%d\")", _con.get((Object)"effectiveDate"));
            }
        }
        List<StoreApiVO> list = this.service.queryStoreInstoreData((Page<StoreApiVO>)page, wrapper);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List storeInstoreVOS = BeanMapper.mapList(list, StoreApiVO.class);
        if (CollectionUtils.isNotEmpty((Collection)storeInstoreVOS)) {
            List sourceIds = storeInstoreVOS.stream().map(StoreApiVO::getSourceId).collect(Collectors.toList());
            queryWrapper.in((Object)"source_id", sourceIds);
            queryWrapper.eq((Object)"in_out_flag", (Object)StoreCommonConsts.IN_OUT_TYPE_IN);
            List flowEntities = this.service.list((Wrapper)queryWrapper);
            List flowVOS = BeanMapper.mapList((Iterable)flowEntities, FlowVO.class);
            Map<Long, List<FlowVO>> flowMap = flowVOS.stream().collect(Collectors.groupingBy(FlowVO::getSourceId));
            storeInstoreVOS.forEach(t -> t.setDetail((List)flowMap.get(t.getSourceId())));
        }
        pageData.setRecords(storeInstoreVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5468\u8f6c\u6750\u5165\u5e93\u53c2\u7167")
    @RequestMapping(value={"/refTurnInstoreFlowData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FlowVO>> refTurnInstoreFlowData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"projectId")) {
                param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
            }
            if (_con.containsKey((Object)"contractId")) {
                param.getParams().put("purchaseContractId", new Parameter("eq", _con.get((Object)"contractId")));
            }
            if (_con.containsKey((Object)"storeId")) {
                param.getParams().put("storeId", new Parameter("eq", _con.get((Object)"storeId")));
            }
            if (_con.containsKey((Object)"sourceBillDate")) {
                param.getParams().put("sourceBillDate", new Parameter("le", _con.get((Object)"sourceBillDate")));
            }
            if (_con.containsKey((Object)"materialIds")) {
                param.getParams().put("materialId", new Parameter("in", _con.get((Object)"materialIds")));
            }
            if (_con.containsKey((Object)"brandIds")) {
                param.getParams().put("brandId", new Parameter("in", _con.get((Object)"brandIds")));
            }
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<FlowVO> list = this.service.queryTurnInstoreFlowData((Page<FlowVO>)page, wrapper);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        list.forEach(item -> {
            item.getSurplusNum().setScale(4, 0);
            item.getNum().setScale(4, 0);
        });
        pageData.setRecords(BeanMapper.mapList(list, FlowVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

