/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsstore.bean.IdleFlowEntity;
import com.ejianc.business.zdsstore.bean.SurplusEntity;
import com.ejianc.business.zdsstore.mapper.IdleFlowMapper;
import com.ejianc.business.zdsstore.service.IIdleFlowService;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.vo.IdleFlowVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="idleFlowService")
public class IdleFlowServiceImpl
extends BaseServiceImpl<IdleFlowMapper, IdleFlowEntity>
implements IIdleFlowService {
    @Autowired
    private ISurplusService surplusService;

    @Override
    public CommonResponse<String> inOutStore(List<IdleFlowVO> flowVOS) {
        List flowEntities = BeanMapper.mapList(flowVOS, IdleFlowEntity.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.and(q -> {
            for (IdleFlowEntity f : flowEntities) {
                q.or(iq -> (QueryWrapper)((QueryWrapper)((QueryWrapper)iq.eq((Object)"store_id", (Object)f.getStoreId())).eq((Object)"brand_id", (Object)f.getBrandId())).eq((Object)"material_id", (Object)f.getMaterialId()));
            }
            return q;
        });
        ArrayList list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            list = new ArrayList();
        }
        list.addAll(flowEntities);
        Map<String, BigDecimal> resultMap = list.stream().collect(Collectors.groupingBy(x -> x.getStoreId() + "@" + x.getMaterialId() + "@" + x.getBrandId(), Collectors.reducing(BigDecimal.ZERO, IdleFlowEntity::getNum, BigDecimal::add)));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.and(q -> {
            for (IdleFlowEntity f : flowEntities) {
                q.or(iq -> (QueryWrapper)((QueryWrapper)((QueryWrapper)iq.eq((Object)"store_id", (Object)f.getStoreId())).eq((Object)"brand_id", (Object)f.getBrandId())).eq((Object)"material_id", (Object)f.getMaterialId()));
            }
            return q;
        });
        List surplusEntities = this.surplusService.list((Wrapper)wrapper);
        ArrayList<SurplusEntity> updateList = new ArrayList<SurplusEntity>();
        for (SurplusEntity surplusEntity : surplusEntities) {
            String key = surplusEntity.getStoreId() + "@" + surplusEntity.getMaterialId() + "@" + surplusEntity.getBrandId();
            if (!resultMap.containsKey(key) || ComputeUtil.isLessThan((BigDecimal)surplusEntity.getSurplusNum(), (BigDecimal)resultMap.get(key))) {
                return CommonResponse.error((String)("\u7269\u8d44[\u540d\u79f0\uff1a" + surplusEntity.getMaterialName() + "\uff0c\u89c4\u683c\uff1a" + StrUtil.emptyToDefault((CharSequence)surplusEntity.getMaterialSpec(), (String)"\u65e0") + "\uff0c\u54c1\u724c\uff1a" + StrUtil.emptyToDefault((CharSequence)surplusEntity.getBrandName(), (String)"\u65e0") + "]\uff0c\u5e93\u5b58\u4f59\u91cf\uff1a" + ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeSub((BigDecimal)surplusEntity.getSurplusNum(), (BigDecimal)surplusEntity.getIdleNum())) + "\uff0c\u5e93\u5b58\u4e0d\u8db3!"));
            }
            surplusEntity.setIdleNum(resultMap.get(key));
            updateList.add(surplusEntity);
        }
        boolean b = this.saveOrUpdateBatch(flowEntities);
        if (b && CollectionUtils.isNotEmpty(updateList)) {
            this.surplusService.saveOrUpdateBatch(updateList);
        }
        return CommonResponse.success((String)"\u63a8\u9001\u76d8\u6d3b\u95f2\u7f6e\u6d41\u6c34\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> inOutStoreRollback(Long sourceId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        List dblist = this.list((Wrapper)queryWrapper);
        if (this.remove((Wrapper)queryWrapper)) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.and(q -> {
                for (IdleFlowEntity f : dblist) {
                    q.or(iq -> (QueryWrapper)((QueryWrapper)((QueryWrapper)iq.eq((Object)"store_id", (Object)f.getStoreId())).eq((Object)"brand_id", (Object)f.getBrandId())).eq((Object)"material_id", (Object)f.getMaterialId()));
                }
                return q;
            });
            List list = this.list((Wrapper)wrapper);
            HashMap resultMap = CollectionUtils.isNotEmpty((Collection)list) ? list.stream().collect(Collectors.groupingBy(x -> x.getStoreId() + "@" + x.getMaterialId() + "@" + x.getBrandId(), Collectors.reducing(BigDecimal.ZERO, IdleFlowEntity::getNum, BigDecimal::add))) : new HashMap();
            QueryWrapper query = new QueryWrapper();
            query.and(q -> {
                for (IdleFlowEntity f : dblist) {
                    q.or(iq -> (QueryWrapper)((QueryWrapper)((QueryWrapper)iq.eq((Object)"store_id", (Object)f.getStoreId())).eq((Object)"brand_id", (Object)f.getBrandId())).eq((Object)"material_id", (Object)f.getMaterialId()));
                }
                return q;
            });
            List surplusEntities = this.surplusService.list((Wrapper)query);
            ArrayList<SurplusEntity> updateList = new ArrayList<SurplusEntity>();
            Iterator iterator = surplusEntities.iterator();
            while (iterator.hasNext()) {
                SurplusEntity surplusEntity;
                String key = (surplusEntity = (SurplusEntity)((Object)iterator.next())).getStoreId() + "@" + surplusEntity.getMaterialId() + "@" + surplusEntity.getBrandId();
                surplusEntity.setIdleNum(resultMap.containsKey(key) ? (BigDecimal)resultMap.get(key) : BigDecimal.ZERO);
                updateList.add(surplusEntity);
            }
            if (CollectionUtils.isNotEmpty(updateList)) {
                this.surplusService.saveOrUpdateBatch(updateList);
            }
        }
        return CommonResponse.success((String)"\u5220\u9664\u76d8\u6d3b\u95f2\u7f6e\u6d41\u6c34\u6210\u529f\uff01");
    }
}

