package com.ejianc.business.zdsstore.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsstore.bean.FlowEntity;
import com.ejianc.business.zdsstore.bean.InOutEntity;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.service.IFlowService;
import com.ejianc.business.zdsstore.service.IInOutService;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.InOutVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/storeFlow/")
@Api(value = "仓库流水公共API接口", tags = {"仓库流水公共API接口"})
public class StoreFlowApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IFlowService flowService;
    @Autowired
    private IInOutService inOutService;

    /**
     * @param queryParam 参数
     * @description: 查询流水
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2022/1/18
     */
    @ApiOperation("查询流水")
    @RequestMapping(value = "/getFlowList", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<List<FlowVO>> getFlowList(@RequestBody QueryParam queryParam) {
        List<FlowEntity> flowEntityList = flowService.queryList(queryParam);
        List<FlowVO> flowVOS = BeanMapper.mapList(flowEntityList, FlowVO.class);
        return CommonResponse.success(flowVOS);
    }

    /**
     * @param queryParam
     * @description: 查询出入库关系
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.store.vo.InOutVO>
     * @author 姜轶凯
     * @date: 2022/3/15
     */
    @RequestMapping(value = "/getInOutVOList", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<List<InOutVO>> getInOutVOList(@RequestBody QueryParam queryParam){
        List<InOutEntity> inOutEntities = inOutService.queryList(queryParam);
        List<InOutVO> inOutVOS = BeanMapper.mapList(inOutEntities, InOutVO.class);
        return CommonResponse.success(inOutVOS);
    }

    @RequestMapping(value = "/getNewPrice", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<List<FlowVO>> getNewPrice(@RequestBody List<FlowVO> flowVOS){
        List<FlowVO> result = new ArrayList<>();
        for (FlowVO flowVO : flowVOS) {
            QueryWrapper<FlowEntity> wrapper = new QueryWrapper();
            wrapper.eq("store_id", flowVO.getStoreId());
            wrapper.eq("material_id", flowVO.getMaterialId());
            wrapper.eq("brand_id", flowVO.getBrandId());
            wrapper.eq("in_out_flag", StoreCommonConsts.IN_OUT_TYPE_IN);
            wrapper.orderByDesc( "source_bill_date");
            wrapper.last("limit 0,1");
            List<FlowEntity> flowEntities = flowService.list(wrapper);
            if (CollectionUtils.isNotEmpty(flowEntities)) {
                result.add(BeanMapper.map(flowEntities.get(0), FlowVO.class));
            }
        }
        return CommonResponse.success("查询最新单价成功！", result);
    }
}
