/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.handler;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsstore.bean.FlowEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.service.IFlowService;
import com.ejianc.business.zdsstore.service.IStoreService;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.service.handler.IStoreManageHandler;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdsstore.vo.SurplusUpdateVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InStoreHandler
implements IStoreManageHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IFlowService flowService;
    @Autowired
    ISurplusService surplusService;
    @Autowired
    IStoreService storeService;

    @Override
    public CommonResponse<StoreManageVO> handle(StoreManageVO storeManageVO) {
        storeManageVO = this.storeService.setStoreAttr(storeManageVO);
        Long storeId = storeManageVO.getStoreId();
        Long sourceId = storeManageVO.getSourceId();
        if (sourceId != null) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"source_id", (Object)sourceId);
            queryWrapper.ne((Object)"in_out_type", (Object)InOutTypeEnum.\u76d8\u4e8f\u51fa\u5e93.getInOutType());
            int count = this.flowService.count((Wrapper)queryWrapper);
            if (count > 0) {
                InOutTypeEnum inOutTypeEnum = storeManageVO.getInOutTypeEnum();
                String billTypeName = inOutTypeEnum != null ? inOutTypeEnum.getInOutTypeName() : "\u65e0";
                this.logger.error("---start---------\u91cd\u590d\u6821\u9a8cERROR---------------------------------");
                this.logger.error("\u4ed3\u5e93\u5165\u5e93\u6d41\u6c34\u91cd\u590d\u6821\u9a8c\uff1a\u5df2\u5b58\u5728\u8be5\u5355\u636e\u5165\u5e93\u6d41\u6c34\uff01\u6765\u6e90\u5355\u636e\u7c7b\u578b\uff1a{}\uff0c\u5355\u636eID\uff1a{}", (Object)billTypeName, (Object)sourceId);
                this.logger.error("---end-----------\u91cd\u590d\u6821\u9a8cERROR---------------------------------");
                return CommonResponse.success((String)("\u4ed3\u5e93\u5165\u5e93\u6d41\u6c34\u91cd\u590d\u6821\u9a8c\uff1a\u5df2\u5b58\u5728\u8be5\u5355\u636e\u5165\u5e93\u6d41\u6c34\uff01\u6765\u6e90\u5355\u636eID\uff1a" + sourceId), (Object)storeManageVO);
            }
        }
        List flowVOList = storeManageVO.getFlowVOList();
        SurplusUpdateVO surplusUpdateVO = StoreManageUtil.getSurplusUpdateVO((Long)storeId, (List)flowVOList, (boolean)false);
        try {
            flowVOList.forEach(flowVO -> {
                flowVO.setOutNum(BigDecimal.ZERO);
                flowVO.setOutLockNum(BigDecimal.ZERO);
                flowVO.setSurplusNum(flowVO.getNum());
                flowVO.setSurplusMny(flowVO.getMny());
                flowVO.setSurplusTaxMny(flowVO.getTaxMny());
                flowVO.setEstimatePrice(flowVO.getPrice());
                flowVO.setEstimateTaxPrice(flowVO.getTaxPrice());
            });
            List flowEntities = BeanMapper.mapList((Iterable)flowVOList, FlowEntity.class);
            boolean b = this.flowService.saveOrUpdateBatch(flowEntities);
            if (b) {
                SurplusUpdateVO surplusUpdateVORet = this.surplusService.updateStoreSurplus(surplusUpdateVO, true, true);
                storeManageVO.setSurplusVOList(surplusUpdateVORet.getSurplusVOList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        return CommonResponse.success((Object)storeManageVO);
    }

    @Override
    public CommonResponse<StoreManageVO> handleRollback(StoreManageVO storeManageVO) {
        Long storeId = storeManageVO.getStoreId();
        Long sourceId = storeManageVO.getSourceId();
        CommonResponse<List<FlowEntity>> res = this.flowService.validateIsUse(sourceId, storeId);
        if (!res.isSuccess()) {
            return CommonResponse.error((String)res.getMsg());
        }
        List instoreList = (List)res.getData();
        List flowVOList = BeanMapper.mapList((Iterable)instoreList, FlowVO.class);
        SurplusUpdateVO surplusUpdateVO = StoreManageUtil.getSurplusUpdateVO((Long)storeId, (List)flowVOList, (boolean)true);
        try {
            SurplusUpdateVO surplusUpdateVORet = this.surplusService.updateStoreSurplus(surplusUpdateVO, true, true);
            storeManageVO.setSurplusVOList(surplusUpdateVORet.getSurplusVOList());
            List delListIds = flowVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
            this.flowService.removeByIds(delListIds);
            return CommonResponse.success((Object)storeManageVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
    }
}

