/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.zdsstore.bean.AllotOutEntity;
import com.ejianc.business.zdsstore.consts.AllocatEnum;
import com.ejianc.business.zdsstore.consts.AllocationState;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.mapper.AllotOutMapper;
import com.ejianc.business.zdsstore.service.IAllotOutService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.AllotOutDetailVO;
import com.ejianc.business.zdsstore.vo.AllotOutExportVO;
import com.ejianc.business.zdsstore.vo.AllotOutVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdsstore.vo.UseMaterialPriceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="allotOutService")
public class AllotOutServiceImpl
extends BaseServiceImpl<AllotOutMapper, AllotOutEntity>
implements IAllotOutService {
    @Autowired
    StoreManageService storeManageService;
    @Autowired
    private IAllotOutService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "ALLOT_OUT";
    @Autowired
    private IOrgApi iOrgApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExecutionApi executionApi;

    @Override
    public CommonResponse<StoreManageVO> surplusMaterialPrice(AllotOutVO saveOrUpdateVO) {
        StoreManageVO storeManageVO = saveOrUpdateVO.getStoreManageVO(saveOrUpdateVO);
        CommonResponse<StoreManageVO> commonResponse = this.storeManageService.surplusMaterialPrice(storeManageVO);
        return commonResponse;
    }

    @Override
    public CommonResponse<List<StoreManageVO>> surplusListMaterialPrice(AllotOutVO saveOrUpdateVO) {
        ArrayList<Object> manageVOS = new ArrayList<Object>();
        List storeManageVO = saveOrUpdateVO.getStoreManageVOList(saveOrUpdateVO);
        for (StoreManageVO storeManageVO1 : storeManageVO) {
            CommonResponse<StoreManageVO> commonResponse = this.storeManageService.surplusMaterialPrice(storeManageVO1);
            manageVOS.add(commonResponse.getData());
        }
        return CommonResponse.success(manageVOS);
    }

    @Override
    public CommonResponse<AllotOutVO> allotOutSaveOrUpdate(AllotOutVO saveOrUpdateVO) {
        boolean b;
        AllotOutEntity entity;
        CommonResponse<List<StoreManageVO>> listCommonResponse;
        List data1;
        if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getAllotOutDetailList()) && (data1 = (List)(listCommonResponse = this.service.surplusListMaterialPrice(saveOrUpdateVO)).getData()) != null) {
            for (StoreManageVO data : data1) {
                List useMaterialPriceVOList;
                if (data == null || !CollectionUtils.isNotEmpty((Collection)(useMaterialPriceVOList = data.getUseMaterialPriceVOList()))) continue;
                HashMap collect = new HashMap();
                for (UseMaterialPriceVO vo : useMaterialPriceVOList) {
                    if (collect.containsKey(vo.getMaterialId() + "@" + vo.getBrandId())) {
                        ((List)collect.get(vo.getMaterialId() + "@" + vo.getBrandId())).add(vo);
                        continue;
                    }
                    ArrayList<UseMaterialPriceVO> useMaterialPriceVOS = new ArrayList<UseMaterialPriceVO>();
                    useMaterialPriceVOS.add(vo);
                    collect.put(vo.getMaterialId() + "@" + vo.getBrandId(), useMaterialPriceVOS);
                }
                List allotOutDetailList = saveOrUpdateVO.getAllotOutDetailList();
                if (CollectionUtils.isNotEmpty((Collection)allotOutDetailList)) {
                    for (AllotOutDetailVO allotOutDetailEntity : allotOutDetailList) {
                        if (!collect.containsKey(allotOutDetailEntity.getMaterialId() + "@" + allotOutDetailEntity.getBrandId())) continue;
                        List useMaterialPriceVos = (List)collect.get(allotOutDetailEntity.getMaterialId() + "@" + allotOutDetailEntity.getBrandId());
                        UseMaterialPriceVO useMaterialPriceVO = (UseMaterialPriceVO)useMaterialPriceVos.get(0);
                        allotOutDetailEntity.setInStoreMny(ComputeUtil.scaleTwo((BigDecimal)useMaterialPriceVO.getMny()));
                        allotOutDetailEntity.setInStoreTaxMny(ComputeUtil.scaleTwo((BigDecimal)useMaterialPriceVO.getTaxMny()));
                        allotOutDetailEntity.setInStoreTax(useMaterialPriceVO.getTax());
                        if (useMaterialPriceVO.getTaxMny() != null && allotOutDetailEntity.getAllocatNum() != null) {
                            BigDecimal inStoreAveragePrice = ComputeUtil.safeDiv((BigDecimal)useMaterialPriceVO.getTaxMny(), (BigDecimal)allotOutDetailEntity.getAllocatNum());
                            allotOutDetailEntity.setInStoreAveragePrice(inStoreAveragePrice);
                        }
                        BigDecimal mny = ComputeUtil.scaleTwo((BigDecimal)useMaterialPriceVO.getMny());
                        BigDecimal taxMny = ComputeUtil.scaleTwo((BigDecimal)useMaterialPriceVO.getTaxMny());
                        if (!ComputeUtil.isNotEmpty((BigDecimal)taxMny).booleanValue() || !ComputeUtil.isNotEmpty((BigDecimal)mny).booleanValue()) continue;
                        BigDecimal bigDecimal = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)mny);
                        BigDecimal inStoreRate = ComputeUtil.safeSub((BigDecimal)bigDecimal, (BigDecimal)BigDecimal.ONE);
                        allotOutDetailEntity.setInStoreTaxRate(ComputeUtil.safeMultiply((BigDecimal)inStoreRate, (BigDecimal)new BigDecimal(100)));
                    }
                }
                saveOrUpdateVO.setAllotOutDetailList(allotOutDetailList);
            }
        }
        if ((entity = (AllotOutEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AllotOutEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.setProportionFlag("0");
                entity.setRelationFlag("0");
                entity.setReceiveState(Integer.parseInt(AllocationState.TO_RECEIVING.getCode()));
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if ((b = this.service.saveOrUpdate((Object)entity, false)) && CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getAllotOutDetailList())) {
            saveOrUpdateVO = (AllotOutVO)BeanMapper.map((Object)((Object)entity), AllotOutVO.class);
            saveOrUpdateVO.setId(entity.getId());
            saveOrUpdateVO.setBillCode(entity.getBillCode());
            List storeManageVOList = saveOrUpdateVO.getStoreManageVOList(saveOrUpdateVO);
            for (StoreManageVO manageVO : storeManageVOList) {
                this.storeManageService.inOutStore(manageVO);
            }
        }
        AllotOutVO vo = (AllotOutVO)BeanMapper.map((Object)((Object)entity), AllotOutVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u4fee\u6539\u6210\u529f", (Object)vo);
    }

    @Override
    public CommonResponse<String> allotOutDelete(List<AllotOutVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AllotOutVO vo : vos) {
                AllotOutEntity allotOutEntity = (AllotOutEntity)((Object)this.service.selectById(vo.getId()));
                if (!CollectionUtils.isNotEmpty(allotOutEntity.getAllotOutDetailList())) continue;
                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setStoreId(allotOutEntity.getStoreId());
                storeManageVO.setSourceId(allotOutEntity.getId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u8c03\u62e8\u51fa\u5e93);
                ArrayList<Long> longs = new ArrayList<Long>();
                longs.add(allotOutEntity.getId());
                storeManageVO.setSourceIdsForRollBack(longs);
                this.storeManageService.inOutStoreRollback(storeManageVO);
            }
        }
        boolean b = this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialNames");
        fuzzyFields.add("inProjectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("receiverPerson");
        fuzzyFields.add("billCode");
        fuzzyFields.add("companyName");
        fuzzyFields.add("inCompanyName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List allotOutVos = BeanMapper.mapList((Iterable)list, AllotOutExportVO.class);
        allotOutVos.forEach(vo -> {
            if (vo.getOutDate() != null) {
                vo.setAllocatDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getOutDate()));
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            if (vo.getReceiveState() != null) {
                if (Integer.valueOf(AllocationState.TO_RECEIVING.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.TO_RECEIVING.getDescription());
                } else if (Integer.valueOf(AllocationState.RECEIVED.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.RECEIVED.getDescription());
                } else if (Integer.valueOf(AllocationState.REJECT.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.REJECT.getDescription());
                }
            }
            if (vo.getAllocatType() != null) {
                if (Integer.valueOf(AllocatEnum.ASSETS.getCode()).equals(vo.getAllocatType())) {
                    vo.setAllocatTypeName(AllocatEnum.ASSETS.getDescription());
                } else {
                    vo.setAllocatTypeName(AllocatEnum.HOMEMADE.getDescription());
                }
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", allotOutVos);
        ExcelExport.getInstance().export("allocationOutExport.xlsx", beans, response);
    }
}

