package com.ejianc.business.zdsstore.service.impl;

import com.ejianc.business.zdsstore.bean.ReturnGoodsEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.service.ICheckService;
import com.ejianc.business.zdsstore.service.IReturnGoodsService;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.ReturnGoodsVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.security.MessageDigest;
import java.util.*;

@Service("returnGoods") 
public class ReturnGoodsBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IReturnGoodsService returnGoodsService;

	@Autowired
	private StoreManageService storeManageService;
	@Autowired
	private ICheckService checkService;

	@Autowired
	private ISurplusService surplusService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ReturnGoodsEntity entity = returnGoodsService.selectById(billId);
		ReturnGoodsVO returnGoodsVO = BeanMapper.map(entity, ReturnGoodsVO.class);
		if(returnGoodsVO!=null && returnGoodsVO.getReturnGoodsDetailList().size()>0){
			StoreManageVO storeManageVO = returnGoodsVO.getStoreManageVO(returnGoodsVO);

			List<SurplusVO> queryVos = new ArrayList<>();
			Map<String, FlowVO> flowMap = new HashMap<>();
			storeManageVO.getFlowVOList().stream().forEach(flow -> {
				SurplusVO s = new SurplusVO();
				s.setStoreId(entity.getStoreId());
				s.setBrandId(flow.getBrandId());
				s.setMaterialId(flow.getMaterialId());
				flowMap.put(flow.getMaterialId() + "-" + flow.getBrandId(), flow);
			});
			//查询当前物资库存均价,并重算金额
			List<SurplusVO> queryRs = surplusService.querySurplusBatch(queryVos);
			FlowVO tmp = null;
			for(SurplusVO s : queryRs) {
				tmp = flowMap.get(s.getMaterialId() + "-" + s.getBrandId());
				if(null != tmp) {
					tmp.setPrice(s.getSurplusPrice());
					tmp.setTaxPrice(s.getSurplusTaxPrice());
					tmp.setMny(ComputeUtil.safeMultiply(tmp.getNum(), tmp.getPrice()));
					tmp.setTaxMny(ComputeUtil.safeMultiply(tmp.getNum(), tmp.getTaxPrice()));
					tmp.setTax(ComputeUtil.safeSub(tmp.getTaxMny(), tmp.getMny()));
					tmp.setTaxRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(tmp.getTax(), tmp.getTaxPrice()), new BigDecimal("100")));
				}
			}

			storeManageService.inOutStore(storeManageVO);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 1、退货单是否被物资合同结算引用，如引用，不可弃审；
		// 2、处置时间之后有盘点单时，不可弃审
		ReturnGoodsEntity entity = returnGoodsService.selectById(billId);
		if(entity != null){
			CommonResponse commonResponse = checkService.checkByDate(entity.getStoreId(), DateFormatUtil.formatDate("yyyy-MM-dd", entity.getOutDate()));
 			return commonResponse;
		}else{
			return CommonResponse.error("单据异常，弃审失败");
		}

	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ReturnGoodsEntity entity = returnGoodsService.selectById(billId);
		if(entity!=null && entity.getReturnGoodsDetailList().size()>0){
			StoreManageVO storeManageVO = new StoreManageVO();
			storeManageVO.setSourceId(entity.getId());
			storeManageVO.setStoreId(entity.getStoreId());
			storeManageVO.setOutEffectiveON(true);
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.材料退货);
			ArrayList<Long> longs = new ArrayList<>();
			longs.add(entity.getId());
			storeManageVO.setSourceIdsForRollBack(longs);
			storeManageService.inOutStoreRollback(storeManageVO);
		}

		return CommonResponse.success();
	}

//	public static void main(String[] args) throws Exception {
//
//
//		String appid = "91239d422e6b49418daca0875e5bebf8";
//		String md5Appid = toMD5(appid);
//		String nowStr = DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date());
//		String secret = "da47f09dbe7744d9ab85cacca643b6e4";
//		String sign = toMD5(secret + md5Appid + toMD5(nowStr));
//
//		System.out.println("appid: " + md5Appid);
//		System.out.println("ticket: " + nowStr);
//		System.out.println("sign: " + sign);
//	}

	public static String toMD5(String plainText) {
		StringBuffer buf = new StringBuffer("");
		try {
			// 生成实现指定摘要算法的 MessageDigest 对象。
			MessageDigest md = MessageDigest.getInstance("MD5");
			md.update(plainText.getBytes());
			// 通过执行诸如填充之类的最终操作完成哈希计算。
			byte b[] = md.digest();
			// 生成具体的md5密码到buf数组(32位小写)
			int i;

			for (int offset = 0; offset < b.length; offset++) {
				i = b[offset];
				if (i < 0){
					 i += 256;
				}
				if (i < 16){
					buf.append("0");
				}else{
					 buf.append(Integer.toHexString(i));
				}
			}
			} catch (Exception e) {
				e.printStackTrace();
			}
		return buf.toString();
	}

}
