package com.ejianc.business.zdsstore.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 材料退货表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_store_return_goods")
public class ReturnGoodsEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 出库编号
    @TableField(value="out_date")
    private Date outDate; // 出库日期
    @TableField(value="project_id")
    private Long projectId; // 出库项目id
    @TableField(value="project_name")
    private String projectName; // 出库项目名称
    @TableField(value="project_code")
    private String projectCode; // 所属项目编码
    @TableField(value="org_id")
    private Long orgId; // 出库组织id
    @TableField(value="org_name")
    private String orgName; // 出库组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="store_id")
    private Long storeId; // 出库仓库id
    @TableField(value="store_name")
    private String storeName; // 出库仓库名称
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value = "contract_code")
    private String contractCode;//合同编码
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="return_tax_mny")
    private BigDecimal returnTaxMny; // 退货金额
    @TableField(value="return_mny")
    private BigDecimal returnMny; // 退货金额不含税
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门id
    @TableField(value="department_name")
    private String departmentName; // 经办人部门
    @TableField(value="material_names")
    private String materialNames; // 出库物资名称集合
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="return_reason")
    private String returnReason; // 退货原因
    @TableField(value = "mny_disparity")
    private BigDecimal mnyDisparity; //退货差额
    @TableField(value = "tax_mny_disparity")
    private BigDecimal taxMnyDisparity; //退货差额（含税）

    @TableField(exist=false)
    @SubEntity(serviceName="returnGoodsDetailService",pidName = "outstoreId")
    private List<ReturnGoodsDetailEntity> returnGoodsDetailList = new ArrayList<>(); // 材料退货明细表

    @TableField(value="org_code")
    private String orgCode; // 项目组织编码

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public BigDecimal getMnyDisparity() {
        return mnyDisparity;
    }

    public void setMnyDisparity(BigDecimal mnyDisparity) {
        this.mnyDisparity = mnyDisparity;
    }

    public BigDecimal getTaxMnyDisparity() {
        return taxMnyDisparity;
    }

    public void setTaxMnyDisparity(BigDecimal taxMnyDisparity) {
        this.taxMnyDisparity = taxMnyDisparity;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getReturnTaxMny() {
        return returnTaxMny;
    }

    public void setReturnTaxMny(BigDecimal returnTaxMny) {
        this.returnTaxMny = returnTaxMny;
    }

    public BigDecimal getReturnMny() {
        return returnMny;
    }

    public void setReturnMny(BigDecimal returnMny) {
        this.returnMny = returnMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMaterialNames() {
        return materialNames;
    }

    public void setMaterialNames(String materialNames) {
        this.materialNames = materialNames;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }
    

    public List<ReturnGoodsDetailEntity> getReturnGoodsDetailList() {
        return returnGoodsDetailList;
    }

    public void setReturnGoodsDetailList(List<ReturnGoodsDetailEntity> returnGoodsDetailList) {
        this.returnGoodsDetailList = returnGoodsDetailList;
    }
}
