/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsstore.bean.ReturnGoodsEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.service.ICheckService;
import com.ejianc.business.zdsstore.service.IReturnGoodsService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="returnGoods")
public class ReturnGoodsBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IReturnGoodsService returnGoodsService;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private ICheckService checkService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ReturnGoodsEntity entity = (ReturnGoodsEntity)((Object)this.returnGoodsService.selectById(billId));
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> sourceIds = new ArrayList<Long>();
        sourceIds.add(billId);
        storeManageVO.setStoreId(entity.getStoreId());
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6750\u6599\u9000\u8d27);
        storeManageVO.setSourceIdsForRollBack(sourceIds);
        storeManageVO.setSourceId(billId);
        storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
        CommonResponse<StoreManageVO> commonResponse = this.storeManageService.inOutStore(storeManageVO);
        if (!commonResponse.isSuccess()) {
            this.logger.error("\u6750\u6599\u9000\u8d27\u5355-{}\u5ba1\u6279\u901a\u8fc7\u66f4\u65b0\u5e93\u5b58\u5360\u7528\u6d41\u6c34\u72b6\u6001\u5931\u8d25\uff0c{}", (Object)billId, (Object)JSONObject.toJSONString(commonResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u66f4\u65b0\u5e93\u5b58\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReturnGoodsEntity entity = (ReturnGoodsEntity)((Object)this.returnGoodsService.selectById(billId));
        if (entity != null) {
            CommonResponse commonResponse = this.checkService.checkByDate(entity.getStoreId(), DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getOutDate()));
            return commonResponse;
        }
        return CommonResponse.error((String)"\u5355\u636e\u5f02\u5e38\uff0c\u5f03\u5ba1\u5931\u8d25");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReturnGoodsEntity entity = (ReturnGoodsEntity)((Object)this.returnGoodsService.selectById(billId));
        if (entity != null && entity.getReturnGoodsDetailList().size() > 0) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6750\u6599\u9000\u8d27);
            ArrayList<Long> longs = new ArrayList<Long>();
            longs.add(entity.getId());
            storeManageVO.setSourceIdsForRollBack(longs);
            this.storeManageService.inOutStoreRollback(storeManageVO);
        }
        return CommonResponse.success();
    }

    public static void main(String[] args) throws Exception {
        String appid2 = "91239d422e6b49418daca0875e5bebf8";
        String md5Appid2 = ReturnGoodsBpmServiceImpl.toMD5(appid2);
        String nowStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
        String nowStrMd5 = ReturnGoodsBpmServiceImpl.toMD5(nowStr);
        String secret2 = "da47f09dbe7744d9ab85cacca643b6e4";
        String sign = ReturnGoodsBpmServiceImpl.toMD5(secret2 + md5Appid2 + nowStrMd5);
        System.out.println("appid: " + md5Appid2);
        System.out.println("nowStrMd5: " + nowStrMd5);
        System.out.println("ticket: " + nowStr);
        System.out.println("sign: " + sign);
    }

    public static String toMD5(String plainText) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] hashBytes = digest.digest(plainText.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString().toLowerCase();
    }

    public static String getMD5(String str) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(str.getBytes("GBK"));
        byte[] md5Bytes = md5.digest();
        String res = "";
        for (int i = 0; i < md5Bytes.length; ++i) {
            int temp = md5Bytes[i] & 0xFF;
            if (temp <= 15) {
                res = res + "0";
            }
            res = res + Integer.toHexString(temp);
        }
        return res;
    }
}

