package com.ejianc.business.zdsstore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsstore.bean.ReturnGoodsEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.service.ICheckService;
import com.ejianc.business.zdsstore.service.IReturnGoodsService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.ReturnGoodsVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("returnGoods") 
public class ReturnGoodsBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IReturnGoodsService returnGoodsService;

	@Autowired
	private StoreManageService storeManageService;
	@Autowired
	private ICheckService checkService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ReturnGoodsEntity entity = returnGoodsService.selectById(billId);
		ReturnGoodsVO vo = BeanMapper.map(entity, ReturnGoodsVO.class);
		StoreManageVO storeManageVO = vo.getStoreManageVO(vo);

		List<Long> sourceIds = new ArrayList<>();
		sourceIds.add(billId);
		storeManageVO.setStoreId(entity.getStoreId());
		storeManageVO.setInOutTypeEnum(InOutTypeEnum.材料退货);
		storeManageVO.setSourceIdsForRollBack(sourceIds);
		storeManageVO.setSourceId(billId);
		storeManageVO.setOutEffectiveON(true);
		CommonResponse<StoreManageVO> commonResponse = storeManageService.inOutStore(storeManageVO);
		if(!commonResponse.isSuccess()){
			logger.error("材料退货单-{}审批通过更新库存占用流水状态失败，{}", billId, JSONObject.toJSONString(commonResponse, SerializerFeature.PrettyFormat));
			return CommonResponse.error("操作失败，更新库存信息失败！");
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 1、退货单是否被物资合同结算引用，如引用，不可弃审；
		// 2、处置时间之后有盘点单时，不可弃审
		ReturnGoodsEntity entity = returnGoodsService.selectById(billId);
		if(entity != null){
			CommonResponse commonResponse = checkService.checkByDate(entity.getStoreId(), DateFormatUtil.formatDate("yyyy-MM-dd", entity.getOutDate()));
 			return commonResponse;
		}else{
			return CommonResponse.error("单据异常，弃审失败");
		}

	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ReturnGoodsEntity entity = returnGoodsService.selectById(billId);
		if(entity!=null && entity.getReturnGoodsDetailList().size()>0){
			StoreManageVO storeManageVO = new StoreManageVO();
			storeManageVO.setSourceId(entity.getId());
			storeManageVO.setStoreId(entity.getStoreId());
			storeManageVO.setOutEffectiveON(true);
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.材料退货);
			ArrayList<Long> longs = new ArrayList<>();
			longs.add(entity.getId());
			storeManageVO.setSourceIdsForRollBack(longs);
			storeManageService.inOutStoreRollback(storeManageVO);
		}

		return CommonResponse.success();
	}

	public static void main(String[] args) throws Exception {


		String appid2 = "91239d422e6b49418daca0875e5bebf8";
		String md5Appid2 = toMD5(appid2);
		String nowStr = DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date());
		String nowStrMd5 = toMD5(nowStr);
		String secret2 = "da47f09dbe7744d9ab85cacca643b6e4";
		String sign = toMD5(secret2 + md5Appid2 + nowStrMd5);

		System.out.println("appid: " + md5Appid2);
		System.out.println("nowStrMd5: " + nowStrMd5);
		System.out.println("ticket: " + nowStr);
		System.out.println("sign: " + sign);
	}

	public static String toMD5(String plainText) throws Exception {
		MessageDigest digest = MessageDigest.getInstance("MD5");
		byte[] hashBytes = digest.digest(plainText.getBytes());

		StringBuilder sb = new StringBuilder();
		for (byte b : hashBytes) {
			sb.append(Integer.toString((b & 0xff) + 0x100, 16).substring(1));
		}

		return sb.toString().toLowerCase();
	}


	/**
     * 解决php与javaMD5加密不同 获取MD5加密后的字符串
     *
     * @param str
     *            明文
     * @return 加密后的字符串
     * @throws Exception
     */
     public static String getMD5(String str) throws Exception {
        /** 创建MD5加密对象 */
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        /** 进行加密 */
        md5.update(str.getBytes("GBK"));
        /** 获取加密后的字节数组 */
        byte[] md5Bytes = md5.digest();
        String res = "";
        for (int i = 0; i < md5Bytes.length; i++) {
            int temp = md5Bytes[i] & 0xFF;
            if (temp <= 0XF) { // 转化成十六进制不够两位，前面加零
                res += "0";
            }
            res += Integer.toHexString(temp);
        }
        return res;
     }

}
