/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.material.api.IZDSMaterialApi;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsstore.bean.SurplusEntity;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"surplus"})
@Api(value="\u4ed3\u5e93\u5e93\u5b58\u8868", tags={"\u4ed3\u5e93\u5e93\u5b58\u8868"})
public class SurplusController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISurplusService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IZDSMaterialApi izdsMaterialApi;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SurplusVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody SurplusVO saveOrUpdateVO) {
        SurplusEntity entity = (SurplusEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SurplusEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        SurplusVO vo = (SurplusVO)BeanMapper.map((Object)((Object)entity), SurplusVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SurplusVO> queryDetail(@RequestParam Long id) {
        SurplusEntity entity = (SurplusEntity)((Object)this.service.selectById(id));
        SurplusVO vo = (SurplusVO)BeanMapper.map((Object)((Object)entity), SurplusVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SurplusVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SurplusVO surplusVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SurplusVO>> queryList(@RequestBody QueryParam param) {
        Object value;
        Long cateParId;
        CommonResponse listCommonResponse;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnitName");
        Map params = param.getParams();
        params.put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            params.put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            params.put("orgId", new Parameter("in", departmentIds));
        }
        Parameter materialCategoryIdPara = (Parameter)params.get("materialCategoryId");
        if (null != materialCategoryIdPara && materialCategoryIdPara.getValue() != null && (listCommonResponse = this.izdsMaterialApi.queryCategoryListByPid(cateParId = Long.valueOf((value = materialCategoryIdPara.getValue()).toString()))).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
            List categoryIds = ((List)listCommonResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            params.put("materialCategoryId", new Parameter("in", categoryIds));
        }
        param.getParams().put("surplusNum", new Parameter("sql", (Object)"(IFNULL(surplus_num,0)+IFNULL(out_lock_num,0))>0"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List surplusVOS = BeanMapper.mapList((Iterable)page.getRecords(), SurplusVO.class);
        surplusVOS.forEach(t -> {
            t.setSurplusNum(ComputeUtil.safeAdd((BigDecimal)t.getSurplusNum(), (BigDecimal)t.getOutLockNum()));
            t.setSurplusTaxPrice(ComputeUtil.safeDiv((BigDecimal)t.getSurplusTaxMny(), (BigDecimal)t.getSurplusNum()));
            t.setSurplusPrice(ComputeUtil.safeDiv((BigDecimal)t.getSurplusMny(), (BigDecimal)t.getSurplusNum()));
        });
        pageData.setRecords(surplusVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Surplus-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refSurplusData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SurplusVO>> refSurplusData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, @RequestParam(required=false) String relyCondition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnitName");
        fuzzyFields.add("brandName");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            param.getParams().put("storeId", new Parameter("eq", (Object)Long.parseLong(relyCondition.split("=")[1])));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"storeId")) {
                param.getParams().put("storeId", new Parameter("eq", _con.get((Object)"storeId")));
            }
            if (_con.containsKey((Object)"projectId")) {
                param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
            }
        }
        param.getParams().put("surplusNum", new Parameter("sql", (Object)"(IFNULL(surplus_num,0)-IFNULL(idle_num,0))>0"));
        param.getOrderMap().clear();
        param.getOrderMap().put("abs(ifnull(surplus_num,0)-ifnull(idle_num,0))", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List surplusVOS = BeanMapper.mapList((Iterable)page.getRecords(), SurplusVO.class);
        surplusVOS.forEach(t -> {
            t.setSurplusHasOutLockNum(ComputeUtil.safeAdd((BigDecimal)t.getSurplusNum(), (BigDecimal)t.getOutLockNum()));
            t.setSurplusMny(ComputeUtil.safeAdd((BigDecimal)t.getSurplusMny(), (BigDecimal)t.getOutLockMny()));
            t.setSurplusTaxMny(ComputeUtil.safeAdd((BigDecimal)t.getSurplusTaxMny(), (BigDecimal)t.getOutLockTaxMny()));
            t.setSurplusNum(ComputeUtil.safeSub((BigDecimal)t.getSurplusNum(), (BigDecimal)t.getIdleNum()));
        });
        pageData.setRecords(surplusVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/lazyMaterialCategory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialCategoryVO>> lazyMaterialCategory(@RequestParam(value="parentId", required=false) Long parentId, @RequestParam(value="storeId") Long storeId) {
        ArrayList<MaterialCategoryVO> materialCategoryVO;
        block5: {
            CommonResponse listCommonResponse;
            List categoryIds = null;
            if (null != parentId && (listCommonResponse = this.izdsMaterialApi.queryCategoryListByPid(parentId)).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
                categoryIds = ((List)listCommonResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SurplusEntity::getStoreId, (Object)storeId);
            queryWrapper.in(null != parentId && CollectionUtils.isNotEmpty(categoryIds), SurplusEntity::getMaterialCategoryId, categoryIds);
            List surplusEntities = this.service.list((Wrapper)queryWrapper);
            materialCategoryVO = new ArrayList<MaterialCategoryVO>();
            if (!CollectionUtils.isNotEmpty((Collection)surplusEntities)) break block5;
            List categoryIdList = surplusEntities.stream().map(SurplusEntity::getMaterialCategoryId).collect(Collectors.toList());
            CommonResponse materialCategoryVOS = this.izdsMaterialApi.queryCategoryListByChildren(categoryIdList);
            List dateList = (List)materialCategoryVOS.getData();
            if (parentId != null) {
                for (MaterialCategoryVO materialCategoryVO1 : dateList) {
                    if (materialCategoryVO1.getParentId() == null || !materialCategoryVO1.getParentId().equals(parentId)) continue;
                    materialCategoryVO.add(materialCategoryVO1);
                }
            } else {
                for (MaterialCategoryVO materialCategoryVO1 : dateList) {
                    if (materialCategoryVO1.getParentId() != null) continue;
                    materialCategoryVO.add(materialCategoryVO1);
                }
            }
        }
        return CommonResponse.success(materialCategoryVO);
    }
}

