package com.ejianc.business.zdsstore.service;

import cn.hutool.json.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsstore.bean.FlowEntity;
import com.ejianc.business.zdsstore.vo.*;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.HashMap;
import java.util.List;

/**
 * 仓库流水表
 *
 * @author generator
 */
public interface IFlowService extends IBaseService<FlowEntity> {

    /**
     * @param sourceId 入库单id
     * @param storeId
     * @description: 校验入库单是否被使用，结算，对账
     * @return: com.ejianc.framework.core.response.CommonResponse<List < FlowEntity>>
     * @author songlx
     * @date: 2022/1/25
     */
    CommonResponse<List<FlowEntity>> validateIsUse(Long sourceId, Long storeId);

    /**
     * @param page
     * @param wrapper
     * @description: 查询入库可用数量, 按材料合并
     * @return: java.util.List<com.ejianc.business.store.vo.FlowVO>
     * @author songlx
     * @date: 2022/2/11
     */
    List<FlowVO> queryInstoreFlowData(IPage<FlowVO> page, QueryWrapper wrapper);

    /**
     * @param computeStoreVO
     * @description: 根据入库流水计算库存
     * @return: java.util.List<com.ejianc.business.store.vo.SurplusVO>
     * @author songlx
     * @date: 2022/2/18
     */
    List<SurplusVO> computeStore(ComputeStoreVO computeStoreVO);

    /**
     * @param storeManageVO
     * @description: 更新摊销金额
     * @return: com.ejianc.business.store.vo.StoreManageVO
     * @author songlx
     * @date: 2022/3/2
     */
    StoreManageVO updateShareMny(StoreManageVO storeManageVO);


    /**
     * @param sourceId
     * @param storeId
     * @description: 周传材料入库弃审校验是否出库或被摊销
     * @return: com.ejianc.framework.core.response.CommonResponse<cn.hutool.json.JSONObject>
     * @author songlx
     * @date: 2022/3/2
     */
    CommonResponse<JSONObject> validateTurnIsUseOutFlag(Long sourceId, Long storeId);

    /**
     * @param page
     * @param wrapper
     * @description: 对账/结算入库材料参照
     * @return: java.util.List<com.ejianc.business.store.vo.StoreInstoreVO>
     * @author songlx
     * @date: 2022/3/9
     */
    List<StoreApiVO> queryStoreInstoreData(Page<StoreApiVO> page, QueryWrapper wrapper);

    /**
     * @param page
     * @param wrapper
     * @description: 周转材材料参照
     * @return: java.util.List<com.ejianc.business.store.vo.FlowVO>
     * @author songlx
     * @date: 2022/2/11
     */
    List<FlowVO> queryTurnInstoreFlowData(Page<FlowVO> page, QueryWrapper wrapper);

    Integer settleCount(HashMap<String, Object> map);

    void changeSettleFlag(HashMap<String, Object> map);

    /**
     * @param page
     * @param wrapper
     * @description: 根据流水计算出来的库存列表
     * @return: java.util.List<com.ejianc.business.store.vo.SurplusVO>
     * @author songlx
     * @date: 2022/4/1
     */
    List<SurplusVO> computeStoreList(Page<SurplusVO> page, QueryWrapper wrapper);


    /**
     * @param topN
     * @param dateIn
     * @param orgIdList
     * @description: 查询物资分类结算量前N名
     * @return: java.util.List<com.ejianc.business.store.vo.MaterialCategoryTop5VO>
     * @author songlx
     * @date: 2022/4/26
     */
    List<MaterialCategoryTopVO> queryMaterialCategoryTopN(Integer topN, String dateIn, List<Long> orgIdList);

    List<FlowVO> getSendReceiveList(Page<FlowVO> page, QueryWrapper wrapper);

    List<FlowVO> queryFlowBatch(List<FlowVO> vos);
}
