package com.ejianc.business.zdsstore.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.zdsstore.bean.PickReturnDetailEntity;
import com.ejianc.business.zdsstore.bean.PickReturnEntity;
import com.ejianc.business.zdsstore.mapper.PickReturnMapper;
import com.ejianc.business.zdsstore.service.IPickReturnDetailService;
import com.ejianc.business.zdsstore.service.IPickReturnService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.PickReturnVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 材料退库表
 * 
 * @author generator
 * 
 */
@Service("pickReturnService")
public class PickReturnServiceImpl extends BaseServiceImpl<PickReturnMapper, PickReturnEntity> implements IPickReturnService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private PickReturnMapper pickReturnMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "zds_PICK_RETURN_CODE";//此处需要根据实际修改
    @Autowired
    private IPickReturnService service;

    @Autowired
    private IPickReturnDetailService detailService;


    /**
     * 根据合同id 查询当前合同是否有未生效单据
     * @param contractId
     * @return
     */
    @Override
    public PickReturnVO queryByContractId(Long contractId) {
        PickReturnVO resp = null;
        QueryWrapper<PickReturnEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);
        query.eq("bill_state", BillStateEnum.UNCOMMITED_STATE);
        query.eq("dr", BaseVO.DR_UNDELETE);
        PickReturnEntity entity = pickReturnMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, PickReturnVO.class);
        }
        return resp;
    }

    @Override
    public void removeByPickReturnIds(List<Long> ids) {

        this.removeByIds(ids,true);
    }


    @Override
    public PickReturnVO saveOrUpdate(PickReturnVO saveOrUpdateVO) {
        PickReturnEntity entity = BeanMapper.map(saveOrUpdateVO, PickReturnEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                entity.setProportionFlag("0"); // 初始化标识
                entity.setRelationFlag("0"); // 初始化标识
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        PickReturnVO voByContract = service.queryByContractId(saveOrUpdateVO.getContractId());
        if(null != voByContract && (null == saveOrUpdateVO.getId() || !voByContract.getId().equals(saveOrUpdateVO.getId()))) {
            throw new BusinessException("保存失败，该合同下存在未生效单据，请勿重复添加！");
        }
        service.saveOrUpdate(entity, false);
        PickReturnVO vo = BeanMapper.map(entity, PickReturnVO.class);
        return vo;
    }








}
