/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsstore.bean.PickReturnDetailEntity;
import com.ejianc.business.zdsstore.bean.PickReturnEntity;
import com.ejianc.business.zdsstore.mapper.PickReturnMapper;
import com.ejianc.business.zdsstore.service.IPickReturnDetailService;
import com.ejianc.business.zdsstore.service.IPickReturnService;
import com.ejianc.business.zdsstore.vo.PickReturnVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="pickReturnService")
public class PickReturnServiceImpl
extends BaseServiceImpl<PickReturnMapper, PickReturnEntity>
implements IPickReturnService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PickReturnMapper pickReturnMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "zds_PICK_RETURN_CODE";
    @Autowired
    private IPickReturnService service;
    @Autowired
    private IPickReturnDetailService detailService;
    private final String OPERATE = "pickReturnBill";
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private PickReturnMapper mapper;

    @Override
    public PickReturnVO queryByContractId(Long contractId) {
        PickReturnVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractId);
        query.eq((Object)"bill_state", (Object)BillStateEnum.UNCOMMITED_STATE);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        PickReturnEntity entity = (PickReturnEntity)((Object)this.pickReturnMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (PickReturnVO)BeanMapper.map((Object)((Object)entity), PickReturnVO.class);
        }
        return resp;
    }

    @Override
    public void removeByPickReturnIds(List<Long> ids) {
        this.removeByIds(ids, true);
    }

    @Override
    public PickReturnVO saveOrUpdate(PickReturnVO saveOrUpdateVO) {
        PickReturnVO voByContract;
        PickReturnEntity entity = (PickReturnEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PickReturnEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.setProportionFlag("0");
                entity.setRelationFlag("0");
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (!(null == (voByContract = this.service.queryByContractId(saveOrUpdateVO.getContractId())) || null != saveOrUpdateVO.getId() && voByContract.getId().equals(saveOrUpdateVO.getId()))) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u5408\u540c\u4e0b\u5b58\u5728\u672a\u751f\u6548\u5355\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        PickReturnVO vo = (PickReturnVO)BeanMapper.map((Object)((Object)entity), PickReturnVO.class);
        return vo;
    }

    @Override
    public PickReturnEntity getBySourceId(String sourceId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_id", (Object)sourceId);
        PickReturnEntity e = (PickReturnEntity)((Object)super.getOne((Wrapper)query));
        if (null != e) {
            List<PickReturnDetailEntity> detailList = this.detailService.getAllByDeliveryId(e.getId());
            e.setPickReturnDetailList(detailList);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String billDel(PickReturnEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "pickReturnBill::" + entity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"pickReturnBill", (int)600);
            if (!locked) {
                this.releaseLock(jedis, false, key, "pickReturnBill");
                String string = "\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u6570\u636e\u5df2\u88ab\u4fee\u6539\uff01";
                return string;
            }
            boolean delResult = this.deleteByPickReturnId(entity.getId());
            if (!delResult) {
                this.releaseLock(jedis, true, key, "pickReturnBill");
                String string = "\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u5220\u9664\u5931\u8d25\uff01";
                return string;
            }
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u8d27\u5355id-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)entity.getId(), (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "pickReturnBill");
        }
        return msg;
    }

    private boolean deleteByPickReturnId(Long deliveryId) {
        this.mapper.deleteByPickReturnId(deliveryId);
        this.detailService.deleteByPickReturnId(deliveryId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

