package com.ejianc.business.zdsstore.service;

import com.ejianc.business.zdsstore.bean.PickReturnEntity;
import com.ejianc.business.zdsstore.vo.PickReturnVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 材料退库表
 * 
 * @author generator
 * 
 */
public interface IPickReturnService extends IBaseService<PickReturnEntity> {

    /**
     * 根据合同id 查询当前合同是否有未生效单据
     * @param contractId
     * @return
     */
    PickReturnVO queryByContractId(Long contractId);

    void removeByPickReturnIds(List<Long> ids);



    PickReturnVO saveOrUpdate(PickReturnVO saveOrUpdateVO);

    PickReturnEntity getBySourceId(String sourceId);

    /**
     * 供方撤回作废
     *
     * @param entity
     * @return
     */
    String billDel(PickReturnEntity entity);
}
