package com.ejianc.business.zdsstore.service;

import com.ejianc.business.zdsstore.bean.PickReturnEntity;
import com.ejianc.business.zdsstore.vo.PickReturnVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 材料退库表
 * 
 * @author generator
 * 
 */
public interface IPickReturnService extends IBaseService<PickReturnEntity> {
    /**
     * 根据合同id 查询当前合同是否有未生效单据
     * @param contractId
     * @return
     */
    PickReturnVO queryByContractId(Long contractId);
    void removeByPickReturnIds(List<Long> ids);
    PickReturnVO saveOrUpdate(PickReturnVO saveOrUpdateVO);
    PickReturnEntity getBySourceId(String sourceId);

    /**
     * 甲方推送退库单
     * @param entity
     * @return
     */
    String  pushPickReturnBill(PickReturnEntity entity);

    /**
     * 甲方弃审 供方删除
     * @param entity
     * @return
     */
    String deletePickReturnBill(PickReturnEntity entity);


    /**
     * 接口推送接口
     * 接受 推送 确认 驳回
     * @param request
     * @return
     */
    CommonResponse<String> syncPickReturn(HttpServletRequest request);
    /**
     * 供方弃审 甲方删除
     *
     * @param entity
     * @return
     */
    String billDel(PickReturnEntity entity);



}
