package com.ejianc.business.zdsstore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.zdsstore.bean.PickReturnDetailEntity;
import com.ejianc.business.zdsstore.bean.PickReturnEntity;
import com.ejianc.business.zdsstore.enums.ProsubSignStatusEnum;
import com.ejianc.business.zdsstore.mapper.PickReturnMapper;
import com.ejianc.business.zdsstore.service.IPickReturnDetailService;
import com.ejianc.business.zdsstore.service.IPickReturnService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.PickReturnVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 材料退库表
 * 
 * @author generator
 * 
 */
@Service("pickReturnService")
public class PickReturnServiceImpl extends BaseServiceImpl<PickReturnMapper, PickReturnEntity> implements IPickReturnService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE_CODE = "EJCBT202312000017";//单价类型编码规则
    private static final String BILL_CODE = "zds_PICK_RETURN_CODE";//此处需要根据实际修改
    private final String OPERATE = "pickReturnBill";
    private final String BILL_DEL_PM_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/pickReturn/billDel";//删除接口
    private final String BILL_PUSH_PM_SERVER_URL ="/ejc-zdssupbusiness-web/openapi/pickReturn/syncPickReturnBill";//推送接口
    @Autowired
    private PickReturnMapper pickReturnMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPickReturnService service;
    @Autowired
    private IPickReturnDetailService detailService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private PickReturnMapper mapper;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    /**
     * 根据合同id 查询当前合同是否有未生效单据
     * @param contractId
     * @return
     */
    @Override
    public PickReturnVO queryByContractId(Long contractId) {
        PickReturnVO resp = null;
        QueryWrapper<PickReturnEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);
        query.eq("bill_state", BillStateEnum.UNCOMMITED_STATE);
        query.eq("dr", BaseVO.DR_UNDELETE);
        PickReturnEntity entity = pickReturnMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, PickReturnVO.class);
        }
        return resp;
    }

    @Override
    public void removeByPickReturnIds(List<Long> ids) {

        this.removeByIds(ids,true);
    }


    @Override
    public PickReturnVO saveOrUpdate(PickReturnVO saveOrUpdateVO) {
        PickReturnEntity entity = BeanMapper.map(saveOrUpdateVO, PickReturnEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                entity.setProportionFlag("0"); // 初始化标识
                entity.setRelationFlag("0"); // 初始化标识
                entity.setConfirmStatus(ProsubSignStatusEnum.待确认.getCode());
                entity.setSourceType(ProsubSignStatusEnum.自制.getCode());
                entity.setSignStatus(ProsubSignStatusEnum.未签字.getCode());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        PickReturnVO voByContract = service.queryByContractId(saveOrUpdateVO.getContractId());
        if(null != voByContract && (null == saveOrUpdateVO.getId() || !voByContract.getId().equals(saveOrUpdateVO.getId()))) {
            throw new BusinessException("保存失败，该合同下存在未生效单据，请勿重复添加！");
        }
        service.saveOrUpdate(entity, false);
        PickReturnVO vo = BeanMapper.map(entity, PickReturnVO.class);
        return vo;
    }

    @Override
    public PickReturnEntity getBySourceId(String sourceId) {
        QueryWrapper<PickReturnEntity> query = new QueryWrapper<>();
        query.eq("source_id", sourceId);

        PickReturnEntity e = super.getOne(query);
        if(null != e) {
            List<PickReturnDetailEntity> detailList = detailService.getAllByDeliveryId(e.getId());
            e.setPickReturnDetailList(detailList);
        }

        return e;
    }
    @Autowired
    private IAttachmentApi attachmentApi;
    @Override
    public String pushPickReturnBill(PickReturnEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = OPERATE + "::" + entity.getId().toString() + "::sup";
        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);
            if (!locked) {
                releaseLock(jedis, false, key, OPERATE);
                return "材料退库推送供应链平台失败，加锁失败！";
            }
            //设置单据当前系统信息
            CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                logger.error("推送验收-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
                return "推送验收失败，获取当前系统编码失败";
            }
            entity.setSourceSystemId(ejcCloudSystemCode.getData());

            Map<String, String> params = new HashMap<>();

            if (ProsubSignStatusEnum.待确认.getCode().equals(entity.getConfirmStatus())) {
                CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(entity.getId(), null, null, null);
                if (fileResp.isSuccess()) {
                    Map<String, Map<String, InputStream>> files = new HashMap<>();
                    List<AttachmentVO> fileList = fileResp.getData();

                    //Map<fileName, fileSourceType>
                    Map<String, String> fileSourceTypeMap = new HashMap<>();
                    List<Long> fileIds = new ArrayList<>();

                    //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                    for (AttachmentVO attach : fileList) {
                        fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                        fileIds.add(attach.getId());
                    }
                    params.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                    //当前单据携带有附件信息
                    if (CollectionUtils.isNotEmpty(fileList)) {
                        Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                        fileMap.keySet().stream().forEach(fileKey -> {
                            Map<String, InputStream> file = new HashMap<>(1);
                            file.put(fileKey, fileMap.get(fileKey));
                            files.put(fileKey, file);
                        });
                    }
                    params.put("billData", JSONObject.toJSONString(entity));
                    logger.info("材料退库推送供应链平台: url-{}, 发货单：{}", BILL_PUSH_PM_SERVER_URL, JSONObject.toJSONString(entity));
                    CommonResponse<String> writeBackResp = systemDataPushService.exchangeDataAndFilesWithThirdSystem(BILL_PUSH_PM_SERVER_URL,
                            params, ejcCloudSystemCode.getData(), files);
                    logger.error("材料退库推送供应链平台请求结果，{}", JSONObject.toJSONString(writeBackResp));
                    if (!writeBackResp.isSuccess()) {
                        releaseLock(jedis, true, key, OPERATE);
                        logger.error("材料退库id-{}推送供应链平台发送请求失败，{}", entity.getId(), writeBackResp.getMsg());
                        return "材料退库推送供应链平台失败";
                    }

                    String operateRespStr = writeBackResp.getData();
                    CommonResponse<String> operateResp = JSONObject.parseObject(operateRespStr, CommonResponse.class);
                    if (!operateResp.isSuccess()) {
                        logger.error("材料退库id-{}推送供应链，平台处理失败，{}", entity.getId(), operateResp.getMsg());
                        releaseLock(jedis, true, key, OPERATE);
                        return "材料退库推送供应链平台失败";
                    }

                }
            }else {
                params.put("billData", JSONObject.toJSONString(entity));
                logger.info("材料退库推送供应链平台: url-{}, 发货单：{}", BILL_PUSH_PM_SERVER_URL, JSONObject.toJSONString(entity));
                CommonResponse<String> writeBackResp = systemDataPushService.exchangeDataAndFilesWithThirdSystem(BILL_PUSH_PM_SERVER_URL,
                        params, ejcCloudSystemCode.getData(), null);
                logger.info("材料退库推送供应链平台请求结果，{}", JSONObject.toJSONString(writeBackResp));

                if (!writeBackResp.isSuccess()) {
                    releaseLock(jedis, true, key, OPERATE);
                    logger.error("材料退库id-{}推送供应链平台发送请求失败，{}", entity.getId(), writeBackResp.getMsg());
                    return "材料退库推送供应链平台失败";
                }

                String operateRespStr = writeBackResp.getData();
                CommonResponse<String> operateResp = JSONObject.parseObject(operateRespStr, CommonResponse.class);
                if (!operateResp.isSuccess()) {
                    logger.error("材料退库id-{}推送供应链，平台处理失败，{}", entity.getId(), operateResp.getMsg());
                    releaseLock(jedis, true, key, OPERATE);
                    return "材料退库推送供应链平台失败";
                }
            }




        } catch (Exception e) {
            logger.error("材料退库id-{}推送供应链平台失败，", entity.getId(), e);
            msg = "操作失败，材料退库推送供应链平台失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;
    }



    @Override
    public CommonResponse<String> syncPickReturn(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);
        logger.info("接收到推送退库单据: {}, 当前上下文: {}", transData, authority);

        if (StringUtils.isBlank(transData)) {
            return CommonResponse.error("单据同步失败，单据内容为空！");
        }

        PickReturnEntity entity = JSONObject.parseObject(transData, PickReturnEntity.class);
        if(ProsubSignStatusEnum.待确认.getCode().equals(entity.getConfirmStatus())){
            //执行新增 设置来源
            entity.setSourceId(entity.getId());
            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, BILL_TYPE_CODE, authority, null);

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            entity.setAttachIds(attchIdsList);
            entity.setTenantId(InvocationInfoProxy.getTenantid());
            entity.setSourceType(ProsubSignStatusEnum.自制.getCode());
            service.saveOrUpdate(entity);
            return CommonResponse.success("单据同步成功！");
        }else if (ProsubSignStatusEnum.已驳回.getCode().equals(entity.getConfirmStatus())||ProsubSignStatusEnum.已确认.getCode().equals(entity.getConfirmStatus())){
            //执行修改
            PickReturnEntity pickReturn = service.selectById(entity.getSourceId());
            pickReturn.setConfirmStatus(entity.getConfirmStatus());
            pickReturn.setSignStatus(entity.getSignStatus());
            logger.info("退库单更新确认状态：id-{}", pickReturn.getSourceId());
            service.saveOrUpdate(pickReturn);
            return CommonResponse.success("单据同步成功！");
        }
        logger.info("确认状态为空：id-{}", entity.getId());
        return CommonResponse.success("单据同步成功！");
    }


    @Override
    public String billDel(PickReturnEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;

        String key = OPERATE + "::" + entity.getId().toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);
            //加锁失败
            if(!locked) {
                releaseLock(jedis, false, key, OPERATE);
                return  "单据作废失败，单据数据已被修改！";
            }
            //删除单据
            boolean delResult  = deleteByPickReturnId(entity.getId());
            if(!delResult) {
                releaseLock(jedis, true, key, OPERATE);
                return "操作失败，单据删除失败！";
            }
        } catch (Exception e) {
            logger.error("发货单id-{}作废异常，", entity.getId(), e);
            msg = "操作失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;
    }

    @Override
    public String deletePickReturnBill(PickReturnEntity entity) {

        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = OPERATE + "::" + entity.getId().toString() + "::sup";

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            //加锁失败
            if (!locked) {
                releaseLock(jedis, false, key, OPERATE);
                return "材料退库作废失败，加锁失败！";
            }
            Map<String, String> params = new HashMap<>();
            params.put("sourceId", entity.getId().toString());

            //设置单据当前系统信息
            CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                logger.error("推送验收-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
                return "推送验收失败，获取当前系统编码失败";
            }
            logger.info("材料退库作废通知供方平台: url-{}, 材料退库：{}", BILL_DEL_PM_SERVER_URL, JSONObject.toJSONString(entity));
            CommonResponse<String> writeBackResp = systemDataPushService.exchangeDataAndFilesWithThirdSystem(BILL_DEL_PM_SERVER_URL,
                    params, ejcCloudSystemCode.getData(), null);
            logger.error("材料退库作废通知供方平台请求结果，{}", JSONObject.toJSONString(writeBackResp));
            if (!writeBackResp.isSuccess()) {
                releaseLock(jedis, true, key, OPERATE);
                logger.error("材料退库id-{}作废通知供方平台发送请求失败，{}", entity.getId(), writeBackResp.getMsg());
                return "发货作废通知供方平台失败";
            }
            String operateRespStr = writeBackResp.getData();
            CommonResponse<String> operateResp = JSONObject.parseObject(operateRespStr, CommonResponse.class);
            if (!operateResp.isSuccess()) {
                logger.error("材料退库id-{}推送供方，平台处理失败，{}", entity.getId(), operateResp.getMsg());
                releaseLock(jedis, true, key, OPERATE);
                return "材料退库作废通知供方平台失败";
            }

        } catch (Exception e) {
            logger.error("材料退库id-{}作废通知供方平台失败，", entity.getId(), e);
            msg = "操作失败，材料退库作废通知供方平台失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }

    private boolean deleteByPickReturnId(Long deliveryId) {
        mapper.deleteByPickReturnId(deliveryId);
        detailService.deleteByPickReturnId(deliveryId);
        return true;
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }
}
