package com.ejianc.business.zdsstore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
//import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.zdsstore.bean.PickReturnEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.enums.ProsubSignStatusEnum;
import com.ejianc.business.zdsstore.service.ICheckService;
import com.ejianc.business.zdsstore.service.IPickReturnService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.PickReturnDetailVO;
import com.ejianc.business.zdsstore.vo.PickReturnVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.*;
import java.util.stream.Collectors;

@Service("pickReturn")
public class PickReturnBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPickReturnService pickReturnService;

    @Autowired
    private StoreManageService storeManageService;

    @Autowired
    private ICheckService checkService;

//    @Autowired
//    private ICostDetailApi costDetailApi;

    @Autowired
    private IBillTypeApi billTypeApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        PickReturnEntity entity = pickReturnService.selectById(billId);
        PickReturnVO pickReturnVO = BeanMapper.map(entity, PickReturnVO.class);
        if (pickReturnVO != null && pickReturnVO.getPickReturnDetailList().size() > 0) {
            Map<Long, List<PickReturnDetailVO>> detailMap = pickReturnVO.getPickReturnDetailList().stream().collect(Collectors.groupingBy(PickReturnDetailVO::getStoreId));
            detailMap.forEach((storeId, value) -> {
                List<PickReturnDetailVO> detailVOS = detailMap.get(storeId);
                pickReturnVO.setPickReturnDetailList(detailVOS);
                StoreManageVO storeManageVO = pickReturnVO.getStoreManageVO(pickReturnVO, storeId);
                storeManageService.inOutStore(storeManageVO);
            });
        }
        logger.info("推送供方---");
        if (entity.getPickType()==1){
            String s = pickReturnService.pushPickReturnBill(entity);
            if (StringUtils.isNotBlank(s)){
                throw new BusinessException(s);
            }
            entity.setConfirmStatus(ProsubSignStatusEnum.已确认.getCode());
            pickReturnService.saveOrUpdate(entity);
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {

        //TODO
        // 1、需判断除本单据生成出库单之外，与该退库单相关联的入库单的入库数量大于等于对应出库单的出库数量；  如不满足条件，不可弃审；
        // 2、材料退库对应的出库单是否被成本引用，如被引用，不可弃审；
        // 2、处置时间之后有盘点单时，不可弃审
        PickReturnEntity entity = pickReturnService.selectById(billId);
        if (entity.getSourceType()!=null&&ProsubSignStatusEnum.供方申请.getCode().equals(entity.getSourceType())){
            return CommonResponse.error("来源供方申请的单据,不能弃审和撤回！");
        }
        logger.info("退库弃审校验------------------------------单据类型:"+billTypeCode);
        CommonResponse<String> commonResponse = billTypeApi.checkQuote(billTypeCode, billId);
        logger.info("平台返回查询被引用情况"+commonResponse.isSuccess()+"----"+commonResponse.getMsg());
        boolean success = commonResponse.isSuccess();
        if (!success){
            return CommonResponse.error("已经被归集单使用,不能弃审和撤回！");
        }

        if (entity!=null){
            if (ProsubSignStatusEnum.已签字.getCode().equals(entity.getSignStatus())){
                return CommonResponse.error("供方已签字的退库单无法撤回！");
            }
        }
        if (entity.getPickType()==2){
            String msg = pickReturnService.deletePickReturnBill(entity);
            if (StringUtils.isNotBlank(msg)) {
                return CommonResponse.error(msg);
            }
        }


        if (entity != null) {
            commonResponse = checkService.checkByDate(entity.getStoreId(), DateFormatUtil.formatDate("yyyy-MM-dd", entity.getInstoreDate()));
            return commonResponse;
        } else {
            return CommonResponse.error("已经被仓库盘点,使用不能弃审和撤回");
        }




    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {

        PickReturnEntity entity = pickReturnService.selectById(billId);
        if (entity != null && entity.getPickReturnDetailList().size() > 0) {
            PickReturnVO pickReturnVO = BeanMapper.map(entity, PickReturnVO.class);
            Map<Long, List<PickReturnDetailVO>> detailMap = pickReturnVO.getPickReturnDetailList().stream().collect(Collectors.groupingBy(PickReturnDetailVO::getStoreId));
            detailMap.forEach((storeId, value) -> {
                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setSourceId(entity.getId());
                storeManageVO.setStoreId(storeId);
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.领料退库);
                storeManageService.inOutStoreRollback(storeManageVO);
            });
        }
        String s = pickReturnService.deletePickReturnBill(entity);

        if (StringUtils.isNotBlank(s)){
            throw new BusinessException(s);
        }
        return CommonResponse.success();
    }

}
