package com.ejianc.business.zdsstore.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zdsstore.mapper.PickReturnDetailMapper;
import com.ejianc.business.zdsstore.bean.PickReturnDetailEntity;
import com.ejianc.business.zdsstore.service.IPickReturnDetailService;

import java.util.List;

/**
 * 材料退库明细表
 * 
 * @author generator
 * 
 */
@Service("pickReturnDetailService")
public class PickReturnDetailServiceImpl extends BaseServiceImpl<PickReturnDetailMapper, PickReturnDetailEntity> implements IPickReturnDetailService{
    @Autowired
    private PickReturnDetailMapper mapper;
    @Override
    public List<PickReturnDetailEntity> getAllByDeliveryId(Long returnId) {
        QueryWrapper<PickReturnDetailEntity> query = new QueryWrapper<>();
        query.eq("delivery_id", returnId);
        return super.list(query);    }

    @Override
    public void deleteByPickReturnId(Long returnId) {
        mapper.deleteByPickReturnId(returnId);

    }
}
