/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsstore.bean.FlowEntity;
import com.ejianc.business.zdsstore.bean.SurplusEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.mapper.FlowMapper;
import com.ejianc.business.zdsstore.service.IFlowService;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.vo.ComputeStoreVO;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.MaterialCategoryTopVO;
import com.ejianc.business.zdsstore.vo.StoreApiVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="flowService")
public class FlowServiceImpl
extends BaseServiceImpl<FlowMapper, FlowEntity>
implements IFlowService {
    @Autowired
    ISurplusService surplusService;

    @Override
    public CommonResponse<List<FlowEntity>> validateIsUse(Long sourceId, Long storeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"store_id", (Object)storeId);
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        queryWrapper.eq((Object)"in_out_flag", (Object)StoreCommonConsts.IN_OUT_TYPE_IN);
        List instoreList = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)instoreList)) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8be5\u5165\u5e93\u5355\u6d41\u6c34\u4fe1\u606f\uff01");
        }
        for (FlowEntity flow : instoreList) {
            Integer outUseFlag = flow.getOutUseFlag();
            if (!InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u5165\u5e93.getInOutType().equals(flow.getInOutType()) && (StoreCommonConsts.UseOutFlag.USEING.equals(outUseFlag) || StoreCommonConsts.UseOutFlag.USE_FINISH.equals(outUseFlag))) {
                return CommonResponse.error((String)("\u7269\u8d44[\u540d\u79f0\uff1a" + flow.getMaterialName() + "\uff0c\u89c4\u683c\uff1a" + StrUtil.emptyToDefault((CharSequence)flow.getMaterialSpec(), (String)"\u65e0") + "\uff0c\u54c1\u724c\uff1a" + StrUtil.emptyToDefault((CharSequence)flow.getBrandName(), (String)"\u65e0") + "]\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de\uff01"));
            }
            Integer accountFlag = flow.getAccountFlag();
            if (StoreCommonConsts.ONE.equals(accountFlag)) {
                return CommonResponse.error((String)"\u5355\u636e\u5df2\u5bf9\u8d26\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de\uff01");
            }
            Integer settleFlag = flow.getSettleFlag();
            if (!StoreCommonConsts.ONE.equals(settleFlag)) continue;
            return CommonResponse.error((String)"\u5355\u636e\u5df2\u7ed3\u7b97\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de\uff01");
        }
        return CommonResponse.success((Object)instoreList);
    }

    @Override
    public List<FlowVO> queryInstoreFlowData(IPage<FlowVO> page, QueryWrapper wrapper) {
        return ((FlowMapper)this.baseMapper).queryInstoreFlowData(page, wrapper);
    }

    @Override
    public List<SurplusVO> computeStore(ComputeStoreVO computeStoreVO) {
        Long storeId = computeStoreVO.getStoreId();
        List flowVOList = computeStoreVO.getFlowVOList();
        ArrayList<Long> materialIds = null;
        ArrayList brandIds = null;
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"store_id", (Object)storeId);
        if (CollectionUtils.isNotEmpty((Collection)flowVOList)) {
            materialIds = new ArrayList<Long>(flowVOList.stream().map(FlowVO::getMaterialId).collect(Collectors.toSet()));
            brandIds = new ArrayList(flowVOList.stream().map(FlowVO::getBrandId).collect(Collectors.toSet()));
            wrapper.and(q -> {
                for (FlowVO f : flowVOList) {
                    q.or(iq -> (QueryWrapper)((QueryWrapper)iq.eq((Object)"brand_id", (Object)f.getBrandId())).eq((Object)"material_id", (Object)f.getMaterialId()));
                }
                return q;
            });
        }
        List oldList = this.surplusService.list((Wrapper)wrapper);
        boolean updateFlag = computeStoreVO.getUpdateFlag();
        List<SurplusVO> newSurplusVOList = ((FlowMapper)this.baseMapper).computeStore(storeId, materialIds, brandIds);
        Map<String, List<SurplusVO>> newSurplusVOMap = newSurplusVOList.stream().collect(Collectors.groupingBy(x -> x.getMaterialId() + "@" + x.getBrandId()));
        ArrayList<Long> delIds = new ArrayList<Long>();
        Iterator it = oldList.iterator();
        while (it.hasNext()) {
            SurplusEntity t = (SurplusEntity)((Object)it.next());
            String key = t.getMaterialId() + "@" + t.getBrandId();
            List<SurplusVO> surplusVOS = newSurplusVOMap.get(key);
            if (CollectionUtils.isNotEmpty(surplusVOS)) {
                SurplusVO newSurplus = surplusVOS.get(0);
                t.setOutLockNum(newSurplus.getOutLockNum());
                t.setOutLockMny(newSurplus.getOutLockMny());
                t.setOutLockTaxMny(newSurplus.getOutLockTaxMny());
                t.setSurplusMny(newSurplus.getSurplusMny());
                t.setSurplusTaxMny(newSurplus.getSurplusTaxMny());
                t.setSurplusNum(newSurplus.getSurplusNum());
                t.setInstoreMny(newSurplus.getInstoreMny());
                t.setInstoreTaxMny(newSurplus.getInstoreTaxMny());
                t.setInstoreNum(newSurplus.getInstoreNum());
                t.setReturnGoodsNum(newSurplus.getReturnGoodsNum());
                continue;
            }
            delIds.add(t.getId());
            it.remove();
        }
        if (updateFlag) {
            this.surplusService.saveOrUpdateBatch(oldList);
            if (CollectionUtils.isNotEmpty(delIds)) {
                this.surplusService.removeByIds(delIds);
            }
        }
        List oldSurplusList = BeanMapper.mapList((Iterable)oldList, SurplusVO.class);
        return oldSurplusList;
    }

    @Override
    public StoreManageVO updateShareMny(StoreManageVO storeManageVO) {
        Long storeId = storeManageVO.getStoreId();
        List flowVOList = storeManageVO.getFlowVOList();
        if (CollectionUtils.isNotEmpty((Collection)flowVOList)) {
            Map<Long, List<FlowVO>> inFlowMap = flowVOList.stream().collect(Collectors.groupingBy(FlowVO::getSourceDetailId));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"store_id", (Object)storeId);
            queryWrapper.in((Object)"source_detail_id", new ArrayList<Long>(inFlowMap.keySet()));
            List list = this.list((Wrapper)queryWrapper);
            list.forEach(t -> {
                List flowVOS = (List)inFlowMap.get(t.getSourceDetailId());
                FlowVO flowVO = (FlowVO)flowVOS.get(0);
                BigDecimal shareMny = flowVO.getShareMny();
                BigDecimal shareTaxMny = flowVO.getShareTaxMny();
                Date lastShareDate = flowVO.getLastShareDate();
                t.setLastShareDate(lastShareDate);
                if (storeManageVO.getOutEffectiveON().booleanValue()) {
                    t.setShareMny(ComputeUtil.safeAdd((BigDecimal)t.getShareMny(), (BigDecimal)shareMny));
                    t.setShareTaxMny(ComputeUtil.safeAdd((BigDecimal)t.getShareTaxMny(), (BigDecimal)shareTaxMny));
                    t.setNetMny(ComputeUtil.safeSub((BigDecimal)t.getNetMny(), (BigDecimal)shareMny));
                    t.setNetTaxMny(ComputeUtil.safeSub((BigDecimal)t.getNetTaxMny(), (BigDecimal)shareTaxMny));
                } else {
                    t.setShareMny(ComputeUtil.safeSub((BigDecimal)t.getShareMny(), (BigDecimal)shareMny));
                    t.setShareTaxMny(ComputeUtil.safeSub((BigDecimal)t.getShareTaxMny(), (BigDecimal)shareTaxMny));
                    t.setNetMny(ComputeUtil.safeAdd((BigDecimal)t.getNetMny(), (BigDecimal)shareMny));
                    t.setNetTaxMny(ComputeUtil.safeAdd((BigDecimal)t.getNetTaxMny(), (BigDecimal)shareTaxMny));
                }
            });
            this.saveOrUpdateBatch(list);
            List flowVOS = BeanMapper.mapList((Iterable)list, FlowVO.class);
            storeManageVO.setFlowVOList(flowVOS);
        }
        return storeManageVO;
    }

    @Override
    public CommonResponse<JSONObject> validateTurnIsUseOutFlag(Long sourceId, Long storeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        queryWrapper.and(wrapper -> (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.in((Object)"out_use_flag", Arrays.asList(StoreCommonConsts.UseOutFlag.USEING, StoreCommonConsts.UseOutFlag.USE_FINISH))).or()).gt((Object)"share_tax_mny", (Object)BigDecimal.ZERO));
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            FlowEntity flowEntity = (FlowEntity)((Object)list.get(0));
            return CommonResponse.error((String)("\u6750\u6599[\u540d\u79f0:" + flowEntity.getMaterialName() + ",\u89c4\u683c:" + StrUtil.emptyToDefault((CharSequence)flowEntity.getMaterialSpec(), (String)"\u65e0") + "]\u5df2\u51fa\u5e93\u6216\u644a\u9500,\u4e0d\u5141\u8bb8\u64a4\u56de!"));
        }
        queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        queryWrapper.eq((Object)"in_out_flag", (Object)StoreCommonConsts.ONE);
        queryWrapper.eq((Object)"account_flag", (Object)StoreCommonConsts.ONE);
        list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u5165\u5e93\u5355\u636e\u5df2\u5bf9\u8d26,\u4e0d\u5141\u8bb8\u64a4\u56de!");
        }
        queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        queryWrapper.eq((Object)"in_out_flag", (Object)StoreCommonConsts.ONE);
        queryWrapper.eq((Object)"settle_flag", (Object)StoreCommonConsts.ONE);
        list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u5165\u5e93\u5355\u636e\u5df2\u7ed3\u7b97,\u4e0d\u5141\u8bb8\u64a4\u56de!");
        }
        return CommonResponse.success();
    }

    @Override
    public List<StoreApiVO> queryStoreInstoreData(Page<StoreApiVO> page, QueryWrapper wrapper) {
        return ((FlowMapper)this.baseMapper).queryStoreInstoreData(page, wrapper);
    }

    @Override
    public List<FlowVO> queryTurnInstoreFlowData(Page<FlowVO> page, QueryWrapper wrapper) {
        return ((FlowMapper)this.baseMapper).queryTurnInstoreFlowData(page, wrapper);
    }

    @Override
    public Integer settleCount(HashMap<String, Object> map) {
        return ((FlowMapper)this.baseMapper).settleCount(map);
    }

    @Override
    public void changeSettleFlag(HashMap<String, Object> map) {
        ((FlowMapper)this.baseMapper).changeSettleFlag(map);
    }

    @Override
    public List<SurplusVO> computeStoreList(Page<SurplusVO> page, QueryWrapper wrapper) {
        return ((FlowMapper)this.baseMapper).computeStoreList(page, wrapper);
    }

    @Override
    public List<MaterialCategoryTopVO> queryMaterialCategoryTopN(Integer topN, String dateIn, List<Long> orgIdList) {
        List<MaterialCategoryTopVO> topNList;
        String startDate = null;
        if ("thisYear".equals(dateIn)) {
            startDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateUtil.beginOfYear((Date)new Date()));
        }
        if (CollectionUtils.isNotEmpty(topNList = ((FlowMapper)this.baseMapper).queryMaterialCategoryTopN(topN, startDate, orgIdList))) {
            List<MaterialCategoryTopVO> sumMaterialCategory = ((FlowMapper)this.baseMapper).getSumMaterialCategory(startDate, orgIdList);
            MaterialCategoryTopVO sumVO = sumMaterialCategory.get(0);
            BigDecimal otherNum = sumVO.getNum();
            BigDecimal otherAmount = sumVO.getAmount();
            BigDecimal totalAmount = sumVO.getAmount();
            for (MaterialCategoryTopVO t : topNList) {
                otherNum = ComputeUtil.safeSub((BigDecimal)otherNum, (BigDecimal)t.getNum());
                otherAmount = ComputeUtil.safeSub((BigDecimal)otherAmount, (BigDecimal)t.getAmount());
                t.setWeight(ComputeUtil.bigDecimalPercent((BigDecimal)t.getAmount(), (BigDecimal)totalAmount, (int)2));
            }
            if (ComputeUtil.isNotEmpty((BigDecimal)otherAmount).booleanValue()) {
                MaterialCategoryTopVO otherTopVO = new MaterialCategoryTopVO();
                otherTopVO.setMaterialCategoryName("\u5176\u4ed6");
                otherTopVO.setNum(otherNum);
                otherTopVO.setAmount(otherAmount);
                otherTopVO.setWeight(ComputeUtil.bigDecimalPercent((BigDecimal)otherTopVO.getAmount(), (BigDecimal)totalAmount, (int)2));
                topNList.add(otherTopVO);
            }
        }
        return topNList;
    }

    @Override
    public List<FlowVO> getSendReceiveList(Page<FlowVO> page, QueryWrapper wrapper) {
        return ((FlowMapper)this.baseMapper).getSendReceiveList(page, wrapper);
    }

    @Override
    public List<FlowVO> queryFlowBatch(List<FlowVO> vos) {
        QueryParam param = new QueryParam();
        param.setPageSize(-1);
        param.setPageIndex(0);
        QueryWrapper wrapper = FlowServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.and(q -> {
            for (FlowVO f : vos) {
                q.or(iq -> (QueryWrapper)((QueryWrapper)((QueryWrapper)iq.eq((Object)"store_id", (Object)f.getStoreId())).eq((Object)"brand_id", (Object)f.getBrandId())).eq((Object)"material_id", (Object)f.getMaterialId()));
            }
            return q;
        });
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<FlowVO> list = ((FlowMapper)this.baseMapper).queryInstoreFlowData((IPage<FlowVO>)page, wrapper);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.and(q -> {
            for (FlowVO f : list) {
                q.or(iq -> (QueryWrapper)((QueryWrapper)((QueryWrapper)iq.eq((Object)"store_id", (Object)f.getStoreId())).eq((Object)"brand_id", (Object)f.getBrandId())).eq((Object)"material_id", (Object)f.getMaterialId()));
            }
            return q;
        });
        Map<Object, Object> surplusNumMap = new HashMap();
        List surplusEntityList = this.surplusService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)surplusEntityList)) {
            surplusNumMap = surplusEntityList.stream().collect(Collectors.toMap(k -> k.getStoreId() + "@" + k.getMaterialId() + "@" + k.getBrandId(), Function.identity(), (key1, key2) -> key1));
        }
        for (FlowVO item : list) {
            String key = item.getStoreId() + "@" + item.getMaterialId() + "@" + item.getBrandId();
            item.setPrice(ComputeUtil.safeDiv((BigDecimal)item.getSurplusMny(), (BigDecimal)item.getStockNum()));
            item.setTaxPrice(ComputeUtil.safeDiv((BigDecimal)item.getSurplusTaxMny(), (BigDecimal)item.getStockNum()));
            if (surplusNumMap.containsKey(key)) {
                item.setSurplusNum(ComputeUtil.safeSub((BigDecimal)item.getSurplusNum(), (BigDecimal)((SurplusEntity)((Object)surplusNumMap.get(key))).getIdleNum()));
            }
            item.getSurplusNum().setScale(4, 0);
            item.getNum().setScale(4, 0);
        }
        return BeanMapper.mapList(list, FlowVO.class);
    }
}

