package com.ejianc.business.zdsstore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.zdsstore.bean.HandleDetailEntity;
import com.ejianc.business.zdsstore.bean.HandleEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.service.ICheckService;
import com.ejianc.business.zdsstore.service.IHandleService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Service("handle") 
public class HandleBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
	private ICheckService checkService;

	@Autowired
	private IHandleService handleService;

	@Autowired
	private StoreManageService storeManageService;

//	@Autowired
//	private ICostDetailApi costDetailApi;
	@Autowired
	private IBillTypeApi billTypeApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ArrayList<Long> longs = new ArrayList<>();
		longs.add(billId);
		handleService.handleInOut(longs,true);
//		logger.info("推送成本---");
//		HandleEntity entity = handleService.selectById(billId);
//		handleService.costPush(entity);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO 弃审 校验是否被成本归集引用 引用则不能
		HandleEntity handleEntity = handleService.selectById(billId);
		CommonResponse<String> checkCommonResponse = billTypeApi.checkQuote(billTypeCode, handleEntity.getId());
		boolean success = checkCommonResponse.isSuccess();
		if (!success){
			return CommonResponse.error("已经被归集单使用,不能弃审和撤回");
		}

		if(handleEntity != null){
			CommonResponse commonResponse = checkService.checkByDate(handleEntity.getStoreId(), DateFormatUtil.formatDate("yyyy-MM-dd", handleEntity.getHandleDate()));
			return commonResponse;
		}
		StoreManageVO storeManageVO = new StoreManageVO();
		List<Long> SourceIds = new ArrayList<>();
		HandleEntity entity = handleService.selectById(billId);
		List<HandleDetailEntity> handleSubList = entity.getHandleSubList();
		Boolean checkFlag = false;
		for (HandleDetailEntity item: handleSubList
		) {
			if(item.getHandleNum().compareTo(BigDecimal.ZERO) > 0){
				checkFlag = true;
				break;
			}
		}
		if(checkFlag){
			SourceIds.add(billId);
			storeManageVO.setSourceId(billId);
			storeManageVO.setStoreId(entity.getStoreId());
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.材料处置);
			storeManageVO.setSourceIdsForRollBack(SourceIds);
			storeManageVO.setOutEffectiveON(true);
			CommonResponse<StoreManageVO> storeManageVOCommonResponse = storeManageService.inOutStoreRollback(storeManageVO);
			if(!storeManageVOCommonResponse.isSuccess()) {
				return CommonResponse.error(storeManageVOCommonResponse.getMsg());
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/

//		HandleEntity handleEntity = handleService.selectById(billId);
//		logger.info("弃审推送成本---");
//		logger.info("删除成本中心之前的数据-处置Id---{}",handleEntity.getId());
//		CommonResponse<String> stringCommonResponse = costDetailApi.updateCostDetail(handleEntity.getId(),0);
//		logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
//		if(!stringCommonResponse.isSuccess()){
//			throw new BusinessException(stringCommonResponse.getMsg());
//		}
//		//更新是否关联
//		LambdaUpdateWrapper<HandleEntity> updateWrapper = new LambdaUpdateWrapper<>();
//		updateWrapper.in(HandleEntity::getId, handleEntity.getId());
//		updateWrapper.set(HandleEntity::getRelationFlag, 0);//(1:是，0：否)
//		handleService.update(updateWrapper);

		return CommonResponse.success();
	}

}
