package com.ejianc.business.zdsstore.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.zdsstore.bean.PickReturnEntity;
import com.ejianc.business.zdsstore.enums.ProsubSignStatusEnum;
import com.ejianc.business.zdsstore.service.IPickReturnService;
import com.ejianc.business.zdsstore.vo.PickReturnDetailVO;
import com.ejianc.business.zdsstore.vo.PickReturnExportVO;
import com.ejianc.business.zdsstore.vo.PickReturnVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 材料退库表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("pickReturn")
public class PickReturnController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICostDetailApi costDetailApi;

    private static final String BILL_CODE = "zds_PICK_RETURN_CODE";//此处需要根据实际修改
    private static final String BILL_TYPE_CODE = "EJCBT202312000017";//单价类型编码规则

    @Autowired
    private IPickReturnService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PickReturnVO> saveOrUpdate(@RequestBody PickReturnVO saveOrUpdateVO) {
        PickReturnVO pickReturnVO = service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！",pickReturnVO);
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PickReturnVO> queryDetail(Long id) {
    	PickReturnEntity entity = service.selectById(id);
    	PickReturnVO vo = BeanMapper.map(entity, PickReturnVO.class);
        List<PickReturnDetailVO> subDetailList = vo.getPickReturnDetailList().stream().filter(e->e.getSourType()!=null&&ProsubSignStatusEnum.供方申请.getCode().equals(e.getSourType())).collect(Collectors.toList());
        List<PickReturnDetailVO> detailList = vo.getPickReturnDetailList().stream().filter(e->e.getSourType()!=null&&!ProsubSignStatusEnum.供方申请.getCode().equals(e.getSourType())).collect(Collectors.toList());
        vo.setPickSubReturnDetailList(subDetailList);
        vo.setPickReturnDetailList(detailList);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PickReturnVO> vos) {
        service.removeByPickReturnIds(vos.stream().map(PickReturnVO::getId).collect(Collectors.toList()));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PickReturnVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("subOrgName");
        fuzzyFields.add("materialNames");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(orgId);
        if(!orgResp.isSuccess()) {
            logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
            return CommonResponse.error("查询失败，获取组织信息失败！");
        }
        List<Long> orgIdList = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));

        IPage<PickReturnEntity> page = service.queryPage(param,false);
        IPage<PickReturnVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PickReturnVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PickReturnEntity> list = service.queryList(param);
        List<PickReturnExportVO> exportVOS = new ArrayList<>();
        list.forEach(vo->{
            PickReturnExportVO exportVO = BeanMapper.map(vo,PickReturnExportVO.class);
            exportVO.setBillState(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            exportVO.setCreateTime(DateFormatUtil.formatDate("yyyy-MM-dd",vo.getCreateTime()));
            exportVO.setInstoreDate(DateFormatUtil.formatDate("yyyy-MM-dd",vo.getInstoreDate()));
            exportVO.setSignStatus(ProsubSignStatusEnum.未签字.getCode().equals(vo.getSignStatus())?"已签字":"");
            if (ProsubSignStatusEnum.已确认.getCode().equals(vo.getSignStatus())){
                exportVO.setConfirmStatus("已确认");
            }else if (ProsubSignStatusEnum.已驳回.getCode().equals(vo.getSignStatus())){
                exportVO.setConfirmStatus("已驳回");
            }else if (ProsubSignStatusEnum.待确认.getCode().equals(vo.getSignStatus())){
                exportVO.setConfirmStatus("待确认");
            }
            exportVOS.add(exportVO);
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("pickReturnListExport.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refPickReturnData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PickReturnVO>> refPickReturnData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PickReturnEntity> page = service.queryPage(param,false);
        IPage<PickReturnVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PickReturnVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @GetMapping(value = "/pickReturnCheck")
    @ResponseBody
    public CommonResponse<String> pickReturnCheck(@RequestParam(value = "contractId") Long contractId,
                                                  @RequestParam(value = "billId", required = false) Long billId){
        QueryWrapper<PickReturnEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);
        query.eq("bill_state",BillStateEnum.UNCOMMITED_STATE);
        query.eq("dr", BaseVO.DR_UNDELETE);
        PickReturnEntity one = service.getOne(query);
        if(one!=null && (null == billId || !one.getId().equals(billId))){
            return CommonResponse.error("该合同下已存在未生效单据！");
        }
        return CommonResponse.success("该合同适用当前单据！");
    }

    /**
     * 接口推送接口
     * 接受 推送 确认 驳回
     * @param request
     * @return
     */
    @PostMapping(value = "syncPickReturnBill")
    public CommonResponse<String> syncPickReturnBill(HttpServletRequest request) {
        return service.syncPickReturn(request);
    }

    /**
     * 供方测回删除
     * @param request
     * @return
     */
    @PostMapping(value = "/billDel")
    public CommonResponse<String> billDel(HttpServletRequest request) {
        String sourceId = request.getParameter("sourceId");
        PickReturnEntity delivery = service.getBySourceId(sourceId);
        String msg = service.billDel(delivery);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("操作成功！");
    }


    /**
     * @Description pushStatus  确认或者驳回
     */
    @RequestMapping(value = "/pushStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PickReturnVO> pushStatus(@RequestBody PickReturnVO saveOrUpdateVO) {
        PickReturnVO returnVO = service.pushStatus(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！",returnVO);
    }
}
