package com.ejianc.business.zdsstore.bean;

import java.util.Date;
import java.math.*;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 材料退库明细表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_store_pick_return_detail")
public class PickReturnDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="store_id")
    private Long storeId; // 仓库id（冗余主表仓库仓库id，便于出库查询计算）
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value="instore_id")
    private Long instoreId; // 主表id
    @TableField(value="instore_code")
    private String instoreCode; // 入库编号
    @TableField(value="instore_bill_id")
    private Long instoreBillId; // 入库单id（用于穿透）
    @TableField(value="outstore_code")
    private String outstoreCode; // 出库编号
    @TableField(value="outstore_bill_id")
    private Long outstoreBillId; // 出库单id（用于穿透）
    @TableField(value="outstore_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outstoreDate; // 出库时间（出库单）
    @TableField(value="instore_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date instoreDate; // 入库日期（冗余主表入库日期，便于出库查询计算）
    @TableField(value="material_category_id")
    private Long materialCategoryId; // 物资分类id
    @TableField(value="material_category_name")
    private String materialCategoryName; // 物资分类名称
    @TableField(value="material_category_code")
    private String materialCategoryCode; // 物资分类名称
    @TableField(value="material_id")
    private Long materialId; // 物资id
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="surplus_num")
    private BigDecimal surplusNum; // 剩余可退数量
    @TableField(value="return_num")
    private BigDecimal returnNum; // 退库数量
    @TableField(value="material_spec")
    private String materialSpec; // 规格型号
    @TableField(value="material_unit_id")
    private Long materialUnitId; // 计量单位
    @TableField(value="material_unit_name")
    private String materialUnitName; // 计量单位名称
    @TableField(value="price")
    private BigDecimal price; // 单价
    @TableField(value="mny")
    private BigDecimal mny; // 金额
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="tax_price")
    private BigDecimal taxPrice; // 单价(含税)
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 金额(含税)
    @TableField(value="tax")
    private BigDecimal tax; // 税额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="in_out_id")
    private Long inOutId; //出入库关系id

    @TableField(value="wbs_id")
    private Long wbsId; // 核算对象id
    @TableField(value="wbs_code")
    private String wbsCode; // 核算对象code
    @TableField(value="wbs_name")
    private String wbsName; // 核算对象name
    @TableField(value="subject_id")
    private Long subjectId; // 成本科目id
    @TableField(value="subject_code")
    private String subjectCode; // 成本科目code
    @TableField(value="subject_name")
    private String subjectName; // 成本科目name

    @TableField(value="attr_flag")
    private Integer attrFlag; // 出库单物资的仓库属性 1-自购材；2-甲供材
    @TableField(value="attr_flag_name")
    private String attrFlagName; //仓库属性名称



    @TableField(value="brand_id")
    private Long brandId; //品牌主键
    @TableField(value="brand_name")
    private String brandName; // 品牌
    @TableField(value = "product_code")
    private String productCode; // 产品代码
    @TableField(value = "material_code")
    private String materialCode; // 产品代码


    @TableField(value="source_id")
    private Long sourceId;//来源id

    @TableField(value = "source_Type")
    private Integer sourType;//来源类型 1：供方推送 2：供方推送生成

    public Integer getSourType() {
        return sourType;
    }

    public void setSourType(Integer sourType) {
        this.sourType = sourType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getMaterialCategoryCode() {
        return materialCategoryCode;
    }

    public void setMaterialCategoryCode(String materialCategoryCode) {
        this.materialCategoryCode = materialCategoryCode;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Long getInstoreId() {
        return instoreId;
    }

    public void setInstoreId(Long instoreId) {
        this.instoreId = instoreId;
    }
    public String getInstoreCode() {
        return instoreCode;
    }

    public void setInstoreCode(String instoreCode) {
        this.instoreCode = instoreCode;
    }
    public Long getInstoreBillId() {
        return instoreBillId;
    }

    public void setInstoreBillId(Long instoreBillId) {
        this.instoreBillId = instoreBillId;
    }
    public String getOutstoreCode() {
        return outstoreCode;
    }

    public void setOutstoreCode(String outstoreCode) {
        this.outstoreCode = outstoreCode;
    }
    public Long getOutstoreBillId() {
        return outstoreBillId;
    }

    public void setOutstoreBillId(Long outstoreBillId) {
        this.outstoreBillId = outstoreBillId;
    }
    public Date getOutstoreDate() {
        return outstoreDate;
    }

    public void setOutstoreDate(Date outstoreDate) {
        this.outstoreDate = outstoreDate;
    }
    public Date getInstoreDate() {
        return instoreDate;
    }

    public void setInstoreDate(Date instoreDate) {
        this.instoreDate = instoreDate;
    }
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public BigDecimal getSurplusNum() {
        return surplusNum;
    }

    public void setSurplusNum(BigDecimal surplusNum) {
        this.surplusNum = surplusNum;
    }
    public BigDecimal getReturnNum() {
        return returnNum;
    }

    public void setReturnNum(BigDecimal returnNum) {
        this.returnNum = returnNum;
    }
    public String getMaterialSpec() {
        return materialSpec;
    }

    public void setMaterialSpec(String materialSpec) {
        this.materialSpec = materialSpec;
    }
    public Long getMaterialUnitId() {
        return materialUnitId;
    }

    public void setMaterialUnitId(Long materialUnitId) {
        this.materialUnitId = materialUnitId;
    }
    public String getMaterialUnitName() {
        return materialUnitName;
    }

    public void setMaterialUnitName(String materialUnitName) {
        this.materialUnitName = materialUnitName;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getInOutId() {
        return inOutId;
    }

    public void setInOutId(Long inOutId) {
        this.inOutId = inOutId;
    }

    public Long getWbsId() {
        return wbsId;
    }

    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Integer getAttrFlag() {
        return attrFlag;
    }

    public void setAttrFlag(Integer attrFlag) {
        this.attrFlag = attrFlag;
    }

    public String getAttrFlagName() {
        return attrFlagName;
    }

    public void setAttrFlagName(String attrFlagName) {
        this.attrFlagName = attrFlagName;
    }
}
