/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.zdsstore.bean.HandleDetailEntity;
import com.ejianc.business.zdsstore.bean.HandleEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.mapper.HandleDetailMapper;
import com.ejianc.business.zdsstore.mapper.HandleMapper;
import com.ejianc.business.zdsstore.service.IHandleService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="handleService")
public class HandleServiceImpl
extends BaseServiceImpl<HandleMapper, HandleEntity>
implements IHandleService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private HandleDetailMapper handleDetailMapper;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExecutionApi executionApi;

    @Override
    public CommonResponse saveCheckHandle(HandleEntity entity) {
        if (null != entity.getId()) {
            this.handleDetailMapper.delByHandleId(entity.getId());
        }
        ArrayList<HandleDetailEntity> subList = new ArrayList<HandleDetailEntity>();
        List<HandleDetailEntity> handleSubList = entity.getHandleSubList();
        String names = "";
        for (HandleDetailEntity detailEntity : handleSubList) {
            if (detailEntity.getHandleNum() != null && detailEntity.getHandleNum().compareTo(BigDecimal.ZERO) > 0) {
                subList.add(detailEntity);
            }
            names = names + detailEntity.getMaterialCategoryName() + ",";
        }
        if (handleSubList.size() > 0) {
            names = names.substring(0, names.length() - 1);
        }
        entity.setMaterialTypes(names);
        super.saveOrUpdate((Object)entity, false);
        if (subList.size() > 0) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6750\u6599\u5904\u7f6e);
            ArrayList flowVOS = new ArrayList();
            subList.forEach(item -> {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u6750\u6599\u5904\u7f6e, (Integer)0);
                flowVO.setSourceBillTypeName("\u5904\u7f6e\u51fa\u5e93");
                flowVO.setSourceBillTypeCode("BT220125000000010");
                flowVO.setSourceType(StoreCommonConsts.ZERO);
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(item.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(item.getMaterialCategoryName());
                flowVO.setMaterialId(item.getMaterialId());
                flowVO.setMaterialName(item.getMaterialName());
                flowVO.setMaterialSpec(item.getSpec());
                flowVO.setNum(item.getHandleNum());
                flowVO.setTaxPrice(item.getHandlePrice());
                flowVO.setTaxMny(item.getHandleMny());
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(item.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getHandleDate());
                flowVOS.add(flowVO);
            });
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> commonResponse = this.storeManageService.inOutStore(storeManageVO);
            if (!commonResponse.isSuccess()) {
                return commonResponse;
            }
        }
        return CommonResponse.success((Object)((Object)entity));
    }

    @Override
    public CommonResponse myRemoveByIds(List<Long> ids) {
        CommonResponse commonResponse = this.handleInOut(ids, false);
        if (!commonResponse.isSuccess()) {
            return commonResponse;
        }
        super.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse handleInOut(List<Long> ids, Boolean outEffectiveON) {
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        for (Long item : ids) {
            HandleEntity entity = (HandleEntity)((Object)super.selectById((Serializable)item));
            List<HandleDetailEntity> handleSubList = entity.getHandleSubList();
            Boolean checkFlag = false;
            for (HandleDetailEntity t : handleSubList) {
                if (t.getHandleNum().compareTo(BigDecimal.ZERO) <= 0) continue;
                checkFlag = true;
                break;
            }
            if (!checkFlag.booleanValue()) continue;
            SourceIds.clear();
            SourceIds.add(item);
            storeManageVO.setSourceId(item);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6750\u6599\u5904\u7f6e);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setOutEffectiveON(outEffectiveON);
            CommonResponse<StoreManageVO> commonResponse = outEffectiveON != false ? this.storeManageService.inOutStore(storeManageVO) : this.storeManageService.inOutStoreRollback(storeManageVO);
            if (commonResponse.isSuccess()) continue;
            return commonResponse;
        }
        return CommonResponse.success();
    }
}

