package com.ejianc.business.zdsstore.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.vo.OrderVO;
import com.ejianc.business.zdsstore.bean.ReturnGoodsEntity;
import com.ejianc.business.zdsstore.service.IReturnGoodsService;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.vo.ReturnGoodsDetailVO;
import com.ejianc.business.zdsstore.vo.ReturnGoodsExportVO;
import com.ejianc.business.zdsstore.vo.ReturnGoodsVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 材料退货表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("returnGoods")
public class ReturnGoodsController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZDS_RG_01";

    @Autowired
    private IReturnGoodsService service;

    @Autowired
    private ISurplusService surplusService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReturnGoodsVO> saveOrUpdate(@RequestBody ReturnGoodsVO saveOrUpdateVO) {
    	if(saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                saveOrUpdateVO.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //校验合同是否存在未生效单据
        ReturnGoodsVO voByContract = service.queryByContractId(saveOrUpdateVO.getContractId());
        if(null != voByContract && (null == saveOrUpdateVO.getId() || !voByContract.getId().equals(saveOrUpdateVO.getId()))) {
            return CommonResponse.error("保存失败，该合同下存在未生效单据，请勿重复添加！");
        }
        ReturnGoodsVO vo = service.saveOrUpdateReturnGoods(saveOrUpdateVO);
    	return queryDetail(vo.getId());
    }
    @PostMapping(value = "/syncSignStatus")
    public CommonResponse<String> syncSignStatus(HttpServletRequest request) {



        service.syncSignStatus(request);
        return CommonResponse.success("订单信息同步成功！");
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReturnGoodsVO> queryDetail(Long id) {
    	ReturnGoodsEntity entity = service.selectById(id);
    	ReturnGoodsVO vo = BeanMapper.map(entity, ReturnGoodsVO.class);

        //查询库存均价
    	if(CollectionUtils.isNotEmpty(vo.getReturnGoodsDetailList())) {
            List<SurplusVO> query = new ArrayList<>();
            vo.getReturnGoodsDetailList().stream().forEach(item -> {
                SurplusVO f = new SurplusVO();
                f.setStoreId(vo.getStoreId());
                f.setMaterialId(item.getMaterialId());
                f.setBrandId(item.getBrandId());
                query.add(f);
            });


            List<SurplusVO> rs = surplusService.querySurplusBatch(query);
            Map<String, SurplusVO> rsMap = rs.stream().collect(Collectors.toMap(item ->
                    item.getStoreId().toString() + item.getMaterialId().toString() + item.getBrandId().toString(), item -> item));
            SurplusVO tmp = null;
            for(ReturnGoodsDetailVO item : vo.getReturnGoodsDetailList()) {
                tmp = rsMap.get(vo.getStoreId().toString() + item.getMaterialId().toString() + item.getBrandId().toString());
                if(null != tmp) {
                    item.setInstorePrice(tmp.getSurplusPrice());
                    item.setInstoreTaxPrice(tmp.getSurplusTaxPrice());
                }
            }
        }

        return CommonResponse.success("操作成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReturnGoodsVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ReturnGoodsVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByPickReturnIds(vos.stream().map(ReturnGoodsVO::getId).collect(Collectors.toList()));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReturnGoodsVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialNames");
        fuzzyFields.add("storeName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(orgId);
        if(!orgResp.isSuccess()) {
            logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
            return CommonResponse.error("查询失败，获取组织信息失败！");
        }
        List<Long> orgIdList = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));

        IPage<ReturnGoodsEntity> page = service.queryPage(param,false);
        IPage<ReturnGoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReturnGoodsVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ReturnGoodsEntity> list = service.queryList(param);
        List<ReturnGoodsExportVO> exportVOS = new ArrayList<>();
        list.forEach(vo->{
            ReturnGoodsExportVO exportVO = BeanMapper.map(vo,ReturnGoodsExportVO.class);
            exportVO.setBillState(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            exportVO.setOutDate(DateFormatUtil.formatDate("yyyy-MM-dd",vo.getOutDate()));
            if (exportVO.getSignStatus() == 1){
                exportVO.setSignStatusName("未签字");
            }
            if (exportVO.getSignStatus() == 2){
                exportVO.setSignStatusName("已签字");
            }
            exportVOS.add(exportVO);
        });

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("returnGoodsListExport.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refReturnGoodsData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ReturnGoodsVO>> refReturnGoodsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ReturnGoodsEntity> page = service.queryPage(param,false);
        IPage<ReturnGoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReturnGoodsVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @GetMapping(value = "/returnGoodsCheck")
    @ResponseBody
    public CommonResponse<String> returnGoodsCheck(@RequestParam(value = "contractId") Long contractId,
                                                   @RequestParam(value = "billId", required = false) Long billId){
        QueryWrapper<ReturnGoodsEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);
        query.eq("bill_state",BillStateEnum.UNCOMMITED_STATE);
        query.eq("dr", BaseVO.DR_UNDELETE);
        ReturnGoodsEntity one = service.getOne(query);
        if(one!=null && (null == billId || !one.getId().equals(billId))){
            return CommonResponse.error("该合同下已存在未生效单据！");
        }
        return CommonResponse.success("该合同适用当前单据！");
    }
}
