/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.zdsstore.bean.StoreEntity;
import com.ejianc.business.zdsstore.consts.StoreAttrEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.mapper.StoreMapper;
import com.ejianc.business.zdsstore.service.IStoreService;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdsstore.vo.StoreVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="storeService")
public class StoreServiceImpl
extends BaseServiceImpl<StoreMapper, StoreEntity>
implements IStoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private StoreMapper storeMapper;
    @Autowired
    private ISurplusService surplusService;
    private final String OPERATE = "storeBill";
    @Autowired
    private JedisPool jedisPool;

    @Override
    public List<StoreEntity> queryStoreList(QueryParam param) {
        QueryWrapper wrapper = StoreServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.eq((Object)"s.dr", (Object)StoreCommonConsts.NO);
        wrapper.groupBy(new Object[]{"s.id"});
        return this.storeMapper.queryStoreList(wrapper);
    }

    @Override
    public StoreManageVO setStoreAttr(StoreManageVO storeManageVO) {
        Long storeId = storeManageVO.getStoreId();
        StoreEntity storeEntity = (StoreEntity)((Object)this.storeMapper.selectById(storeId));
        String storeType = storeEntity.getAttrFlag().toString();
        String storeTypeName = StoreAttrEnum.getDescriptionByCode((String)storeEntity.getAttrFlag().toString());
        List flowVOList = storeManageVO.getFlowVOList();
        if (CollectionUtils.isNotEmpty((Collection)flowVOList)) {
            for (FlowVO flowVO : flowVOList) {
                flowVO.setStoreType(storeType);
                flowVO.setStoreTypeName(storeTypeName);
            }
        }
        storeManageVO.setFlowVOList(flowVOList);
        List straightOutFlowVOList = storeManageVO.getStraightOutFlowVOList();
        if (CollectionUtils.isNotEmpty((Collection)straightOutFlowVOList)) {
            for (FlowVO straightOut : straightOutFlowVOList) {
                straightOut.setStoreType(storeType);
                straightOut.setStoreTypeName(storeTypeName);
            }
        }
        return storeManageVO;
    }

    @Override
    public CommonResponse<String> checkStoreMaterialList(Long id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"store_id", (Object)id);
        queryWrapper.gt((Object)"surplus_num", (Object)0);
        List list = this.surplusService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u4ed3\u5e93\u6709\u7269\u8d44");
        }
        return CommonResponse.success();
    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }

    @Override
    public StoreEntity autoByProjectId(Long projectId, Integer attrFlag) {
        Object msg = null;
        Jedis jedis = null;
        boolean locked = false;
        StoreEntity storeEntity = null;
        String key = "storeBill::" + projectId.toString();
        try {
            jedis = this.jedisPool.getResource();
            this.autoBuid(projectId, null);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"project_id", (Object)projectId);
            queryWrapper.eq((Object)"attr_flag", (Object)attrFlag);
            queryWrapper.eq((Object)"dr", (Object)StoreCommonConsts.NO);
            List storeEntities = this.list((Wrapper)queryWrapper);
            if (!storeEntities.isEmpty()) {
                storeEntity = (StoreEntity)((Object)storeEntities.get(0));
            }
        }
        catch (Exception e) {
            this.logger.error("\u9879\u76eeid-{}\u67e5\u8be2\u5bf9\u5e94\u9879\u76ee\u4ed3\u5e93\u5931\u8d25\uff0c", (Object)projectId, (Object)e);
            throw new BusinessException("\u67e5\u8be2\u5bf9\u5e94\u9879\u76ee\u4ed3\u5e93\u5931\u8d25");
        }
        finally {
            this.releaseLock(jedis, locked, key, "storeBill");
        }
        return storeEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public void autoBuid(Long projectId, Long parentOrgId) {
        if (null != projectId) {
            CommonResponse projectResponse = this.projectPoolApi.queryDetailById(projectId);
            if (!projectResponse.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25, {}", (Object)projectResponse.getMsg());
                throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25 \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            ProjectVO project = (ProjectVO)projectResponse.getData();
            CommonResponse orgResponse = this.iOrgApi.getOneById(project.getOrgId());
            if (!orgResponse.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f, {}", (Object)orgResponse.getMsg());
                throw new BusinessException("\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25 \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(StoreEntity::getProjectId, (Object)projectId);
            List entities = this.list((Wrapper)wrapper);
            if (CollectionUtils.isEmpty((Collection)entities)) {
                ArrayList<StoreEntity> insertList = new ArrayList<StoreEntity>();
                insertList.add(this.buidStore(Integer.valueOf(StoreAttrEnum.\u4e3b\u6750\u5e93.getCode()), project.getProjectName() + StoreAttrEnum.\u4e3b\u6750\u5e93.getDescription(), project, orgVO));
                insertList.add(this.buidStore(Integer.valueOf(StoreAttrEnum.\u4e34\u5efa\u6750\u6599.getCode()), project.getProjectName() + StoreAttrEnum.\u4e34\u5efa\u6750\u6599.getDescription(), project, orgVO));
                insertList.add(this.buidStore(Integer.valueOf(StoreAttrEnum.\u7532\u4f9b\u6750.getCode()), project.getProjectName() + StoreAttrEnum.\u7532\u4f9b\u6750.getDescription(), project, orgVO));
                this.saveOrUpdateBatch(insertList);
            } else {
                ArrayList<StoreEntity> insertList = new ArrayList<StoreEntity>();
                Set set = entities.stream().map(StoreEntity::getAttrFlag).collect(Collectors.toSet());
                if (!set.contains(Integer.valueOf(StoreAttrEnum.\u4e3b\u6750\u5e93.getCode()))) {
                    insertList.add(this.buidStore(Integer.valueOf(StoreAttrEnum.\u4e3b\u6750\u5e93.getCode()), project.getProjectName() + StoreAttrEnum.\u4e3b\u6750\u5e93.getDescription(), project, orgVO));
                }
                if (!set.contains(Integer.valueOf(StoreAttrEnum.\u4e34\u5efa\u6750\u6599.getCode()))) {
                    insertList.add(this.buidStore(Integer.valueOf(StoreAttrEnum.\u4e34\u5efa\u6750\u6599.getCode()), project.getProjectName() + StoreAttrEnum.\u4e34\u5efa\u6750\u6599.getDescription(), project, orgVO));
                }
                if (!set.contains(Integer.valueOf(StoreAttrEnum.\u7532\u4f9b\u6750.getCode()))) {
                    insertList.add(this.buidStore(Integer.valueOf(StoreAttrEnum.\u7532\u4f9b\u6750.getCode()), project.getProjectName() + StoreAttrEnum.\u7532\u4f9b\u6750.getDescription(), project, orgVO));
                }
                if (CollectionUtils.isNotEmpty(insertList)) {
                    this.saveOrUpdateBatch(insertList);
                }
            }
        }
        if (null != parentOrgId) {
            CommonResponse orgResponse = this.iOrgApi.getOneById(parentOrgId);
            if (!orgResponse.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f, {}", (Object)orgResponse.getMsg());
                throw new BusinessException("\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25 \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(StoreEntity::getParentOrgId, (Object)parentOrgId);
            wrapper.eq(StoreEntity::getAttrFlag, (Object)StoreAttrEnum.\u5b9e\u9645\u4ed3.getCode());
            if (this.count((Wrapper)wrapper) <= 0) {
                this.saveOrUpdate((Object)this.buidStore(Integer.valueOf(StoreAttrEnum.\u5b9e\u9645\u4ed3.getCode()), orgVO.getName() + StoreAttrEnum.\u5b9e\u9645\u4ed3.getDescription(), null, orgVO));
            }
        }
    }

    @Override
    public List<StoreVO> queryCloudStoreByOrg(Long orgId) {
        StoreEntity storeEntity = null;
        CommonResponse orgResponse = this.iOrgApi.getOneById(orgId);
        String[] orgArr = ((OrgVO)orgResponse.getData()).getInnerCode().split("\\|");
        for (int i = orgArr.length; i > 0; --i) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(StoreEntity::getAttrFlag, (Object)StoreAttrEnum.\u4e91\u4ed3\u5e93.getCode());
            queryWrapper.eq(StoreEntity::getState, (Object)1);
            queryWrapper.eq(StoreEntity::getParentOrgId, (Object)orgArr[i - 1]);
            storeEntity = (StoreEntity)((Object)this.getOne((Wrapper)queryWrapper, false));
            if (null != storeEntity) break;
        }
        if (null == storeEntity) {
            throw new BusinessException("\u8be5\u7ec4\u7ec7\u53ca\u5176\u4e0a\u7ea7\u672a\u5efa\u7acb\u4e91\u4ed3\u5e93\uff01");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(StoreEntity::getAttrFlag, (Object)StoreAttrEnum.\u4e91\u4ed3\u5e93.getCode());
        queryWrapper.eq(StoreEntity::getState, (Object)1);
        queryWrapper.likeRight(StoreEntity::getParentOrgInnerCode, (Object)storeEntity.getParentOrgInnerCode());
        List result = this.list((Wrapper)queryWrapper);
        return CollectionUtils.isNotEmpty((Collection)result) ? BeanMapper.mapList((Iterable)result, StoreVO.class) : null;
    }

    private StoreEntity buidStore(Integer attrFlag, String name, ProjectVO project, OrgVO orgVO) {
        StoreEntity storeEntity = new StoreEntity();
        storeEntity.setId(IdWorker.getId());
        if (null != orgVO) {
            storeEntity.setParentOrgId(orgVO.getId());
            storeEntity.setParentOrgName(orgVO.getName());
            storeEntity.setParentOrgCode(orgVO.getCode());
            storeEntity.setProjectType(StoreCommonConsts.NO);
        }
        if (null != project) {
            storeEntity.setProjectId(project.getId());
            storeEntity.setProjectName(project.getProjectName());
            storeEntity.setProjectCode(project.getBillCode());
            storeEntity.setOrgId(project.getProjectDepartmentId());
            storeEntity.setOrgName(project.getProjectName());
            storeEntity.setOrgCode(project.getBillCode());
            storeEntity.setProjectType(StoreCommonConsts.YES);
        }
        storeEntity.setState(StoreCommonConsts.YES);
        storeEntity.setAttrFlag(attrFlag);
        storeEntity.setName(name);
        storeEntity.setTotalMny(BigDecimal.ZERO);
        storeEntity.setMemo("\u81ea\u589e");
        storeEntity.setDefaultFlag(0);
        return storeEntity;
    }
}

