/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsstore.bean.FlowEntity;
import com.ejianc.business.zdsstore.bean.IdleFlowEntity;
import com.ejianc.business.zdsstore.bean.InOutEntity;
import com.ejianc.business.zdsstore.bean.SurplusEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.mapper.SurplusMapper;
import com.ejianc.business.zdsstore.service.IFlowService;
import com.ejianc.business.zdsstore.service.IIdleFlowService;
import com.ejianc.business.zdsstore.service.IInOutService;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.InOutVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdsstore.vo.SurplusUpdateVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.business.zdsstore.vo.UseCalculateVO;
import com.ejianc.business.zdsstore.vo.UseMaterialPriceVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="surplusService")
public class SurplusServiceImpl
extends BaseServiceImpl<SurplusMapper, SurplusEntity>
implements ISurplusService {
    @Autowired
    IFlowService flowService;
    @Autowired
    IInOutService inOutService;
    @Autowired
    ISurplusService surplusService;
    @Autowired
    IIdleFlowService idleFlowService;

    @Override
    public SurplusUpdateVO updateStoreSurplus(SurplusUpdateVO surplusUpdateVO, boolean updateInstoreFlag, boolean updateSurplusFlag) {
        return this.updateStoreSurplus(surplusUpdateVO, updateInstoreFlag, updateSurplusFlag, false);
    }

    @Override
    public SurplusUpdateVO updateStoreSurplus(SurplusUpdateVO surplusUpdateVO, boolean updateInstoreFlag, boolean updateSurplusFlag, boolean updateReturnGoodsFlag) {
        Long storeId = surplusUpdateVO.getStoreId();
        List surplusVOList = surplusUpdateVO.getSurplusVOList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"store_id", (Object)storeId);
        queryWrapper.and(q -> {
            for (SurplusVO f : surplusVOList) {
                q.or(iq -> (QueryWrapper)((QueryWrapper)((QueryWrapper)iq.eq((Object)"store_id", (Object)f.getStoreId())).eq((Object)"brand_id", (Object)f.getBrandId())).eq((Object)"material_id", (Object)f.getMaterialId()));
            }
            return q;
        });
        List list = this.list((Wrapper)queryWrapper);
        Map<String, List<SurplusVO>> surplusVOMap = surplusVOList.stream().collect(Collectors.groupingBy(x -> x.getMaterialId() + "@" + x.getBrandId()));
        ArrayList<SurplusVO> surplusVOS = new ArrayList<SurplusVO>();
        surplusVOMap.forEach((key, value) -> {
            List surplusll = (List)surplusVOMap.get(key);
            SurplusVO surplusVO_0 = (SurplusVO)surplusll.get(0);
            if (surplusll.size() > 1) {
                SurplusVO surplusVO = (SurplusVO)BeanMapper.map((Object)surplusVO_0, SurplusVO.class);
                surplusVO.setOutLockMny(BigDecimal.ZERO);
                surplusVO.setOutLockTaxMny(BigDecimal.ZERO);
                surplusVO.setSurplusMny(BigDecimal.ZERO);
                surplusVO.setSurplusTaxMny(BigDecimal.ZERO);
                surplusVO.setSurplusNum(BigDecimal.ZERO);
                surplusVO.setInstoreMny(BigDecimal.ZERO);
                surplusVO.setInstoreTaxMny(BigDecimal.ZERO);
                surplusVO.setInstoreNum(BigDecimal.ZERO);
                surplusVO.setOutLockNum(BigDecimal.ZERO);
                surplusVO.setReturnGoodsNum(BigDecimal.ZERO);
                surplusll.forEach(t -> {
                    surplusVO.setOutLockMny(ComputeUtil.safeAdd((BigDecimal)surplusVO.getOutLockMny(), (BigDecimal)t.getOutLockMny()));
                    surplusVO.setOutLockTaxMny(ComputeUtil.safeAdd((BigDecimal)surplusVO.getOutLockTaxMny(), (BigDecimal)t.getOutLockTaxMny()));
                    surplusVO.setSurplusMny(ComputeUtil.safeAdd((BigDecimal)surplusVO.getSurplusMny(), (BigDecimal)t.getSurplusMny()));
                    surplusVO.setSurplusTaxMny(ComputeUtil.safeAdd((BigDecimal)surplusVO.getSurplusTaxMny(), (BigDecimal)t.getSurplusTaxMny()));
                    surplusVO.setSurplusNum(ComputeUtil.safeAdd((BigDecimal)surplusVO.getSurplusNum(), (BigDecimal)t.getSurplusNum()));
                    surplusVO.setInstoreMny(ComputeUtil.safeAdd((BigDecimal)surplusVO.getInstoreMny(), (BigDecimal)t.getInstoreMny()));
                    surplusVO.setInstoreTaxMny(ComputeUtil.safeAdd((BigDecimal)surplusVO.getInstoreTaxMny(), (BigDecimal)t.getInstoreTaxMny()));
                    surplusVO.setInstoreNum(ComputeUtil.safeAdd((BigDecimal)surplusVO.getInstoreNum(), (BigDecimal)t.getInstoreNum()));
                    surplusVO.setOutLockNum(ComputeUtil.safeAdd((BigDecimal)surplusVO.getOutLockNum(), (BigDecimal)t.getOutLockNum()));
                    surplusVO.setReturnGoodsNum(ComputeUtil.safeAdd((BigDecimal)surplusVO.getReturnGoodsNum(), (BigDecimal)t.getReturnGoodsNum()));
                });
                surplusVOS.add(surplusVO);
            } else {
                surplusVOS.add(surplusVO_0);
            }
        });
        if (CollectionUtils.isEmpty((Collection)list)) {
            surplusVOS.forEach(t -> {
                t.setOutLockMny(BigDecimal.ZERO);
                t.setOutLockTaxMny(BigDecimal.ZERO);
                t.setReturnGoodsNum(BigDecimal.ZERO);
                t.setOutLockNum(BigDecimal.ZERO);
                if (!updateSurplusFlag) {
                    t.setSurplusMny(BigDecimal.ZERO);
                    t.setSurplusTaxMny(BigDecimal.ZERO);
                    t.setSurplusNum(BigDecimal.ZERO);
                }
            });
            List surplusEntities = BeanMapper.mapList(surplusVOS, SurplusEntity.class);
            this.saveOrUpdateBatch(surplusEntities);
            return surplusUpdateVO;
        }
        Map<String, SurplusEntity> surplusEntityMap = list.stream().collect(Collectors.toMap(k -> k.getMaterialId() + "@" + k.getBrandId(), k -> k));
        ArrayList newSurplusList = new ArrayList();
        surplusVOS.forEach(t -> {
            String key = t.getMaterialId() + "@" + t.getBrandId();
            SurplusEntity surplusEntity = (SurplusEntity)((Object)((Object)surplusEntityMap.get(key)));
            if (null == surplusEntity) {
                t.setOutLockMny(BigDecimal.ZERO);
                t.setOutLockTaxMny(BigDecimal.ZERO);
                t.setReturnGoodsNum(BigDecimal.ZERO);
                t.setOutLockNum(BigDecimal.ZERO);
                if (!updateSurplusFlag) {
                    t.setSurplusMny(BigDecimal.ZERO);
                    t.setSurplusTaxMny(BigDecimal.ZERO);
                    t.setSurplusNum(BigDecimal.ZERO);
                }
                newSurplusList.add(BeanMapper.map((Object)t, SurplusEntity.class));
            } else {
                if (updateSurplusFlag) {
                    surplusEntity.setSurplusMny(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getSurplusMny(), (BigDecimal)t.getSurplusMny()));
                    surplusEntity.setSurplusTaxMny(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getSurplusTaxMny(), (BigDecimal)t.getSurplusTaxMny()));
                    surplusEntity.setSurplusNum(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getSurplusNum(), (BigDecimal)t.getSurplusNum()));
                }
                surplusEntity.setOutLockMny(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getOutLockMny(), (BigDecimal)t.getOutLockTaxMny()));
                surplusEntity.setOutLockTaxMny(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getOutLockMny(), (BigDecimal)t.getOutLockTaxMny()));
                if (updateInstoreFlag) {
                    surplusEntity.setInstoreMny(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getInstoreMny(), (BigDecimal)t.getSurplusMny()));
                    surplusEntity.setInstoreTaxMny(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getInstoreTaxMny(), (BigDecimal)t.getSurplusTaxMny()));
                    surplusEntity.setInstoreNum(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getInstoreNum(), (BigDecimal)t.getSurplusNum()));
                }
                if (updateReturnGoodsFlag) {
                    surplusEntity.setReturnGoodsNum(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getReturnGoodsNum(), (BigDecimal)t.getReturnGoodsNum()));
                }
                newSurplusList.add(surplusEntity);
            }
        });
        this.saveOrUpdateBatch(newSurplusList);
        surplusUpdateVO.setSurplusVOList(BeanMapper.mapList(newSurplusList, SurplusVO.class));
        return surplusUpdateVO;
    }

    @Override
    public CommonResponse<SurplusUpdateVO> validateSurplus(SurplusUpdateVO surplusUpdateVO, InOutTypeEnum inOutTypeEnum) {
        Long storeId = surplusUpdateVO.getStoreId();
        List flowVOList = surplusUpdateVO.getFlowVOList();
        List surplusVOList = surplusUpdateVO.getSurplusVOList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"store_id", (Object)storeId);
        queryWrapper.and(q -> {
            for (FlowVO f : flowVOList) {
                q.or(iq -> (QueryWrapper)((QueryWrapper)iq.eq((Object)"brand_id", (Object)f.getBrandId())).eq((Object)"material_id", (Object)f.getMaterialId()));
            }
            return q;
        });
        List surplusEntityList = this.list((Wrapper)queryWrapper);
        Map surplusNumMap = surplusEntityList.stream().collect(Collectors.toMap(k -> k.getMaterialId() + "@" + k.getBrandId(), Function.identity(), (key1, key2) -> key1));
        Map<String, BigDecimal> idleNumMap = null;
        if (null != inOutTypeEnum && InOutTypeEnum.\u4e91\u4ed3\u51fa\u5e93.getInOutType().equals(inOutTypeEnum.getInOutType())) {
            idleNumMap = this.getNewIdleNum(storeId, flowVOList);
        }
        for (SurplusVO t : surplusVOList) {
            String key = t.getMaterialId() + "@" + t.getBrandId();
            BigDecimal outChangeNum = ComputeUtil.isLessThan((BigDecimal)t.getSurplusNum(), (BigDecimal)BigDecimal.ZERO) ? ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)t.getSurplusNum()) : t.getSurplusNum();
            BigDecimal surplusNum = ComputeUtil.safeSub((BigDecimal)((SurplusEntity)((Object)surplusNumMap.get(key))).getSurplusNum(), (BigDecimal)(null != idleNumMap ? idleNumMap.get(key) : ((SurplusEntity)((Object)surplusNumMap.get(key))).getIdleNum()));
            BigDecimal outLockNum = t.getOutLockNum();
            if (!ComputeUtil.isGreaterThan((BigDecimal)outChangeNum, (BigDecimal)surplusNum)) continue;
            return CommonResponse.error((String)("\u7269\u8d44[\u540d\u79f0\uff1a" + t.getMaterialName() + "\uff0c\u89c4\u683c\uff1a" + StrUtil.emptyToDefault((CharSequence)t.getMaterialSpec(), (String)"\u65e0") + "\uff0c\u54c1\u724c\uff1a" + StrUtil.emptyToDefault((CharSequence)t.getBrandName(), (String)"\u65e0") + "]\uff0c\u5e93\u5b58\u4f59\u91cf\uff1a" + ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.nullToZero((BigDecimal)surplusNum)) + "\uff0c\u5e93\u5b58\u4e0d\u8db3!"));
        }
        return CommonResponse.success((Object)surplusUpdateVO);
    }

    private Map<String, BigDecimal> getNewIdleNum(Long storeId, List<FlowVO> flowVOList) {
        List flowEntities = BeanMapper.mapList(flowVOList, IdleFlowEntity.class);
        for (IdleFlowEntity flowEntity : flowEntities) {
            flowEntity.setNum(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)flowEntity.getNum()));
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"store_id", (Object)storeId);
        queryWrapper.and(q -> {
            for (IdleFlowEntity f : flowEntities) {
                q.or(iq -> (QueryWrapper)((QueryWrapper)iq.eq((Object)"brand_id", (Object)f.getBrandId())).eq((Object)"material_id", (Object)f.getMaterialId()));
            }
            return q;
        });
        ArrayList list = this.idleFlowService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            list = new ArrayList();
        }
        list.addAll(flowEntities);
        Map<String, BigDecimal> resultMap = list.stream().collect(Collectors.groupingBy(x -> x.getStoreId() + "@" + x.getMaterialId() + "@" + x.getBrandId(), Collectors.reducing(BigDecimal.ZERO, IdleFlowEntity::getNum, BigDecimal::add)));
        return resultMap;
    }

    @Override
    public UseCalculateVO useCalculate(StoreManageVO storeManageVO) {
        Long storeId = storeManageVO.getStoreId();
        List flowVOList = storeManageVO.getFlowVOList();
        SurplusUpdateVO surplusUpdateVO = StoreManageUtil.getSurplusUpdateVO((Long)storeId, (List)flowVOList, (boolean)false);
        Long sourceId = storeManageVO.getSourceId();
        ArrayList<FlowVO> flowUpdateList = new ArrayList<FlowVO>();
        HashMap<String, InOutVO> inOutUpdateMap = new HashMap<String, InOutVO>();
        HashMap surplusUpdateMap = new HashMap();
        QueryWrapper surplusEntityQueryWrapper = new QueryWrapper();
        surplusEntityQueryWrapper.eq((Object)"store_id", (Object)storeId);
        surplusEntityQueryWrapper.and(q -> {
            for (FlowVO f : flowVOList) {
                q.or(iq -> (QueryWrapper)((QueryWrapper)iq.eq((Object)"brand_id", (Object)f.getBrandId())).eq((Object)"material_id", (Object)f.getMaterialId()));
            }
            return q;
        });
        List surplusEntities = this.surplusService.list((Wrapper)surplusEntityQueryWrapper);
        List surplusVOS = BeanMapper.mapList((Iterable)surplusEntities, SurplusVO.class);
        surplusVOS.forEach(t -> surplusUpdateMap.put(t.getMaterialId() + "@" + t.getBrandId(), t));
        List inOutVOs = null;
        HashMap lockNum = new HashMap();
        if (sourceId != null) {
            QueryWrapper inOutEntityQueryWrapper = new QueryWrapper();
            inOutEntityQueryWrapper.eq((Object)"out_bill_id", (Object)sourceId);
            List inOutEntities = this.inOutService.list((Wrapper)inOutEntityQueryWrapper);
            inOutVOs = BeanMapper.mapList((Iterable)inOutEntities, InOutVO.class);
            inOutVOs.forEach(t -> {
                inOutUpdateMap.put(t.getMaterialId() + "@" + t.getBrandId() + String.valueOf(t.getInFlowId()), (InOutVO)t);
                String key = t.getMaterialId() + "@" + t.getBrandId();
                BigDecimal lock = (BigDecimal)lockNum.get(key);
                lockNum.put(key, ComputeUtil.safeAdd((BigDecimal)lock, (BigDecimal)t.getOutLockNum()));
            });
        }
        HashMap<String, InOutVO> materialNumMap = new HashMap<String, InOutVO>();
        for (FlowVO flowVO : flowVOList) {
            InOutVO inOutVO;
            String rowState = flowVO.getRowState();
            String key = flowVO.getMaterialId() + "@" + flowVO.getBrandId();
            BigDecimal itemNum = flowVO.getNum();
            if ("del".equals(rowState)) {
                itemNum = BigDecimal.ZERO;
            }
            if (null == (inOutVO = (InOutVO)materialNumMap.get(key))) {
                inOutVO = new InOutVO();
                inOutVO.setInOutType(flowVO.getInOutType());
                inOutVO.setInOutTypeName(flowVO.getInOutTypeName());
                inOutVO.setOutStoreId(flowVO.getStoreId());
                inOutVO.setOutStoreName(flowVO.getStoreName());
                inOutVO.setOutProjectId(flowVO.getProjectId());
                inOutVO.setOutProjectName(flowVO.getProjectName());
                if (flowVO.getId() == null) {
                    flowVO.setId(Long.valueOf(IdWorker.getId()));
                }
                inOutVO.setOutFlowId(flowVO.getId());
                inOutVO.setOutLockNum(itemNum);
                inOutVO.setOutBillDetailId(flowVO.getSourceDetailId());
                inOutVO.setOutBillId(flowVO.getSourceId());
                inOutVO.setOutBillCode(flowVO.getSourceBillCode());
                inOutVO.setMaterialId(flowVO.getMaterialId());
                inOutVO.setBrandId(flowVO.getBrandId());
                inOutVO.setOutDate(flowVO.getSourceBillDate());
                inOutVO.setPickUnitId(flowVO.getPickUnitId());
                inOutVO.setPickUnitName(flowVO.getPickUnitName());
                inOutVO.setPickContractId(flowVO.getPickContractId());
                inOutVO.setPickContractName(flowVO.getPickContractName());
            } else {
                BigDecimal sumNum = ComputeUtil.safeAdd((BigDecimal)inOutVO.getOutLockNum(), (BigDecimal)itemNum);
                inOutVO.setOutLockNum(sumNum);
            }
            materialNumMap.put(key, inOutVO);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"store_id", (Object)storeId);
        queryWrapper.and(q -> {
            for (FlowVO f : flowVOList) {
                q.or(iq -> (QueryWrapper)((QueryWrapper)iq.eq((Object)"brand_id", (Object)f.getBrandId())).eq((Object)"material_id", (Object)f.getMaterialId()));
            }
            return q;
        });
        queryWrapper.eq((Object)"effective_state", (Object)StoreCommonConsts.YES);
        queryWrapper.in((Object)"out_use_flag", Arrays.asList(StoreCommonConsts.UseOutFlag.USEABLE, StoreCommonConsts.UseOutFlag.USEING));
        queryWrapper.orderByAsc((Object[])new String[]{"material_id", "source_bill_date"});
        List instoreList = this.flowService.list((Wrapper)queryWrapper);
        Map<String, List<FlowEntity>> instoreNumMap = instoreList.stream().collect(Collectors.groupingBy(x -> x.getMaterialId() + "@" + x.getBrandId()));
        for (String key : materialNumMap.keySet()) {
            InOutVO outInOut = (InOutVO)materialNumMap.get(key);
            BigDecimal outLockNum = outInOut.getOutLockNum();
            BigDecimal changOutNum = ComputeUtil.safeSub((BigDecimal)outLockNum, (BigDecimal)((BigDecimal)lockNum.get(key)));
            BigDecimal changOutMny = BigDecimal.ZERO;
            BigDecimal changOutTaxMny = BigDecimal.ZERO;
            if (ComputeUtil.equals((BigDecimal)changOutNum, (BigDecimal)BigDecimal.ZERO)) continue;
            SurplusVO surplusVO = (SurplusVO)surplusUpdateMap.get(key);
            BigDecimal surplusNumStore = ComputeUtil.safeSub((BigDecimal)surplusVO.getSurplusNum(), (BigDecimal)changOutNum);
            surplusVO.setSurplusNum(surplusNumStore);
            BigDecimal newOutLockNum = ComputeUtil.safeAdd((BigDecimal)surplusVO.getOutLockNum(), (BigDecimal)changOutNum);
            surplusVO.setOutLockNum(newOutLockNum);
            if (ComputeUtil.isGreaterThan((BigDecimal)changOutNum, (BigDecimal)BigDecimal.ZERO)) {
                List<FlowEntity> flowEntities = instoreNumMap.get(key);
                flowEntities.sort(Comparator.comparingLong(o -> o.getSourceBillDate().getTime()).thenComparingLong(n -> n.getEffectiveDate().getTime()));
                boolean breakFlag = false;
                for (FlowEntity flowEntity : flowEntities) {
                    InOutVO newInOutVO = new InOutVO();
                    FlowVO flow = (FlowVO)BeanMapper.map((Object)((Object)flowEntity), FlowVO.class);
                    BigDecimal surplusNum = flow.getSurplusNum();
                    BigDecimal thisLockNum = BigDecimal.ZERO;
                    if (ComputeUtil.isGreaterOrEqual((BigDecimal)changOutNum, (BigDecimal)surplusNum)) {
                        thisLockNum = surplusNum;
                        flow.setSurplusNum(BigDecimal.ZERO);
                        flow.setSurplusMny(BigDecimal.ZERO);
                        flow.setSurplusTaxMny(BigDecimal.ZERO);
                        flow.setOutLockNum(ComputeUtil.safeAdd((BigDecimal)flow.getOutLockNum(), (BigDecimal)thisLockNum));
                        flow.setOutUseFlag(StoreCommonConsts.UseOutFlag.USE_FINISH);
                        changOutNum = ComputeUtil.safeSub((BigDecimal)changOutNum, (BigDecimal)thisLockNum);
                    } else {
                        thisLockNum = changOutNum;
                        surplusNum = ComputeUtil.safeSub((BigDecimal)surplusNum, (BigDecimal)changOutNum);
                        BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)surplusNum, (BigDecimal)flow.getPrice());
                        BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)surplusNum, (BigDecimal)flow.getTaxPrice());
                        flow.setSurplusNum(surplusNum);
                        flow.setSurplusMny(mny);
                        flow.setSurplusTaxMny(taxMny);
                        flow.setOutLockNum(ComputeUtil.safeAdd((BigDecimal)flow.getOutLockNum(), (BigDecimal)thisLockNum));
                        flow.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
                        changOutNum = BigDecimal.ZERO;
                    }
                    breakFlag = ComputeUtil.isEmpty((BigDecimal)changOutNum);
                    FlowVO flowVO = (FlowVO)BeanMapper.map((Object)flow, FlowVO.class);
                    flowUpdateList.add(flowVO);
                    String inOutKey = key + String.valueOf(flow.getId());
                    InOutVO inOutVO = (InOutVO)inOutUpdateMap.get(inOutKey);
                    if (inOutVO != null) {
                        BigDecimal newThisLockNum = ComputeUtil.safeAdd((BigDecimal)thisLockNum, (BigDecimal)inOutVO.getOutLockNum());
                        inOutVO.setOutLockNum(newThisLockNum);
                        newInOutVO = (InOutVO)BeanMapper.map((Object)inOutVO, InOutVO.class);
                    } else {
                        newInOutVO = StoreManageUtil.getInOutVO((FlowVO)flow, (InOutVO)outInOut, (BigDecimal)thisLockNum);
                    }
                    inOutUpdateMap.put(inOutKey, newInOutVO);
                    BigDecimal addMny = ComputeUtil.safeMultiply((BigDecimal)thisLockNum, (BigDecimal)flow.getPrice());
                    changOutMny = ComputeUtil.safeAdd((BigDecimal)changOutMny, (BigDecimal)addMny);
                    BigDecimal addTaxMny = ComputeUtil.safeMultiply((BigDecimal)thisLockNum, (BigDecimal)flow.getTaxPrice());
                    changOutTaxMny = ComputeUtil.safeAdd((BigDecimal)changOutTaxMny, (BigDecimal)addTaxMny);
                    if (!breakFlag) continue;
                    break;
                }
            } else {
                List inFlowIds = inOutVOs.stream().map(InOutVO::getInFlowId).collect(Collectors.toList());
                String[] arr = key.split("@");
                QueryWrapper inFlowQueryWrapper = new QueryWrapper();
                inFlowQueryWrapper.in((Object)"id", inFlowIds);
                inFlowQueryWrapper.eq((Object)"material_id", (Object)arr[0]);
                inFlowQueryWrapper.eq((Object)"brand_id", (Object)arr[1]);
                inFlowQueryWrapper.orderByDesc((Object[])new String[]{"material_id", "effective_date"});
                List inFlowList = this.flowService.list((Wrapper)inFlowQueryWrapper);
                Map<String, List<FlowEntity>> inFlowMap = inFlowList.stream().collect(Collectors.groupingBy(x -> x.getMaterialId() + "@" + x.getBrandId()));
                List<FlowEntity> flowEntities = inFlowMap.get(key);
                boolean useBreakFlag = false;
                BigDecimal changOutNumZS = ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)changOutNum);
                for (FlowEntity flowEntity : flowEntities) {
                    FlowVO useFlow = (FlowVO)BeanMapper.map((Object)((Object)flowEntity), FlowVO.class);
                    BigDecimal surplusNum = useFlow.getSurplusNum();
                    BigDecimal useLockNum = useFlow.getOutLockNum();
                    BigDecimal thisUnUseLockNum = null;
                    boolean isBackUseAll = ComputeUtil.isGreaterOrEqual((BigDecimal)changOutNumZS, (BigDecimal)useLockNum);
                    if (isBackUseAll) {
                        thisUnUseLockNum = useLockNum;
                        changOutNumZS = ComputeUtil.safeSub((BigDecimal)changOutNumZS, (BigDecimal)useLockNum);
                    } else {
                        useBreakFlag = true;
                        thisUnUseLockNum = changOutNumZS;
                    }
                    BigDecimal surLockNum = ComputeUtil.safeSub((BigDecimal)useLockNum, (BigDecimal)thisUnUseLockNum);
                    useFlow.setOutLockNum(surLockNum);
                    BigDecimal surNum = ComputeUtil.safeAdd((BigDecimal)surplusNum, (BigDecimal)thisUnUseLockNum);
                    useFlow.setSurplusNum(surNum);
                    useFlow.setSurplusMny(ComputeUtil.safeMultiply((BigDecimal)surNum, (BigDecimal)useFlow.getPrice()));
                    useFlow.setSurplusTaxMny(ComputeUtil.safeMultiply((BigDecimal)surNum, (BigDecimal)useFlow.getTaxPrice()));
                    if (ComputeUtil.isEmpty((BigDecimal)useFlow.getOutNum()).booleanValue() && ComputeUtil.isEmpty((BigDecimal)useFlow.getOutLockNum()).booleanValue()) {
                        useFlow.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEABLE);
                    } else {
                        useFlow.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
                    }
                    flowUpdateList.add(useFlow);
                    String inOutKey = key + String.valueOf(useFlow.getId());
                    InOutVO inOutVO = (InOutVO)inOutUpdateMap.get(inOutKey);
                    if (inOutVO != null) {
                        BigDecimal newThisLockNum = ComputeUtil.safeSub((BigDecimal)inOutVO.getOutLockNum(), (BigDecimal)thisUnUseLockNum);
                        if (ComputeUtil.isEmpty((BigDecimal)newThisLockNum).booleanValue()) {
                            inOutVO.setDr(Integer.valueOf(1));
                        } else {
                            inOutVO.setOutLockNum(newThisLockNum);
                        }
                    }
                    BigDecimal thisUnUseLockNum_FS = ComputeUtil.convertToMinusNumber((BigDecimal)thisUnUseLockNum);
                    BigDecimal addMny = ComputeUtil.safeMultiply((BigDecimal)thisUnUseLockNum_FS, (BigDecimal)useFlow.getPrice());
                    changOutMny = ComputeUtil.safeAdd((BigDecimal)changOutMny, (BigDecimal)addMny);
                    BigDecimal addTaxMny = ComputeUtil.safeMultiply((BigDecimal)thisUnUseLockNum_FS, (BigDecimal)useFlow.getTaxPrice());
                    changOutTaxMny = ComputeUtil.safeAdd((BigDecimal)changOutTaxMny, (BigDecimal)addTaxMny);
                    if (!useBreakFlag) continue;
                    break;
                }
            }
            surplusVO.setOutLockMny(ComputeUtil.safeAdd((BigDecimal)surplusVO.getOutLockMny(), (BigDecimal)changOutMny));
            surplusVO.setOutLockTaxMny(ComputeUtil.safeAdd((BigDecimal)surplusVO.getOutLockTaxMny(), (BigDecimal)changOutTaxMny));
            surplusVO.setSurplusMny(ComputeUtil.safeSub((BigDecimal)surplusVO.getSurplusMny(), (BigDecimal)changOutMny));
            surplusVO.setSurplusTaxMny(ComputeUtil.safeSub((BigDecimal)surplusVO.getSurplusTaxMny(), (BigDecimal)changOutTaxMny));
        }
        List useMaterialPriceVOList = BeanMapper.mapList((Iterable)flowVOList, UseMaterialPriceVO.class);
        ArrayList newInOutVOList = new ArrayList(inOutUpdateMap.values());
        Map<String, List<InOutVO>> newInOutMap = newInOutVOList.stream().collect(Collectors.groupingBy(x -> x.getMaterialId() + "@" + x.getBrandId()));
        useMaterialPriceVOList.forEach(t -> {
            List inOutVOS = (List)newInOutMap.get(t.getMaterialId() + "@" + t.getBrandId());
            if (CollectionUtils.isNotEmpty((Collection)inOutVOS)) {
                BigDecimal mny = null;
                BigDecimal taxMny = null;
                BigDecimal tax = null;
                for (InOutVO in : inOutVOS) {
                    BigDecimal outLockNum = in.getOutLockNum();
                    BigDecimal price = in.getPrice();
                    BigDecimal taxPrice = in.getTaxPrice();
                    if (ComputeUtil.equals((BigDecimal)in.getPrice(), (BigDecimal)BigDecimal.ZERO) && ComputeUtil.equals((BigDecimal)in.getTaxPrice(), (BigDecimal)BigDecimal.ZERO) && ComputeUtil.isGreaterThan((BigDecimal)in.getTaxMny(), (BigDecimal)BigDecimal.ZERO)) {
                        taxPrice = ComputeUtil.safeDiv((BigDecimal)in.getTaxMny(), (BigDecimal)in.getNum());
                        price = ComputeUtil.safeDiv((BigDecimal)in.getTaxMny(), (BigDecimal)in.getNum());
                    }
                    BigDecimal addMny = ComputeUtil.safeMultiply((BigDecimal)outLockNum, (BigDecimal)price);
                    BigDecimal addTaxMny = ComputeUtil.safeMultiply((BigDecimal)outLockNum, (BigDecimal)taxPrice);
                    if (in.getDr() == 1) continue;
                    mny = ComputeUtil.safeAdd((BigDecimal)addMny, mny);
                    taxMny = ComputeUtil.safeAdd((BigDecimal)addTaxMny, taxMny);
                    tax = ComputeUtil.safeSub((BigDecimal)taxMny, (BigDecimal)mny);
                }
                t.setTax(tax);
                t.setMny(mny);
                t.setTaxMny(taxMny);
                BigDecimal price = ComputeUtil.safeDiv((BigDecimal)t.getMny(), (BigDecimal)t.getNum());
                BigDecimal taxPrice = ComputeUtil.safeDiv((BigDecimal)t.getTaxMny(), (BigDecimal)t.getNum());
                t.setPrice(price);
                t.setTaxPrice(taxPrice);
            }
        });
        UseCalculateVO calculateVO = new UseCalculateVO();
        calculateVO.setStoreManageVO(storeManageVO);
        calculateVO.setUpdateFlowVOList(flowUpdateList);
        calculateVO.setUpdateInOutVOList(newInOutVOList);
        calculateVO.setUpdateSurplusVOList(new ArrayList(surplusUpdateMap.values()));
        calculateVO.setUseMaterialPriceVOList(useMaterialPriceVOList);
        return calculateVO;
    }

    @Override
    public UseCalculateVO outRollBackByInOut(StoreManageVO storeManageVO, Boolean outEffectiveON) {
        UseCalculateVO calculateVO = new UseCalculateVO();
        List sourceIdsForRollBack = storeManageVO.getSourceIdsForRollBack();
        QueryWrapper inOutEntityQueryWrapper = new QueryWrapper();
        inOutEntityQueryWrapper.in((Object)"out_bill_id", (Collection)sourceIdsForRollBack);
        List inOutEntities = this.inOutService.list((Wrapper)inOutEntityQueryWrapper);
        List inOutVOs = BeanMapper.mapList((Iterable)inOutEntities, InOutVO.class);
        HashMap<Long, BigDecimal> flowNum = new HashMap<Long, BigDecimal>();
        HashMap<String, SurplusVO> surplusNum = new HashMap<String, SurplusVO>();
        for (InOutVO t2 : inOutVOs) {
            Long inFlowId = t2.getInFlowId();
            BigDecimal _num = (BigDecimal)flowNum.get(inFlowId);
            Long storeId = t2.getInStoreId();
            Long materialId = t2.getMaterialId();
            Long brandId = t2.getBrandId();
            String surplusKey = String.valueOf(storeId) + materialId + "@" + brandId;
            SurplusVO surplusUpdateVO = (SurplusVO)surplusNum.get(surplusKey);
            if (surplusUpdateVO == null) {
                surplusUpdateVO = new SurplusVO();
            }
            BigDecimal surNum = surplusUpdateVO.getSurplusNum();
            BigDecimal surMny = surplusUpdateVO.getSurplusMny();
            BigDecimal surTaxMny = surplusUpdateVO.getSurplusTaxMny();
            if (outEffectiveON.booleanValue()) {
                BigDecimal returnStoreNum = t2.getReturnStoreNum();
                if (ComputeUtil.isNotEmpty((BigDecimal)returnStoreNum).booleanValue()) {
                    calculateVO.setErrorMsg("\u5355\u636e\u5df2\u53d1\u751f\u9000\u5e93\u4e1a\u52a1,\u4e0d\u5141\u8bb8\u5f03\u5ba1!");
                    return calculateVO;
                }
                BigDecimal outNum = t2.getOutNum();
                _num = ComputeUtil.safeAdd((BigDecimal)_num, (BigDecimal)outNum);
                surNum = ComputeUtil.safeAdd((BigDecimal)surNum, (BigDecimal)outNum);
                BigDecimal addMny = ComputeUtil.safeMultiply((BigDecimal)outNum, (BigDecimal)t2.getPrice());
                surMny = ComputeUtil.safeAdd((BigDecimal)surMny, (BigDecimal)addMny);
                BigDecimal addTaxMny = ComputeUtil.safeMultiply((BigDecimal)outNum, (BigDecimal)t2.getTaxPrice());
                surTaxMny = ComputeUtil.safeAdd((BigDecimal)surTaxMny, (BigDecimal)addTaxMny);
                t2.setOutLockNum(outNum);
                t2.setOutNum(BigDecimal.ZERO);
                t2.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
            } else {
                _num = ComputeUtil.safeAdd((BigDecimal)_num, (BigDecimal)t2.getOutLockNum());
                surNum = ComputeUtil.safeAdd((BigDecimal)surNum, (BigDecimal)t2.getOutLockNum());
                BigDecimal addMny = ComputeUtil.safeMultiply((BigDecimal)t2.getOutLockNum(), (BigDecimal)t2.getPrice());
                surMny = ComputeUtil.safeAdd((BigDecimal)surMny, (BigDecimal)addMny);
                BigDecimal addTaxMny = ComputeUtil.safeMultiply((BigDecimal)t2.getOutLockNum(), (BigDecimal)t2.getTaxPrice());
                surTaxMny = ComputeUtil.safeAdd((BigDecimal)surTaxMny, (BigDecimal)addTaxMny);
            }
            flowNum.put(inFlowId, _num);
            surplusUpdateVO.setSurplusNum(surNum);
            surplusUpdateVO.setSurplusMny(surMny);
            surplusUpdateVO.setSurplusTaxMny(surTaxMny);
            surplusNum.put(surplusKey, surplusUpdateVO);
        }
        calculateVO.setUpdateInOutVOList(inOutVOs);
        List flowEntities = (List)this.flowService.listByIds(flowNum.keySet());
        List flowVOS = BeanMapper.mapList((Iterable)flowEntities, FlowVO.class);
        flowVOS.forEach(t -> {
            Long id = t.getId();
            BigDecimal num = (BigDecimal)flowNum.get(id);
            if (outEffectiveON.booleanValue()) {
                BigDecimal outLockNum = ComputeUtil.safeAdd((BigDecimal)t.getOutLockNum(), (BigDecimal)num);
                t.setOutLockNum(outLockNum);
                BigDecimal outNum = ComputeUtil.safeSub((BigDecimal)t.getOutNum(), (BigDecimal)num);
                t.setOutNum(outNum);
            } else {
                BigDecimal outLockNum = ComputeUtil.safeSub((BigDecimal)t.getOutLockNum(), (BigDecimal)num);
                t.setOutLockNum(outLockNum);
                BigDecimal surplusNumNew = ComputeUtil.safeAdd((BigDecimal)t.getSurplusNum(), (BigDecimal)num);
                t.setSurplusNum(surplusNumNew);
                BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)surplusNumNew, (BigDecimal)t.getTaxPrice());
                t.setSurplusTaxMny(taxMny);
                BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)surplusNumNew, (BigDecimal)t.getPrice());
                t.setSurplusMny(mny);
            }
            if (ComputeUtil.equals((BigDecimal)t.getSurplusNum(), (BigDecimal)t.getNum())) {
                t.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEABLE);
            } else if (ComputeUtil.isEmpty((BigDecimal)t.getSurplusNum()).booleanValue()) {
                t.setOutUseFlag(StoreCommonConsts.UseOutFlag.USE_FINISH);
            } else {
                t.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
            }
        });
        calculateVO.setUpdateFlowVOList(flowVOS);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.and(q -> {
            for (InOutVO f : inOutVOs) {
                q.or(iq -> (QueryWrapper)((QueryWrapper)((QueryWrapper)iq.eq((Object)"store_id", (Object)f.getInStoreId())).eq((Object)"brand_id", (Object)f.getBrandId())).eq((Object)"material_id", (Object)f.getMaterialId()));
            }
            return q;
        });
        List list = this.list((Wrapper)queryWrapper);
        List surplusVOS = BeanMapper.mapList((Iterable)list, SurplusVO.class);
        surplusVOS.forEach(t -> {
            String key = String.valueOf(t.getStoreId()) + t.getMaterialId() + "@" + t.getBrandId();
            SurplusVO surplusVO = (SurplusVO)surplusNum.get(key);
            BigDecimal _surplusNum = surplusVO.getSurplusNum();
            if (outEffectiveON.booleanValue()) {
                BigDecimal outLockNum = ComputeUtil.safeAdd((BigDecimal)t.getOutLockNum(), (BigDecimal)_surplusNum);
                t.setOutLockNum(outLockNum);
                t.setOutLockMny(ComputeUtil.safeAdd((BigDecimal)t.getOutLockMny(), (BigDecimal)surplusVO.getSurplusMny()));
                t.setOutLockTaxMny(ComputeUtil.safeAdd((BigDecimal)t.getOutLockTaxMny(), (BigDecimal)surplusVO.getSurplusTaxMny()));
            } else {
                BigDecimal outLockNum = ComputeUtil.safeSub((BigDecimal)t.getOutLockNum(), (BigDecimal)_surplusNum);
                t.setOutLockNum(outLockNum);
                BigDecimal surplusNumNew = ComputeUtil.safeAdd((BigDecimal)t.getSurplusNum(), (BigDecimal)_surplusNum);
                t.setSurplusNum(surplusNumNew);
                BigDecimal taxMny = ComputeUtil.safeAdd((BigDecimal)surplusVO.getSurplusTaxMny(), (BigDecimal)t.getSurplusTaxMny());
                t.setSurplusTaxMny(taxMny);
                BigDecimal mny = ComputeUtil.safeAdd((BigDecimal)surplusVO.getSurplusMny(), (BigDecimal)t.getSurplusMny());
                t.setSurplusMny(mny);
                t.setOutLockMny(ComputeUtil.safeSub((BigDecimal)t.getOutLockMny(), (BigDecimal)surplusVO.getSurplusMny()));
                t.setOutLockTaxMny(ComputeUtil.safeSub((BigDecimal)t.getOutLockTaxMny(), (BigDecimal)surplusVO.getSurplusTaxMny()));
            }
        });
        calculateVO.setUpdateSurplusVOList(surplusVOS);
        return calculateVO;
    }

    @Override
    public UseCalculateVO useTurnCalculate(StoreManageVO storeManageVO) {
        Long storeId = storeManageVO.getStoreId();
        List flowVOList = storeManageVO.getFlowVOList();
        SurplusUpdateVO surplusUpdateVO = StoreManageUtil.getSurplusUpdateVO((Long)storeId, (List)flowVOList, (boolean)false);
        Long sourceId = storeManageVO.getSourceId();
        ArrayList<FlowVO> flowUpdateList = new ArrayList<FlowVO>();
        HashMap<String, InOutVO> inOutUpdateMap = new HashMap<String, InOutVO>();
        HashMap surplusUpdateMap = new HashMap();
        QueryWrapper surplusEntityQueryWrapper = new QueryWrapper();
        surplusEntityQueryWrapper.eq((Object)"store_id", (Object)storeId);
        surplusEntityQueryWrapper.and(q -> {
            for (FlowVO f : flowVOList) {
                q.or(iq -> (QueryWrapper)((QueryWrapper)iq.eq((Object)"brand_id", (Object)f.getBrandId())).eq((Object)"material_id", (Object)f.getMaterialId()));
            }
            return q;
        });
        List surplusEntities = this.surplusService.list((Wrapper)surplusEntityQueryWrapper);
        List surplusVOS = BeanMapper.mapList((Iterable)surplusEntities, SurplusVO.class);
        surplusVOS.forEach(t -> surplusUpdateMap.put(t.getMaterialId() + "@" + t.getBrandId(), t));
        List inOutVOs = null;
        HashMap lockNum = new HashMap();
        if (sourceId != null) {
            QueryWrapper inOutEntityQueryWrapper = new QueryWrapper();
            inOutEntityQueryWrapper.eq((Object)"out_bill_id", (Object)sourceId);
            List inOutEntities = this.inOutService.list((Wrapper)inOutEntityQueryWrapper);
            inOutVOs = BeanMapper.mapList((Iterable)inOutEntities, InOutVO.class);
            inOutVOs.forEach(t -> {
                inOutUpdateMap.put(t.getMaterialId() + "@" + t.getBrandId() + String.valueOf(t.getInFlowId()), (InOutVO)t);
                String key = t.getMaterialId() + "@" + t.getBrandId();
                BigDecimal lock = (BigDecimal)lockNum.get(key);
                lockNum.put(key, ComputeUtil.safeAdd((BigDecimal)lock, (BigDecimal)t.getOutLockNum()));
            });
        }
        HashMap<String, InOutVO> materialNumMap = new HashMap<String, InOutVO>();
        for (FlowVO flowVO : flowVOList) {
            InOutVO inOutVO;
            String rowState = flowVO.getRowState();
            String key = flowVO.getMaterialId() + "@" + flowVO.getBrandId();
            BigDecimal itemNum = flowVO.getNum();
            if ("del".equals(rowState)) {
                itemNum = BigDecimal.ZERO;
            }
            if (null == (inOutVO = (InOutVO)materialNumMap.get(key))) {
                inOutVO = new InOutVO();
                inOutVO.setInOutType(flowVO.getInOutType());
                inOutVO.setInOutTypeName(flowVO.getInOutTypeName());
                inOutVO.setOutStoreId(flowVO.getStoreId());
                inOutVO.setOutStoreName(flowVO.getStoreName());
                inOutVO.setOutProjectId(flowVO.getProjectId());
                inOutVO.setOutProjectName(flowVO.getProjectName());
                if (flowVO.getId() == null) {
                    flowVO.setId(Long.valueOf(IdWorker.getId()));
                }
                inOutVO.setOutFlowId(flowVO.getId());
                inOutVO.setOutLockNum(itemNum);
                inOutVO.setOutBillDetailId(flowVO.getSourceDetailId());
                inOutVO.setOutBillId(flowVO.getSourceId());
                inOutVO.setOutBillCode(flowVO.getSourceBillCode());
                inOutVO.setMaterialId(flowVO.getMaterialId());
                inOutVO.setBrandId(flowVO.getBrandId());
                inOutVO.setOutDate(flowVO.getSourceBillDate());
                inOutVO.setPickUnitId(flowVO.getPickUnitId());
                inOutVO.setPickUnitName(flowVO.getPickUnitName());
                inOutVO.setPickContractId(flowVO.getPickContractId());
                inOutVO.setPickContractName(flowVO.getPickContractName());
            } else {
                BigDecimal sumNum = ComputeUtil.safeAdd((BigDecimal)inOutVO.getOutLockNum(), (BigDecimal)itemNum);
                inOutVO.setOutLockNum(sumNum);
            }
            materialNumMap.put(key, inOutVO);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"store_id", (Object)storeId);
        queryWrapper.and(q -> {
            for (FlowVO f : flowVOList) {
                q.or(iq -> (QueryWrapper)((QueryWrapper)iq.eq((Object)"brand_id", (Object)f.getBrandId())).eq((Object)"material_id", (Object)f.getMaterialId()));
            }
            return q;
        });
        queryWrapper.eq((Object)"effective_state", (Object)StoreCommonConsts.YES);
        queryWrapper.in((Object)"out_use_flag", Arrays.asList(StoreCommonConsts.UseOutFlag.USEABLE, StoreCommonConsts.UseOutFlag.USEING));
        queryWrapper.orderByAsc((Object[])new String[]{"material_id", "source_bill_date"});
        List instoreList = this.flowService.list((Wrapper)queryWrapper);
        Map<String, List<FlowEntity>> instoreNumMap = instoreList.stream().collect(Collectors.groupingBy(x -> x.getMaterialId() + "@" + x.getBrandId()));
        for (String key : materialNumMap.keySet()) {
            InOutVO outInOut = (InOutVO)materialNumMap.get(key);
            BigDecimal outLockNum = outInOut.getOutLockNum();
            BigDecimal changOutNum = ComputeUtil.safeSub((BigDecimal)outLockNum, (BigDecimal)((BigDecimal)lockNum.get(key)));
            BigDecimal changOutMny = BigDecimal.ZERO;
            BigDecimal changOutTaxMny = BigDecimal.ZERO;
            if (ComputeUtil.equals((BigDecimal)changOutNum, (BigDecimal)BigDecimal.ZERO)) continue;
            SurplusVO surplusVO = (SurplusVO)surplusUpdateMap.get(key);
            BigDecimal surplusNumStore = ComputeUtil.safeSub((BigDecimal)surplusVO.getSurplusNum(), (BigDecimal)changOutNum);
            surplusVO.setSurplusNum(surplusNumStore);
            BigDecimal newOutLockNum = ComputeUtil.safeAdd((BigDecimal)surplusVO.getOutLockNum(), (BigDecimal)changOutNum);
            surplusVO.setOutLockNum(newOutLockNum);
            if (ComputeUtil.isGreaterThan((BigDecimal)changOutNum, (BigDecimal)BigDecimal.ZERO)) {
                List<FlowEntity> flowEntities = instoreNumMap.get(key);
                flowEntities.sort(Comparator.comparingLong(o -> o.getSourceBillDate().getTime()).thenComparingLong(n -> n.getEffectiveDate().getTime()));
                boolean breakFlag = false;
                for (FlowEntity flowEntity : flowEntities) {
                    InOutVO newInOutVO = new InOutVO();
                    FlowVO flow = (FlowVO)BeanMapper.map((Object)((Object)flowEntity), FlowVO.class);
                    BigDecimal surplusNum = flow.getSurplusNum();
                    BigDecimal netMny = flow.getNetMny();
                    BigDecimal netTaxMny = flow.getNetTaxMny();
                    BigDecimal netPrice = ComputeUtil.safeDiv((BigDecimal)netMny, (BigDecimal)surplusNum);
                    BigDecimal netTaxPrice = ComputeUtil.safeDiv((BigDecimal)netTaxMny, (BigDecimal)surplusNum);
                    BigDecimal thisLockNum = BigDecimal.ZERO;
                    BigDecimal thisLockNetMny = BigDecimal.ZERO;
                    BigDecimal thisLockNetTaxMny = BigDecimal.ZERO;
                    BigDecimal thisLockPurchaseMny = BigDecimal.ZERO;
                    BigDecimal thisLockPurchaseTaxMny = BigDecimal.ZERO;
                    if (ComputeUtil.isGreaterOrEqual((BigDecimal)changOutNum, (BigDecimal)surplusNum)) {
                        thisLockNum = surplusNum;
                        thisLockNetMny = netMny;
                        thisLockNetTaxMny = netTaxMny;
                        flow.setNetMny(BigDecimal.ZERO);
                        flow.setNetTaxMny(BigDecimal.ZERO);
                        flow.setSurplusNum(BigDecimal.ZERO);
                        flow.setOutLockNum(ComputeUtil.safeAdd((BigDecimal)flow.getOutLockNum(), (BigDecimal)thisLockNum));
                        flow.setOutUseFlag(StoreCommonConsts.UseOutFlag.USE_FINISH);
                        changOutNum = ComputeUtil.safeSub((BigDecimal)changOutNum, (BigDecimal)thisLockNum);
                    } else {
                        thisLockNum = changOutNum;
                        surplusNum = ComputeUtil.safeSub((BigDecimal)surplusNum, (BigDecimal)changOutNum);
                        thisLockNetMny = ComputeUtil.safeMultiply((BigDecimal)thisLockNum, (BigDecimal)netPrice);
                        thisLockNetTaxMny = ComputeUtil.safeMultiply((BigDecimal)thisLockNum, (BigDecimal)netTaxPrice);
                        flow.setSurplusNum(surplusNum);
                        flow.setOutLockNum(ComputeUtil.safeAdd((BigDecimal)flow.getOutLockNum(), (BigDecimal)thisLockNum));
                        flow.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
                        changOutNum = BigDecimal.ZERO;
                    }
                    thisLockPurchaseMny = ComputeUtil.safeMultiply((BigDecimal)thisLockNum, (BigDecimal)flowEntity.getPurchasePrice());
                    thisLockPurchaseTaxMny = ComputeUtil.safeMultiply((BigDecimal)thisLockNum, (BigDecimal)flowEntity.getPurchaseTaxPrice());
                    flow.setNetMny(ComputeUtil.safeSub((BigDecimal)netMny, (BigDecimal)thisLockNetMny));
                    flow.setNetTaxMny(ComputeUtil.safeSub((BigDecimal)netTaxMny, (BigDecimal)thisLockNetTaxMny));
                    breakFlag = ComputeUtil.isEmpty((BigDecimal)changOutNum);
                    FlowVO flowVO = (FlowVO)BeanMapper.map((Object)flow, FlowVO.class);
                    flowUpdateList.add(flowVO);
                    String inOutKey = key + String.valueOf(flow.getId());
                    InOutVO inOutVO = (InOutVO)inOutUpdateMap.get(inOutKey);
                    if (inOutVO != null) {
                        BigDecimal newThisLockNum = ComputeUtil.safeAdd((BigDecimal)thisLockNum, (BigDecimal)inOutVO.getOutLockNum());
                        inOutVO.setOutLockNum(newThisLockNum);
                        BigDecimal newThisLockNetMny = ComputeUtil.safeAdd((BigDecimal)thisLockNetMny, (BigDecimal)inOutVO.getOutNetMny());
                        inOutVO.setOutNetMny(newThisLockNetMny);
                        BigDecimal newThisLockNetTaxMny = ComputeUtil.safeAdd((BigDecimal)thisLockNetTaxMny, (BigDecimal)inOutVO.getOutNetTaxMny());
                        inOutVO.setOutNetTaxMny(newThisLockNetTaxMny);
                        BigDecimal newThisLockPurchaseMny = ComputeUtil.safeAdd((BigDecimal)thisLockPurchaseMny, (BigDecimal)inOutVO.getPurchaseMny());
                        inOutVO.setPurchaseMny(newThisLockPurchaseMny);
                        BigDecimal newThisLockPurchaseTaxMny = ComputeUtil.safeAdd((BigDecimal)thisLockPurchaseTaxMny, (BigDecimal)inOutVO.getPurchaseTaxMny());
                        inOutVO.setPurchaseTaxMny(newThisLockPurchaseTaxMny);
                        inOutVO.setPrice(ComputeUtil.safeDiv((BigDecimal)inOutVO.getOutNetMny(), (BigDecimal)inOutVO.getOutLockNum()));
                        inOutVO.setTaxPrice(ComputeUtil.safeDiv((BigDecimal)inOutVO.getOutNetTaxMny(), (BigDecimal)inOutVO.getOutLockNum()));
                        newInOutVO = (InOutVO)BeanMapper.map((Object)inOutVO, InOutVO.class);
                    } else {
                        newInOutVO = StoreManageUtil.getTurnInOutVO((FlowVO)flow, (InOutVO)outInOut, (BigDecimal)thisLockNum, (BigDecimal)thisLockNetMny, (BigDecimal)thisLockNetTaxMny, (BigDecimal)thisLockPurchaseMny, (BigDecimal)thisLockPurchaseTaxMny);
                    }
                    inOutUpdateMap.put(inOutKey, newInOutVO);
                    changOutMny = ComputeUtil.safeAdd((BigDecimal)changOutMny, (BigDecimal)thisLockNetMny);
                    changOutTaxMny = ComputeUtil.safeAdd((BigDecimal)changOutTaxMny, (BigDecimal)thisLockNetTaxMny);
                    if (!breakFlag) continue;
                    break;
                }
            } else {
                List inFlowIds = inOutVOs.stream().map(InOutVO::getInFlowId).collect(Collectors.toList());
                String[] arr = key.split("@");
                QueryWrapper inFlowQueryWrapper = new QueryWrapper();
                inFlowQueryWrapper.in((Object)"id", inFlowIds);
                inFlowQueryWrapper.eq((Object)"material_id", (Object)arr[0]);
                inFlowQueryWrapper.eq((Object)"brand_id", (Object)arr[1]);
                inFlowQueryWrapper.orderByDesc((Object[])new String[]{"material_id", "effective_date"});
                List inFlowList = this.flowService.list((Wrapper)inFlowQueryWrapper);
                Map<String, List<FlowEntity>> inFlowMap = inFlowList.stream().collect(Collectors.groupingBy(x -> x.getMaterialId() + "@" + x.getBrandId()));
                List<FlowEntity> flowEntities = inFlowMap.get(key);
                boolean useBreakFlag = false;
                BigDecimal changOutNumZS = ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)changOutNum);
                for (FlowEntity flowEntity : flowEntities) {
                    FlowVO useFlow = (FlowVO)BeanMapper.map((Object)((Object)flowEntity), FlowVO.class);
                    BigDecimal surplusNum = useFlow.getSurplusNum();
                    BigDecimal useLockNum = useFlow.getOutLockNum();
                    BigDecimal netMny = useFlow.getNetMny();
                    BigDecimal netTaxMny = useFlow.getNetTaxMny();
                    BigDecimal netPrice = ComputeUtil.safeDiv((BigDecimal)netMny, (BigDecimal)surplusNum);
                    BigDecimal netTaxPrice = ComputeUtil.safeDiv((BigDecimal)netTaxMny, (BigDecimal)surplusNum);
                    BigDecimal thisUnUseLockNum = null;
                    boolean isBackUseAll = ComputeUtil.isGreaterOrEqual((BigDecimal)changOutNumZS, (BigDecimal)useLockNum);
                    if (isBackUseAll) {
                        thisUnUseLockNum = useLockNum;
                        changOutNumZS = ComputeUtil.safeSub((BigDecimal)changOutNumZS, (BigDecimal)useLockNum);
                    } else {
                        useBreakFlag = true;
                        thisUnUseLockNum = changOutNumZS;
                    }
                    BigDecimal surLockNum = ComputeUtil.safeSub((BigDecimal)useLockNum, (BigDecimal)thisUnUseLockNum);
                    useFlow.setOutLockNum(surLockNum);
                    BigDecimal surNum = ComputeUtil.safeAdd((BigDecimal)surplusNum, (BigDecimal)thisUnUseLockNum);
                    useFlow.setSurplusNum(surNum);
                    String inOutKey = key + String.valueOf(useFlow.getId());
                    InOutVO inOutVO = (InOutVO)inOutUpdateMap.get(inOutKey);
                    if (inOutVO != null) {
                        BigDecimal newThisLockNum = ComputeUtil.safeSub((BigDecimal)inOutVO.getOutLockNum(), (BigDecimal)thisUnUseLockNum);
                        if (ComputeUtil.isEmpty((BigDecimal)newThisLockNum).booleanValue()) {
                            inOutVO.setDr(Integer.valueOf(1));
                            useFlow.setNetMny(ComputeUtil.safeAdd((BigDecimal)useFlow.getNetMny(), (BigDecimal)inOutVO.getOutNetMny()));
                            useFlow.setNetTaxMny(ComputeUtil.safeAdd((BigDecimal)useFlow.getNetTaxMny(), (BigDecimal)inOutVO.getOutNetTaxMny()));
                            changOutMny = ComputeUtil.convertToMinusNumber((BigDecimal)ComputeUtil.safeAdd((BigDecimal)changOutMny, (BigDecimal)inOutVO.getOutNetMny()));
                            changOutTaxMny = ComputeUtil.convertToMinusNumber((BigDecimal)ComputeUtil.safeAdd((BigDecimal)changOutTaxMny, (BigDecimal)inOutVO.getOutNetTaxMny()));
                        } else {
                            BigDecimal newNetMny = ComputeUtil.safeMultiply((BigDecimal)newThisLockNum, (BigDecimal)netPrice);
                            BigDecimal newNetTaxMny = ComputeUtil.safeMultiply((BigDecimal)newThisLockNum, (BigDecimal)netTaxPrice);
                            inOutVO.setOutLockNum(newThisLockNum);
                            inOutVO.setOutNetMny(newNetMny);
                            inOutVO.setOutNetTaxMny(newNetTaxMny);
                            inOutVO.setPurchaseTaxMny(ComputeUtil.safeMultiply((BigDecimal)newThisLockNum, (BigDecimal)useFlow.getPurchaseTaxPrice()));
                            inOutVO.setPurchaseMny(ComputeUtil.safeMultiply((BigDecimal)newThisLockNum, (BigDecimal)useFlow.getPurchasePrice()));
                            useFlow.setNetMny(ComputeUtil.safeAdd((BigDecimal)useFlow.getNetMny(), (BigDecimal)newNetMny));
                            useFlow.setNetTaxMny(ComputeUtil.safeAdd((BigDecimal)useFlow.getNetTaxMny(), (BigDecimal)newNetTaxMny));
                            changOutMny = ComputeUtil.convertToMinusNumber((BigDecimal)ComputeUtil.safeAdd((BigDecimal)changOutMny, (BigDecimal)newNetMny));
                            changOutTaxMny = ComputeUtil.convertToMinusNumber((BigDecimal)ComputeUtil.safeAdd((BigDecimal)changOutTaxMny, (BigDecimal)newNetTaxMny));
                        }
                    }
                    if (ComputeUtil.isEmpty((BigDecimal)useFlow.getOutNum()).booleanValue() && ComputeUtil.isEmpty((BigDecimal)useFlow.getOutLockNum()).booleanValue()) {
                        useFlow.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEABLE);
                    } else {
                        useFlow.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
                    }
                    flowUpdateList.add(useFlow);
                    if (!useBreakFlag) continue;
                    break;
                }
            }
            surplusVO.setOutLockMny(changOutMny);
            surplusVO.setOutLockTaxMny(changOutTaxMny);
            surplusVO.setSurplusMny(ComputeUtil.safeSub((BigDecimal)surplusVO.getSurplusMny(), (BigDecimal)changOutMny));
            surplusVO.setSurplusTaxMny(ComputeUtil.safeSub((BigDecimal)surplusVO.getSurplusTaxMny(), (BigDecimal)changOutTaxMny));
        }
        List useMaterialPriceVOList = BeanMapper.mapList((Iterable)flowVOList, UseMaterialPriceVO.class);
        ArrayList newInOutVOList = new ArrayList(inOutUpdateMap.values());
        Map<String, List<InOutVO>> newInOutMap = newInOutVOList.stream().collect(Collectors.groupingBy(x -> x.getMaterialId() + "@" + x.getBrandId()));
        useMaterialPriceVOList.forEach(t -> {
            List inOutVOS = (List)newInOutMap.get(t.getMaterialId() + "@" + t.getBrandId());
            if (CollectionUtils.isNotEmpty((Collection)inOutVOS)) {
                BigDecimal mny = null;
                BigDecimal taxMny = null;
                BigDecimal tax = null;
                BigDecimal purchaseMny = null;
                BigDecimal purchaseTaxMny = null;
                for (InOutVO in : inOutVOS) {
                    BigDecimal addMny = in.getOutNetMny();
                    BigDecimal addTaxMny = in.getOutNetTaxMny();
                    if (in.getDr() == 1) continue;
                    mny = ComputeUtil.safeAdd((BigDecimal)addMny, mny);
                    taxMny = ComputeUtil.safeAdd((BigDecimal)addTaxMny, taxMny);
                    purchaseMny = ComputeUtil.safeAdd((BigDecimal)in.getPurchaseMny(), purchaseMny);
                    purchaseTaxMny = ComputeUtil.safeAdd((BigDecimal)in.getPurchaseTaxMny(), purchaseTaxMny);
                    tax = ComputeUtil.safeSub((BigDecimal)purchaseTaxMny, (BigDecimal)purchaseMny);
                }
                t.setTax(tax);
                t.setMny(mny);
                t.setTaxMny(taxMny);
                t.setPurchaseMny(purchaseMny);
                t.setPurchaseTaxMny(purchaseTaxMny);
                BigDecimal price = ComputeUtil.safeDiv((BigDecimal)t.getMny(), (BigDecimal)t.getNum());
                BigDecimal taxPrice = ComputeUtil.safeDiv((BigDecimal)t.getTaxMny(), (BigDecimal)t.getNum());
                t.setPrice(price);
                t.setTaxPrice(taxPrice);
                BigDecimal purchasePrice = ComputeUtil.safeDiv((BigDecimal)t.getPurchaseMny(), (BigDecimal)t.getNum());
                BigDecimal purchaseTaxPrice = ComputeUtil.safeDiv((BigDecimal)t.getPurchaseTaxMny(), (BigDecimal)t.getNum());
                t.setPurchasePrice(purchasePrice);
                t.setPurchaseTaxPrice(purchaseTaxPrice);
            }
        });
        UseCalculateVO calculateVO = new UseCalculateVO();
        calculateVO.setStoreManageVO(storeManageVO);
        calculateVO.setUpdateFlowVOList(flowUpdateList);
        calculateVO.setUpdateInOutVOList(newInOutVOList);
        calculateVO.setUpdateSurplusVOList(new ArrayList(surplusUpdateMap.values()));
        calculateVO.setUseMaterialPriceVOList(useMaterialPriceVOList);
        return calculateVO;
    }

    @Override
    public UseCalculateVO turnOutRollBackByInOut(StoreManageVO storeManageVO, Boolean outEffectiveON) {
        UseCalculateVO calculateVO = new UseCalculateVO();
        List sourceIdsForRollBack = storeManageVO.getSourceIdsForRollBack();
        QueryWrapper inOutEntityQueryWrapper = new QueryWrapper();
        inOutEntityQueryWrapper.in((Object)"out_bill_id", (Collection)sourceIdsForRollBack);
        List inOutEntities = this.inOutService.list((Wrapper)inOutEntityQueryWrapper);
        List inOutVOs = BeanMapper.mapList((Iterable)inOutEntities, InOutVO.class);
        HashMap<Long, InOutVO> flowNum = new HashMap<Long, InOutVO>();
        HashMap<String, SurplusVO> surplusNum = new HashMap<String, SurplusVO>();
        ArrayList<Long> storeIds = new ArrayList<Long>();
        ArrayList<Long> materialIds = new ArrayList<Long>();
        ArrayList<Long> brandIds = new ArrayList<Long>();
        for (InOutVO t2 : inOutVOs) {
            Long inFlowId = t2.getInFlowId();
            InOutVO inOutVO = (InOutVO)flowNum.get(inFlowId);
            if (inOutVO == null) {
                inOutVO = new InOutVO();
            }
            BigDecimal _num = inOutVO.getNum();
            Long storeId = t2.getInStoreId();
            Long materialId = t2.getMaterialId();
            Long brandId = t2.getBrandId();
            String surplusKey = String.valueOf(storeId) + materialId + "@" + brandId;
            storeIds.add(storeId);
            materialIds.add(materialId);
            brandIds.add(brandId);
            SurplusVO surplusUpdateVO = (SurplusVO)surplusNum.get(surplusKey);
            if (surplusUpdateVO == null) {
                surplusUpdateVO = new SurplusVO();
            }
            BigDecimal surNum = surplusUpdateVO.getSurplusNum();
            BigDecimal surMny = surplusUpdateVO.getSurplusMny();
            BigDecimal surTaxMny = surplusUpdateVO.getSurplusTaxMny();
            if (outEffectiveON.booleanValue()) {
                BigDecimal returnStoreNum = t2.getReturnStoreNum();
                if (ComputeUtil.isNotEmpty((BigDecimal)returnStoreNum).booleanValue()) {
                    calculateVO.setErrorMsg("\u5355\u636e\u5df2\u53d1\u751f\u9000\u5e93\u4e1a\u52a1,\u4e0d\u5141\u8bb8\u5f03\u5ba1!");
                    return calculateVO;
                }
                BigDecimal outNum = t2.getOutNum();
                _num = ComputeUtil.safeAdd((BigDecimal)_num, (BigDecimal)outNum);
                surNum = ComputeUtil.safeAdd((BigDecimal)surNum, (BigDecimal)outNum);
                BigDecimal addMny = ComputeUtil.safeMultiply((BigDecimal)outNum, (BigDecimal)t2.getPrice());
                surMny = ComputeUtil.safeAdd((BigDecimal)surMny, (BigDecimal)addMny);
                BigDecimal addTaxMny = ComputeUtil.safeMultiply((BigDecimal)outNum, (BigDecimal)t2.getTaxPrice());
                surTaxMny = ComputeUtil.safeAdd((BigDecimal)surTaxMny, (BigDecimal)addTaxMny);
                t2.setOutLockNum(outNum);
                t2.setOutNum(BigDecimal.ZERO);
                t2.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
            } else {
                _num = ComputeUtil.safeAdd((BigDecimal)_num, (BigDecimal)t2.getOutLockNum());
                surNum = ComputeUtil.safeAdd((BigDecimal)surNum, (BigDecimal)t2.getOutLockNum());
                BigDecimal addMny = ComputeUtil.safeMultiply((BigDecimal)t2.getOutLockNum(), (BigDecimal)t2.getPrice());
                surMny = ComputeUtil.safeAdd((BigDecimal)surMny, (BigDecimal)addMny);
                BigDecimal addTaxMny = ComputeUtil.safeMultiply((BigDecimal)t2.getOutLockNum(), (BigDecimal)t2.getTaxPrice());
                surTaxMny = ComputeUtil.safeAdd((BigDecimal)surTaxMny, (BigDecimal)addTaxMny);
            }
            inOutVO.setNum(_num);
            inOutVO.setOutNetMny(ComputeUtil.safeAdd((BigDecimal)inOutVO.getOutNetMny(), (BigDecimal)t2.getOutNetMny()));
            inOutVO.setOutNetTaxMny(ComputeUtil.safeAdd((BigDecimal)inOutVO.getOutNetTaxMny(), (BigDecimal)t2.getOutNetTaxMny()));
            flowNum.put(inFlowId, inOutVO);
            surplusUpdateVO.setSurplusNum(surNum);
            surplusUpdateVO.setSurplusMny(ComputeUtil.safeAdd((BigDecimal)surplusUpdateVO.getSurplusMny(), (BigDecimal)t2.getOutNetMny()));
            surplusUpdateVO.setSurplusTaxMny(ComputeUtil.safeAdd((BigDecimal)surplusUpdateVO.getSurplusTaxMny(), (BigDecimal)t2.getOutNetMny()));
            surplusNum.put(surplusKey, surplusUpdateVO);
        }
        calculateVO.setUpdateInOutVOList(inOutVOs);
        List flowEntities = (List)this.flowService.listByIds(flowNum.keySet());
        List flowVOS = BeanMapper.mapList((Iterable)flowEntities, FlowVO.class);
        flowVOS.forEach(t -> {
            Long id = t.getId();
            InOutVO inOutVO = (InOutVO)flowNum.get(id);
            BigDecimal num = inOutVO.getNum();
            if (outEffectiveON.booleanValue()) {
                BigDecimal outLockNum = ComputeUtil.safeAdd((BigDecimal)t.getOutLockNum(), (BigDecimal)num);
                t.setOutLockNum(outLockNum);
                BigDecimal outNum = ComputeUtil.safeSub((BigDecimal)t.getOutNum(), (BigDecimal)num);
                t.setOutNum(outNum);
                t.setOutNetMny(ComputeUtil.safeSub((BigDecimal)t.getOutNetMny(), (BigDecimal)inOutVO.getOutNetMny()));
                t.setOutNetTaxMny(ComputeUtil.safeSub((BigDecimal)t.getOutNetTaxMny(), (BigDecimal)inOutVO.getOutNetTaxMny()));
            } else {
                BigDecimal outLockNum = ComputeUtil.safeSub((BigDecimal)t.getOutLockNum(), (BigDecimal)num);
                t.setOutLockNum(outLockNum);
                BigDecimal surplusNumNew = ComputeUtil.safeAdd((BigDecimal)t.getSurplusNum(), (BigDecimal)num);
                t.setSurplusNum(surplusNumNew);
                t.setNetMny(ComputeUtil.safeAdd((BigDecimal)t.getNetMny(), (BigDecimal)inOutVO.getOutNetMny()));
                t.setNetTaxMny(ComputeUtil.safeAdd((BigDecimal)t.getNetTaxMny(), (BigDecimal)inOutVO.getOutNetTaxMny()));
            }
            if (ComputeUtil.equals((BigDecimal)t.getSurplusNum(), (BigDecimal)t.getNum())) {
                t.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEABLE);
            } else if (ComputeUtil.isEmpty((BigDecimal)t.getSurplusNum()).booleanValue()) {
                t.setOutUseFlag(StoreCommonConsts.UseOutFlag.USE_FINISH);
            } else {
                t.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
            }
        });
        calculateVO.setUpdateFlowVOList(flowVOS);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"store_id", storeIds);
        queryWrapper.in((Object)"material_id", materialIds);
        queryWrapper.in((Object)"brand_id", brandIds);
        List list = this.list((Wrapper)queryWrapper);
        List surplusVOS = BeanMapper.mapList((Iterable)list, SurplusVO.class);
        surplusVOS.forEach(t -> {
            String key = String.valueOf(t.getStoreId()) + t.getMaterialId() + "@" + t.getBrandId();
            SurplusVO surplusVO = (SurplusVO)surplusNum.get(key);
            BigDecimal _surplusNum = surplusVO.getSurplusNum();
            if (outEffectiveON.booleanValue()) {
                BigDecimal outLockNum = ComputeUtil.safeAdd((BigDecimal)t.getOutLockNum(), (BigDecimal)_surplusNum);
                t.setOutLockNum(outLockNum);
                t.setOutLockMny(ComputeUtil.safeAdd((BigDecimal)t.getOutLockMny(), (BigDecimal)surplusVO.getSurplusMny()));
                t.setOutLockTaxMny(ComputeUtil.safeAdd((BigDecimal)t.getOutLockTaxMny(), (BigDecimal)surplusVO.getSurplusTaxMny()));
            } else {
                BigDecimal outLockNum = ComputeUtil.safeSub((BigDecimal)t.getOutLockNum(), (BigDecimal)_surplusNum);
                t.setOutLockNum(outLockNum);
                BigDecimal surplusNumNew = ComputeUtil.safeAdd((BigDecimal)t.getSurplusNum(), (BigDecimal)_surplusNum);
                t.setSurplusNum(surplusNumNew);
                BigDecimal taxMny = ComputeUtil.safeAdd((BigDecimal)surplusVO.getSurplusTaxMny(), (BigDecimal)t.getSurplusTaxMny());
                t.setSurplusTaxMny(taxMny);
                BigDecimal mny = ComputeUtil.safeAdd((BigDecimal)surplusVO.getSurplusMny(), (BigDecimal)t.getSurplusMny());
                t.setSurplusMny(mny);
                t.setOutLockMny(ComputeUtil.safeSub((BigDecimal)t.getOutLockMny(), (BigDecimal)surplusVO.getSurplusMny()));
                t.setOutLockTaxMny(ComputeUtil.safeSub((BigDecimal)t.getOutLockTaxMny(), (BigDecimal)surplusVO.getSurplusTaxMny()));
            }
        });
        calculateVO.setUpdateSurplusVOList(surplusVOS);
        return calculateVO;
    }

    @Override
    public CommonResponse<SurplusUpdateVO> validateStoreSurplusByOutLock(StoreManageVO storeManageVO) {
        Long storeId = storeManageVO.getStoreId();
        Long sourceId = storeManageVO.getSourceId();
        List flowVOList = storeManageVO.getFlowVOList();
        SurplusUpdateVO surplusUpdateVO = StoreManageUtil.getSurplusUpdateVO((Long)storeId, (List)flowVOList, (boolean)false);
        Collection inOutEntityList = null;
        if (sourceId != null) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"out_bill_id", (Object)sourceId);
            queryWrapper.eq((Object)"effective_state", (Object)StoreCommonConsts.NO);
            inOutEntityList = this.inOutService.list((Wrapper)queryWrapper);
        }
        if (CollectionUtils.isNotEmpty(inOutEntityList)) {
            Map<String, List<InOutEntity>> inOutMap = inOutEntityList.stream().collect(Collectors.groupingBy(x -> x.getMaterialId() + "@" + x.getBrandId()));
            HashMap inOutNumMap = new HashMap();
            inOutMap.forEach((k, v) -> inOutNumMap.put(k, v.stream().map(InOutEntity::getOutLockNum).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd)));
            HashMap<String, SurplusVO> surplusValidateMap = new HashMap<String, SurplusVO>();
            for (FlowVO flowVO : flowVOList) {
                if ("del".equals(flowVO.getRowState())) continue;
                String key = flowVO.getMaterialId() + "@" + flowVO.getBrandId();
                SurplusVO surplusVO = (SurplusVO)surplusValidateMap.get(key);
                BigDecimal oldNum = (BigDecimal)inOutNumMap.get(key);
                BigDecimal num = flowVO.getNum();
                BigDecimal _num = ComputeUtil.safeSub((BigDecimal)num, (BigDecimal)oldNum);
                if (null != surplusVO) {
                    BigDecimal surplusNum = surplusVO.getSurplusNum();
                    surplusNum = ComputeUtil.safeAdd((BigDecimal)surplusNum, (BigDecimal)_num);
                    surplusVO.setSurplusNum(surplusNum);
                    BigDecimal outLockNum = surplusVO.getOutLockNum();
                    outLockNum = ComputeUtil.safeAdd((BigDecimal)outLockNum, (BigDecimal)oldNum);
                    surplusVO.setOutLockNum(outLockNum);
                } else {
                    surplusVO = (SurplusVO)BeanMapper.map((Object)flowVO, SurplusVO.class);
                    surplusVO.setSurplusNum(_num);
                    surplusVO.setOutLockNum(oldNum);
                }
                if (!ComputeUtil.isGreaterThan((BigDecimal)surplusVO.getSurplusNum(), (BigDecimal)BigDecimal.ZERO)) continue;
                surplusValidateMap.put(key, surplusVO);
            }
            surplusUpdateVO.setSurplusVOList(new ArrayList(surplusValidateMap.values()));
        }
        return this.validateSurplus(surplusUpdateVO, storeManageVO.getInOutTypeEnum());
    }

    @Override
    public List<SurplusVO> querySurplusBatch(List<SurplusVO> vos) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.and(q -> {
            for (SurplusVO f : vos) {
                if (null != f.getStoreId()) {
                    q.or(iq -> (QueryWrapper)((QueryWrapper)((QueryWrapper)iq.eq((Object)"store_id", (Object)f.getStoreId())).eq((Object)"brand_id", (Object)f.getBrandId())).eq((Object)"material_id", (Object)f.getMaterialId()));
                    continue;
                }
                q.or(iq -> (QueryWrapper)((QueryWrapper)((QueryWrapper)iq.eq((Object)"project_id", (Object)f.getProjectId())).eq((Object)"brand_id", (Object)f.getBrandId())).eq((Object)"material_id", (Object)f.getMaterialId()));
            }
            return q;
        });
        List list = this.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List result = BeanMapper.mapList((Iterable)list, SurplusVO.class);
            for (SurplusVO surplusVO : result) {
                surplusVO.setSurplusTaxPrice(ComputeUtil.safeDiv((BigDecimal)surplusVO.getSurplusTaxMny(), (BigDecimal)surplusVO.getSurplusNum()));
                surplusVO.setSurplusPrice(ComputeUtil.safeDiv((BigDecimal)surplusVO.getSurplusMny(), (BigDecimal)surplusVO.getSurplusNum()));
                surplusVO.setSurplusNum(ComputeUtil.safeSub((BigDecimal)surplusVO.getSurplusNum(), (BigDecimal)surplusVO.getIdleNum()));
            }
            return result;
        }
        return null;
    }
}

