package com.ejianc.business.zdsstore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.erp.api.IZDSContractApi;
import com.ejianc.business.zdsmaterial.erp.vo.OrderDetailVO;
import com.ejianc.business.zdsstore.bean.ReturnGoodsEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.mapper.ReturnGoodsMapper;
import com.ejianc.business.zdsstore.service.IReturnGoodsService;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.ReturnGoodsVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 材料退货表
 * 
 * @author generator
 * 
 */
@Service("returnGoodsService")
public class ReturnGoodsServiceImpl extends BaseServiceImpl<ReturnGoodsMapper, ReturnGoodsEntity> implements IReturnGoodsService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ReturnGoodsMapper returnGoodsMapper;
    @Autowired
    private StoreManageService storeManageService;

    @Autowired
    private ISurplusService surplusService;

    @Autowired
    private JedisPool jedisPool;

    private final String OPERATE = "returnGoodsBill";


    /**
     * 根据合同id 查询当前合同是否有未生效单据
     * @param contractId
     * @return
     */
    @Override
    public ReturnGoodsVO queryByContractId(Long contractId) {
        ReturnGoodsVO resp = null;
        QueryWrapper<ReturnGoodsEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);
        query.eq("bill_state", BillStateEnum.UNCOMMITED_STATE);
        query.eq("dr", BaseVO.DR_UNDELETE);
        ReturnGoodsEntity entity = returnGoodsMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, ReturnGoodsVO.class);
        }
        return resp;
    }

    @Override
    public void removeByPickReturnIds(List<Long> ids) {
        checkRollback(ids);
        this.removeByIds(ids,true);
    }

    @Transactional(rollbackFor = Exception.class)
    public void checkRollback(List<Long> ids){
        StoreManageVO storeManageVO = new StoreManageVO();

        QueryWrapper<ReturnGoodsEntity> query = new QueryWrapper<>();
        query.in("id", ids);
        List<ReturnGoodsEntity> eList = super.list(query);

        List<Long> SourceIds = new ArrayList<>();
        for (ReturnGoodsEntity e : eList) {
            SourceIds.clear();
            SourceIds.add(e.getId());
            storeManageVO.setSourceId(e.getId());
            storeManageVO.setStoreId(e.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.材料退货);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setOutEffectiveON(false);
            CommonResponse<StoreManageVO> rollbackCommonResponse = storeManageService.inOutStoreRollback(storeManageVO);

            if(!rollbackCommonResponse.isSuccess()){
                logger.error("材料退货推送库存流水失败, {}", JSONObject.toJSONString(rollbackCommonResponse, SerializerFeature.PrettyFormat));
                throw new BusinessException(StringUtils.isNotBlank(rollbackCommonResponse.getMsg()) ? rollbackCommonResponse.getMsg() : "删除失败，更新库存信息失败！");
            }
        }
    };

    @Override
    public ReturnGoodsVO saveOrUpdateReturnGoods(ReturnGoodsVO saveOrUpdateVO) {
        if(null != saveOrUpdateVO.getId()) {
            //废弃之前的库存占用
            checkRollback(Arrays.asList(new Long[]{saveOrUpdateVO.getId()}));
        }
        ReturnGoodsEntity entity = BeanMapper.map(saveOrUpdateVO, ReturnGoodsEntity.class);
        super.saveOrUpdate(entity, false);

        //推送新的库存占用
        saveStore(BeanMapper.map(entity, ReturnGoodsVO.class));

        return BeanMapper.map(entity, ReturnGoodsVO.class);
    }

    @Override
    public void syncSignStatus(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String billData = request.getParameter("billData");
        logger.info("接收到供方材料退货信息：{}", billData);
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);
        ReturnGoodsVO returnGoodsVO = JSONObject.parseObject(billData, ReturnGoodsVO.class);
        Long orderId = Long.valueOf(returnGoodsVO.getSourceId());

        Jedis jedis = null;
        boolean locked = false;
        String key = OPERATE + "::" + orderId.toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);
            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, "EJCBT202312000016", authority, orderId.toString());
            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中



            ReturnGoodsEntity returnGoodsEntity = super.selectById(orderId);
            returnGoodsEntity.setAttachIds(attchIdsList);
            returnGoodsEntity.setSignStatus(returnGoodsVO.getSignStatus());
            returnGoodsEntity.setSignTime(returnGoodsVO.getSignTime());
            returnGoodsEntity.setSignUserId(returnGoodsVO.getSignUserId());
            returnGoodsEntity.setSignUserName(returnGoodsVO.getSignUserName());
            returnGoodsEntity.setSignUserPhone(returnGoodsVO.getSignUserPhone());

            super.saveOrUpdate(returnGoodsEntity, false);
        } catch (Exception e) {
            logger.error("材料退货id-{}签字状态同步异常，", orderId, e);
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
    }
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }

    private void saveStore(ReturnGoodsVO saveOrUpdateVO) {
        if(saveOrUpdateVO!=null && saveOrUpdateVO.getReturnGoodsDetailList().size()>0){
            StoreManageVO storeManageVO = saveOrUpdateVO.getStoreManageVO(saveOrUpdateVO);
            //设置为未生效
            storeManageVO.setOutEffectiveON(false);

//            List<SurplusVO> queryVos = new ArrayList<>();
//            Map<String, FlowVO> flowMap = new HashMap<>();
//            storeManageVO.getFlowVOList().stream().forEach(flow -> {
//                SurplusVO s = new SurplusVO();
//                s.setStoreId(saveOrUpdateVO.getStoreId());
//                s.setBrandId(flow.getBrandId());
//                s.setMaterialId(flow.getMaterialId());
//                flowMap.put(flow.getMaterialId() + "-" + flow.getBrandId(), flow);
//                queryVos.add(s);
//            });

//            List<SurplusVO> queryRs = surplusService.querySurplusBatch(queryVos);
//            FlowVO tmp = null;
//            for(SurplusVO s : queryRs) {
//                tmp = flowMap.get(s.getMaterialId() + "-" + s.getBrandId());
//                if(null != tmp) {
//                    tmp.setPrice(s.getSurplusPrice());
//                    tmp.setTaxPrice(s.getSurplusTaxPrice());
//                    tmp.setMny(ComputeUtil.safeMultiply(tmp.getNum(), tmp.getPrice()));
//                    tmp.setTaxMny(ComputeUtil.safeMultiply(tmp.getNum(), tmp.getTaxPrice()));
//                    tmp.setTax(ComputeUtil.safeSub(tmp.getTaxMny(), tmp.getMny()));
//                    tmp.setTaxRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(tmp.getTax(), tmp.getTaxMny()), new BigDecimal("100")));
//                }
//            }

            CommonResponse<StoreManageVO> saveStoreResp = storeManageService.inOutStore(storeManageVO);
            if(!saveStoreResp.isSuccess()) {
                logger.error("材料退货推送库存流水失败, {}", JSONObject.toJSONString(saveStoreResp, SerializerFeature.PrettyFormat));
                throw new BusinessException(StringUtils.isNotBlank(saveStoreResp.getMsg()) ? saveStoreResp.getMsg() : "保存失败，更新库存信息失败！");
            }
        }

    }
}
