/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.zdsstore.bean.CheckDetailEntity;
import com.ejianc.business.zdsstore.bean.CheckEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.controller.FlowController;
import com.ejianc.business.zdsstore.mapper.CheckDetailMapper;
import com.ejianc.business.zdsstore.mapper.CheckMapper;
import com.ejianc.business.zdsstore.service.ICheckService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.CheckVO;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private CheckDetailMapper checkDetailMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private CheckMapper checkMapper;
    private static final String BILL_CODE = "STORE_CHECK_CODE";
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private FlowController flowHandle;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICheckService service;

    @Override
    public CommonResponse saveCheckStore(CheckEntity entity) {
        Long projectId = entity.getProjectId();
        Long storeId = entity.getStoreId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.eq((Object)"store_id", (Object)storeId);
        wrapper.eq((Object)"bill_state", (Object)StoreCommonConsts.ZERO);
        List list = super.list((Wrapper)wrapper);
        Integer checkCount = list.size();
        if (null == entity.getId() ? checkCount > 0 : checkCount > 1) {
            return CommonResponse.error((String)"\u8be5\u4ed3\u5e93\u5df2\u4e0b\u5b58\u5728\u81ea\u7531\u6001\u76d8\u70b9\u5355\uff01");
        }
        if (null != entity.getId()) {
            Map<String, CheckDetailEntity> currentDetailMap = entity.getCheckSubList().stream().filter(item -> !"del".equals(item.getRowState()) && item.getInventory().compareTo(BigDecimal.ZERO) < 0).collect(Collectors.toMap(item -> item.getMaterialId() + "-" + item.getBrandId(), item -> item));
            CheckEntity dbEntity = (CheckEntity)((Object)super.selectById((Serializable)entity.getId()));
            HashSet updateStoreList = new HashSet();
            dbEntity.getCheckSubList().stream().filter(item -> item.getInventory().compareTo(BigDecimal.ZERO) < 0).forEach(dbDetail -> {
                if (!currentDetailMap.containsKey(dbDetail.getMaterialId() + "-" + dbDetail.getBrandId())) {
                    updateStoreList.add(dbDetail);
                }
            });
            this.checkDetailMapper.delByCheckId(entity.getId());
        }
        super.saveOrUpdate((Object)entity, false);
        List<CheckDetailEntity> checkSubList = entity.getCheckSubList();
        ArrayList subList = new ArrayList();
        checkSubList.forEach(item -> {
            if (item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) < 0 && item.getStoreMaterialFlag() == 1) {
                subList.add(item);
            }
        });
        HashMap checkMap = new HashMap();
        String materialIds = "[";
        for (CheckDetailEntity item2 : subList) {
            materialIds = materialIds + item2.getMaterialId() + ",";
        }
        materialIds = materialIds.substring(0, materialIds.length() - 1) + "]";
        String condition = "{projectId:" + entity.getProjectId() + ",storeId:" + entity.getStoreId() + ",materialIds:" + materialIds + "}";
        if (subList.size() > 0) {
            CommonResponse<IPage<FlowVO>> iPageCommonResponse = this.flowHandle.refInstoreFlowData(1, 1000, condition, "", "");
            if (!iPageCommonResponse.isSuccess() || null == iPageCommonResponse.getData()) {
                return CommonResponse.error((String)"\u83b7\u53d6\u6700\u65b0\u6570\u91cf\u5931\u8d25\uff01");
            }
            List records = ((IPage)iPageCommonResponse.getData()).getRecords();
            records.forEach(item -> checkMap.put(item.getMaterialId() + "-" + item.getBrandId(), item));
            for (CheckDetailEntity item3 : subList) {
                FlowVO flowVO = (FlowVO)checkMap.get(item3.getMaterialId() + "-" + item3.getBrandId());
                if (null == flowVO) {
                    return CommonResponse.error((String)("\u3010" + item3.getMaterialName() + "_" + item3.getBrandName() + "_" + item3.getSpec() + "\u3011\u5e93\u5b58\u53ef\u7528\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u5f62\u6210\u76d8\u4e8f\u51fa\u5e93\u5355\uff1b  \u4e0d\u53ef\u4fdd\u5b58"));
                }
                if (item3.getInventory().add(flowVO.getSurplusNum()).compareTo(BigDecimal.ZERO) >= 0) continue;
                return CommonResponse.error((String)("\u3010" + item3.getMaterialName() + "_" + item3.getBrandName() + "_" + item3.getSpec() + "\u3011\u5e93\u5b58\u53ef\u7528\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u5f62\u6210\u76d8\u4e8f\u51fa\u5e93\u5355\uff1b  \u4e0d\u53ef\u4fdd\u5b58"));
            }
        }
        return CommonResponse.success((Object)((Object)entity));
    }

    @Override
    public CommonResponse myRemoveByIds(List<Long> ids) {
        super.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse checkRollback(List<Long> ids) {
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        for (Long item : ids) {
            CheckEntity entity = (CheckEntity)((Object)super.selectById((Serializable)item));
            List<CheckDetailEntity> checkSubList = entity.getCheckSubList();
            Boolean checkFalg = false;
            for (CheckDetailEntity t : checkSubList) {
                if (t.getInventory().compareTo(BigDecimal.ZERO) >= 0) continue;
                checkFalg = true;
                break;
            }
            if (!checkFalg.booleanValue()) continue;
            SourceIds.clear();
            SourceIds.add(item);
            storeManageVO.setSourceId(item);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76d8\u4e8f\u51fa\u5e93);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            CommonResponse<StoreManageVO> rollbackCommonResponse = this.storeManageService.inOutStoreRollback(storeManageVO);
            if (rollbackCommonResponse.isSuccess()) continue;
            return rollbackCommonResponse;
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse checkOut(List<Long> ids) {
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        for (Long item : ids) {
            CheckEntity entity = (CheckEntity)((Object)super.selectById((Serializable)item));
            SourceIds.clear();
            SourceIds.add(item);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76d8\u4e8f\u51fa\u5e93);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setSourceId(item);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            CommonResponse<StoreManageVO> rollbackCommonResponse = this.storeManageService.inOutStore(storeManageVO);
            if (rollbackCommonResponse.isSuccess()) continue;
            return rollbackCommonResponse;
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse checkByDate(Long storeId, String checkDate) {
        List<CheckEntity> checkEntities = this.checkMapper.queryByDate(storeId, checkDate);
        if (checkEntities.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u65f6\u95f4\u70b9\u540e\u5df2\u53d1\u751f\u4ed3\u5e93\u76d8\u70b9\u5355");
        }
        return CommonResponse.success();
    }

    @Override
    public CheckVO saveOrUpdate(CheckVO saveOrUpdateVO) {
        CheckEntity entity = (CheckEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CheckEntity.class));
        if (!ListUtil.isEmpty((List)saveOrUpdateVO.getCheckSubList())) {
            entity.setCheckSubList(BeanMapper.mapList((Iterable)saveOrUpdateVO.getCheckSubList(), CheckDetailEntity.class));
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.setProportionFlag("0");
                entity.setRelationFlag("0");
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        CommonResponse commonResponse = this.service.saveCheckStore(entity);
        if (!commonResponse.isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
        CheckVO vo = (CheckVO)BeanMapper.map((Object)commonResponse.getData(), CheckVO.class);
        return vo;
    }
}

